/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.Iterator;
import org.jogamp.java3d.AlternateAppearanceRetained;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BoundingLeaf;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Leaf;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.NodeReferenceTable;
import org.jogamp.java3d.SceneGraphObject;

public class AlternateAppearance
extends Leaf {
    public static final int ALLOW_INFLUENCING_BOUNDS_READ = 12;
    public static final int ALLOW_INFLUENCING_BOUNDS_WRITE = 13;
    public static final int ALLOW_APPEARANCE_READ = 14;
    public static final int ALLOW_APPEARANCE_WRITE = 15;
    public static final int ALLOW_SCOPE_READ = 16;
    public static final int ALLOW_SCOPE_WRITE = 17;
    private static final int[] readCapabilities = new int[]{12, 14, 16};

    public AlternateAppearance() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public AlternateAppearance(Appearance appearance) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((AlternateAppearanceRetained)this.retained).initAppearance(appearance);
    }

    @Override
    void createRetained() {
        this.retained = new AlternateAppearanceRetained();
        this.retained.setSource(this);
    }

    public void setAppearance(Appearance appearance) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance0"));
        }
        if (this.isLive()) {
            ((AlternateAppearanceRetained)this.retained).setAppearance(appearance);
        } else {
            ((AlternateAppearanceRetained)this.retained).initAppearance(appearance);
        }
    }

    public Appearance getAppearance() {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance2"));
        }
        return ((AlternateAppearanceRetained)this.retained).getAppearance();
    }

    public void setInfluencingBounds(Bounds region) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance3"));
        }
        if (this.isLive()) {
            ((AlternateAppearanceRetained)this.retained).setInfluencingBounds(region);
        } else {
            ((AlternateAppearanceRetained)this.retained).initInfluencingBounds(region);
        }
    }

    public Bounds getInfluencingBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance4"));
        }
        return ((AlternateAppearanceRetained)this.retained).getInfluencingBounds();
    }

    public void setInfluencingBoundingLeaf(BoundingLeaf region) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance3"));
        }
        if (this.isLive()) {
            ((AlternateAppearanceRetained)this.retained).setInfluencingBoundingLeaf(region);
        } else {
            ((AlternateAppearanceRetained)this.retained).initInfluencingBoundingLeaf(region);
        }
    }

    public BoundingLeaf getInfluencingBoundingLeaf() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance4"));
        }
        return ((AlternateAppearanceRetained)this.retained).getInfluencingBoundingLeaf();
    }

    public void setScope(Group scope, int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance7"));
        }
        if (this.isLive()) {
            ((AlternateAppearanceRetained)this.retained).setScope(scope, index);
        } else {
            ((AlternateAppearanceRetained)this.retained).initScope(scope, index);
        }
    }

    public Group getScope(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance8"));
        }
        return ((AlternateAppearanceRetained)this.retained).getScope(index);
    }

    public void insertScope(Group scope, int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance9"));
        }
        if (this.isLive()) {
            ((AlternateAppearanceRetained)this.retained).insertScope(scope, index);
        } else {
            ((AlternateAppearanceRetained)this.retained).initInsertScope(scope, index);
        }
    }

    public void removeScope(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance10"));
        }
        if (this.isLive()) {
            ((AlternateAppearanceRetained)this.retained).removeScope(index);
        } else {
            ((AlternateAppearanceRetained)this.retained).initRemoveScope(index);
        }
    }

    public Iterator<Group> getAllScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance11"));
        }
        return ((AlternateAppearanceRetained)this.retained).getAllScopes();
    }

    public void addScope(Group scope) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance12"));
        }
        if (this.isLive()) {
            ((AlternateAppearanceRetained)this.retained).addScope(scope);
        } else {
            ((AlternateAppearanceRetained)this.retained).initAddScope(scope);
        }
    }

    public int numScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance11"));
        }
        return ((AlternateAppearanceRetained)this.retained).numScopes();
    }

    public int indexOfScope(Group scope) {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance8"));
        }
        return ((AlternateAppearanceRetained)this.retained).indexOfScope(scope);
    }

    public void removeScope(Group scope) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance10"));
        }
        if (this.isLive()) {
            ((AlternateAppearanceRetained)this.retained).removeScope(scope);
        } else {
            ((AlternateAppearanceRetained)this.retained).initRemoveScope(scope);
        }
    }

    public void removeAllScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance10"));
        }
        if (this.isLive()) {
            ((AlternateAppearanceRetained)this.retained).removeAllScopes();
        } else {
            ((AlternateAppearanceRetained)this.retained).initRemoveAllScopes();
        }
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        AlternateAppearanceRetained attr = (AlternateAppearanceRetained)originalNode.retained;
        AlternateAppearanceRetained rt = (AlternateAppearanceRetained)this.retained;
        rt.initAppearance((Appearance)this.getNodeComponent(attr.getAppearance(), forceDuplicate, originalNode.nodeHashtable));
        rt.initInfluencingBounds(attr.getInfluencingBounds());
        Iterator<Group> elm = attr.getAllScopes();
        while (elm.hasNext()) {
            rt.initAddScope(elm.next());
        }
        rt.initInfluencingBoundingLeaf(attr.getInfluencingBoundingLeaf());
    }

    @Override
    public void updateNodeReferences(NodeReferenceTable referenceTable) {
        AlternateAppearanceRetained rt = (AlternateAppearanceRetained)this.retained;
        BoundingLeaf bl = rt.getInfluencingBoundingLeaf();
        if (bl != null) {
            SceneGraphObject o = referenceTable.getNewObjectReference(bl);
            rt.initInfluencingBoundingLeaf((BoundingLeaf)o);
        }
        int num = rt.numScopes();
        for (int i = 0; i < num; ++i) {
            rt.initScope((Group)referenceTable.getNewObjectReference(rt.getScope(i)), i);
        }
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        AlternateAppearance app = new AlternateAppearance();
        app.duplicateNode(this, forceDuplicate);
        return app;
    }
}

