/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.ImageComponent;
import org.jogamp.java3d.ImageComponent3DRetained;
import org.jogamp.java3d.ImageComponentRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NioImageBuffer;
import org.jogamp.java3d.NodeComponent;

public class ImageComponent3D
extends ImageComponent {
    ImageComponent3D() {
    }

    public ImageComponent3D(int format, int width, int height, int depth) {
        ((ImageComponent3DRetained)this.retained).processParams(format, width, height, depth);
    }

    public ImageComponent3D(int format, BufferedImage[] images) {
        ((ImageComponent3DRetained)this.retained).processParams(format, images[0].getWidth(null), images[0].getHeight(null), images.length);
        for (int i = 0; i < images.length; ++i) {
            ((ImageComponent3DRetained)this.retained).set(i, images[i]);
        }
    }

    public ImageComponent3D(int format, RenderedImage[] images) {
        ((ImageComponent3DRetained)this.retained).processParams(format, images[0].getWidth(), images[0].getHeight(), images.length);
        for (int i = 0; i < images.length; ++i) {
            ((ImageComponent3DRetained)this.retained).set(i, images[i]);
        }
    }

    public ImageComponent3D(int format, int width, int height, int depth, boolean byReference, boolean yUp) {
        ((ImageComponentRetained)this.retained).setByReference(byReference);
        ((ImageComponentRetained)this.retained).setYUp(yUp);
        ((ImageComponent3DRetained)this.retained).processParams(format, width, height, depth);
    }

    public ImageComponent3D(int format, BufferedImage[] images, boolean byReference, boolean yUp) {
        ((ImageComponentRetained)this.retained).setByReference(byReference);
        ((ImageComponentRetained)this.retained).setYUp(yUp);
        ((ImageComponent3DRetained)this.retained).processParams(format, images[0].getWidth(null), images[0].getHeight(null), images.length);
        for (int i = 0; i < images.length; ++i) {
            ((ImageComponent3DRetained)this.retained).set(i, images[i]);
        }
    }

    public ImageComponent3D(int format, RenderedImage[] images, boolean byReference, boolean yUp) {
        ((ImageComponentRetained)this.retained).setByReference(byReference);
        ((ImageComponentRetained)this.retained).setYUp(yUp);
        ((ImageComponent3DRetained)this.retained).processParams(format, images[0].getWidth(), images[0].getHeight(), images.length);
        for (int i = 0; i < images.length; ++i) {
            ((ImageComponent3DRetained)this.retained).set(i, images[i]);
        }
    }

    public ImageComponent3D(int format, NioImageBuffer[] images, boolean byReference, boolean yUp) {
        throw new UnsupportedOperationException();
    }

    public int getDepth() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent3D0"));
        }
        return ((ImageComponent3DRetained)this.retained).getDepth();
    }

    public void set(BufferedImage[] images) {
        this.checkForLiveOrCompiled();
        int depth = ((ImageComponent3DRetained)this.retained).getDepth();
        if (depth != images.length) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D1"));
        }
        for (int i = 0; i < depth; ++i) {
            ((ImageComponent3DRetained)this.retained).set(i, images[i]);
        }
    }

    public void set(RenderedImage[] images) {
        this.checkForLiveOrCompiled();
        int depth = ((ImageComponent3DRetained)this.retained).getDepth();
        if (depth != images.length) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D1"));
        }
        for (int i = 0; i < depth; ++i) {
            ((ImageComponent3DRetained)this.retained).set(i, images[i]);
        }
    }

    public void set(NioImageBuffer[] images) {
        throw new UnsupportedOperationException();
    }

    public void set(int index, BufferedImage image) {
        this.checkForLiveOrCompiled();
        if (image.getWidth(null) != this.getWidth()) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D2"));
        }
        if (image.getHeight(null) != this.getHeight()) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D4"));
        }
        ((ImageComponent3DRetained)this.retained).set(index, image);
    }

    public void set(int index, RenderedImage image) {
        this.checkForLiveOrCompiled();
        ((ImageComponent3DRetained)this.retained).set(index, image);
    }

    public void set(int index, NioImageBuffer image) {
        throw new UnsupportedOperationException();
    }

    public BufferedImage[] getImage() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent3D3"));
        }
        return ((ImageComponent3DRetained)this.retained).getImage();
    }

    public RenderedImage[] getRenderedImage() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent3D3"));
        }
        return ((ImageComponent3DRetained)this.retained).getRenderedImage();
    }

    public NioImageBuffer[] getNioImage() {
        throw new UnsupportedOperationException();
    }

    public BufferedImage getImage(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent3D3"));
        }
        RenderedImage img = ((ImageComponent3DRetained)this.retained).getImage(index);
        if (img != null && !(img instanceof BufferedImage)) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent3D9"));
        }
        return (BufferedImage)img;
    }

    public RenderedImage getRenderedImage(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent3D3"));
        }
        return ((ImageComponent3DRetained)this.retained).getImage(index);
    }

    public NioImageBuffer getNioImage(int index) {
        throw new UnsupportedOperationException();
    }

    public void setSubImage(int index, RenderedImage image, int width, int height, int srcX, int srcY, int dstX, int dstY) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent3D5"));
        }
        if (((ImageComponent3DRetained)this.retained).isByReference()) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent3D8"));
        }
        int w = ((ImageComponent3DRetained)this.retained).getWidth();
        int h = ((ImageComponent3DRetained)this.retained).getHeight();
        if (srcX < 0 || srcY < 0 || srcX + width > w || srcY + height > h || dstX < 0 || dstY < 0 || dstX + width > w || dstY + height > h) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D7"));
        }
        ((ImageComponent3DRetained)this.retained).setSubImage(index, image, width, height, srcX, srcY, dstX, dstY);
    }

    public void updateData(Updater updater, int index, int x, int y, int width, int height) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent3D5"));
        }
        if (!((ImageComponent3DRetained)this.retained).isByReference()) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent3D6"));
        }
        int w = ((ImageComponent3DRetained)this.retained).getWidth();
        int h = ((ImageComponent3DRetained)this.retained).getHeight();
        if (x < 0 || y < 0 || x + width > w || y + height > h) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D7"));
        }
        ((ImageComponent3DRetained)this.retained).updateData(updater, index, x, y, width, height);
    }

    @Override
    void createRetained() {
        this.retained = new ImageComponent3DRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        ImageComponent3DRetained rt = (ImageComponent3DRetained)this.retained;
        ImageComponent3D img = new ImageComponent3D(rt.getFormat(), rt.width, rt.height, rt.depth);
        img.duplicateNodeComponent(this);
        return img;
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        BufferedImage[] imgs = ((ImageComponent3DRetained)originalNodeComponent.retained).getImage();
        if (imgs != null) {
            ImageComponent3DRetained rt = (ImageComponent3DRetained)this.retained;
            for (int i = rt.depth - 1; i >= 0; --i) {
                if (imgs[i] == null) continue;
                rt.set(i, (RenderedImage)imgs[i]);
            }
        }
    }

    public static interface Updater {
        public void updateData(ImageComponent3D var1, int var2, int var3, int var4, int var5, int var6);
    }
}

