/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.AmbientLightRetained;
import org.jogamp.java3d.BackgroundRetained;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.EnvironmentSet;
import org.jogamp.java3d.LightRetained;
import org.jogamp.java3d.ObjectUpdate;
import org.jogamp.java3d.OrderedCollection;
import org.jogamp.java3d.PointLightRetained;
import org.jogamp.java3d.RenderBin;
import org.jogamp.java3d.VirtualUniverse;

class LightBin
implements ObjectUpdate {
    int maxLights = -1;
    LightRetained[] lights = null;
    int[] lightsRef = null;
    int numEmptySlots = -1;
    RenderBin renderBin = null;
    LightBin next = null;
    LightBin prev = null;
    EnvironmentSet environmentSetList = null;
    ArrayList<EnvironmentSet> insertEnvSet = new ArrayList();
    int canvasDirty = 0;
    int lightDirtyMaskCache = 0;
    int lightDirtyMask = 0;
    ArrayList<PointLightRetained> pointLts = new ArrayList();
    int[] pointLtsSlotIndex;
    OrderedCollection orderedCollection = null;
    boolean onUpdateList = false;
    BackgroundRetained geometryBackground = null;

    LightBin(int maxLights, RenderBin rb, boolean isOpaque) {
        this.maxLights = maxLights;
        this.numEmptySlots = maxLights;
        this.lights = new LightRetained[maxLights];
        this.lightsRef = new int[maxLights];
        this.renderBin = rb;
    }

    void reset(boolean inOpaque) {
        this.prev = null;
        this.next = null;
        this.orderedCollection = null;
        this.environmentSetList = null;
        this.onUpdateList = false;
        this.geometryBackground = null;
    }

    void setOrderedInfo(OrderedCollection oc) {
        this.orderedCollection = oc;
    }

    boolean willEnvironmentSetFit(EnvironmentSet e) {
        int numEsLights;
        int slotsNeeded = numEsLights = e.lights.size();
        block0: for (int i = 0; i < numEsLights; ++i) {
            LightRetained light = e.lights.get(i);
            if (light instanceof AmbientLightRetained) continue;
            for (int j = 0; j < this.maxLights; ++j) {
                if (this.lights[j] != light) continue;
                --slotsNeeded;
                continue block0;
            }
        }
        return slotsNeeded <= this.numEmptySlots;
    }

    void addEnvironmentSet(EnvironmentSet e, RenderBin rb) {
        int numEsLights = e.lights.size();
        block0: for (int i = 0; i < numEsLights; ++i) {
            int j;
            LightRetained light = e.lights.get(i);
            if (light instanceof AmbientLightRetained) continue;
            for (j = 0; j < this.maxLights; ++j) {
                if (this.lights[j] != light) continue;
                if (light.lightOn) {
                    e.enableMask |= (long)(1 << j);
                }
                int n = j;
                this.lightsRef[n] = this.lightsRef[n] + 1;
                e.ltPos[i] = j;
                break;
            }
            if (j != this.maxLights) continue;
            for (j = 0; j < this.maxLights; ++j) {
                if (this.lights[j] != null) continue;
                this.lights[j] = light;
                this.lightsRef[j] = 1;
                if (light instanceof PointLightRetained) {
                    this.pointLts.add((PointLightRetained)light);
                    int pointLtsSlotIndexLen = 0;
                    if (this.pointLtsSlotIndex != null) {
                        pointLtsSlotIndexLen = this.pointLtsSlotIndex.length;
                    }
                    if (pointLtsSlotIndexLen < this.pointLts.size()) {
                        int[] newIndexList = new int[pointLtsSlotIndexLen + 8];
                        for (int x = 0; x < pointLtsSlotIndexLen; ++x) {
                            newIndexList[x] = this.pointLtsSlotIndex[x];
                        }
                        this.pointLtsSlotIndex = newIndexList;
                    }
                    this.pointLtsSlotIndex[this.pointLts.size() - 1] = j;
                }
                if (light.lightOn) {
                    e.enableMask |= (long)(1 << j);
                }
                e.ltPos[i] = j;
                --this.numEmptySlots;
                continue block0;
            }
        }
        e.lightBin = this;
        e.enableMaskCache = e.enableMask;
        this.insertEnvSet.add(e);
        if (!this.onUpdateList) {
            rb.objUpdateList.add(this);
            this.onUpdateList = true;
        }
    }

    @Override
    public void updateObject() {
        int i;
        if (this.insertEnvSet.size() > 0) {
            EnvironmentSet e = this.insertEnvSet.get(0);
            if (this.environmentSetList == null) {
                this.environmentSetList = e;
            } else {
                e.next = this.environmentSetList;
                this.environmentSetList.prev = e;
                this.environmentSetList = e;
            }
            for (i = 1; i < this.insertEnvSet.size(); ++i) {
                e = this.insertEnvSet.get(i);
                e.next = this.environmentSetList;
                this.environmentSetList.prev = e;
                this.environmentSetList = e;
            }
        }
        this.insertEnvSet.clear();
        if (this.canvasDirty != 0) {
            Canvas3D[] canvases = this.renderBin.view.getCanvases();
            for (i = 0; i < canvases.length; ++i) {
                canvases[i].canvasDirty |= this.canvasDirty;
            }
            this.lightDirtyMask = this.lightDirtyMaskCache;
            this.canvasDirty = 0;
            this.lightDirtyMaskCache = 0;
        }
        this.onUpdateList = false;
    }

    void removeEnvironmentSet(EnvironmentSet e) {
        e.lightBin = null;
        if (this.insertEnvSet.contains(e)) {
            this.insertEnvSet.remove(this.insertEnvSet.indexOf(e));
        } else {
            int i;
            int numEsLights = e.lights.size();
            block0: for (i = 0; i < numEsLights; ++i) {
                LightRetained light = e.lights.get(i);
                for (int j = 0; j < this.maxLights; ++j) {
                    if (this.lights[j] != light) continue;
                    int n = j;
                    this.lightsRef[n] = this.lightsRef[n] - 1;
                    if (this.lightsRef[j] != 0) continue block0;
                    if (light instanceof PointLightRetained) {
                        this.pointLts.remove(this.pointLts.indexOf(light));
                    }
                    this.lights[j] = null;
                    this.lightDirtyMaskCache &= ~(1 << j);
                    this.lightDirtyMask &= ~(1 << j);
                    ++this.numEmptySlots;
                    continue block0;
                }
            }
            if (e.prev == null) {
                this.environmentSetList = e.next;
                if (e.next != null) {
                    e.next.prev = null;
                }
            } else {
                e.prev.next = e.next;
                if (e.next != null) {
                    e.next.prev = e.prev;
                }
            }
            Canvas3D[] canvases = this.renderBin.view.getCanvases();
            for (i = 0; i < canvases.length; ++i) {
                canvases[i].environmentSet = null;
            }
        }
        e.prev = null;
        e.next = null;
        if (this.environmentSetList == null && this.insertEnvSet.size() == 0) {
            this.renderBin.removeLightBin(this);
            this.geometryBackground = null;
        }
    }

    void render(Canvas3D cv) {
        cv.setStateToUpdate(0, this);
        EnvironmentSet e = this.environmentSetList;
        while (e != null) {
            e.render(cv);
            e = e.next;
        }
    }

    void updateAttributes(Canvas3D cv) {
        int frameCount = VirtualUniverse.mc.frameCount;
        if (cv.lightBin != this) {
            double scale;
            if (this.geometryBackground == null) {
                scale = cv.canvasViewCache.getVworldToCoexistenceScale();
                cv.setModelViewMatrix(cv.ctx, cv.vpcToEc.mat, this.renderBin.vworldToVpc);
            } else {
                scale = cv.canvasViewCache.getInfVworldToCoexistenceScale();
                cv.setModelViewMatrix(cv.ctx, cv.vpcToEc.mat, this.renderBin.infVworldToVpc);
            }
            for (int i = 0; i < this.maxLights; ++i) {
                if (this.lights[i] == null || cv.lights[i] == this.lights[i] && cv.frameCount[i] == frameCount) continue;
                cv.lights[i] = this.lights[i];
                cv.frameCount[i] = frameCount;
                this.lights[i].update(cv.ctx, i, scale);
            }
            cv.lightBin = this;
            cv.canvasDirty &= 0xFFFFFFBF;
            cv.enableMask = -1L;
        } else if ((cv.canvasDirty & 0x40) != 0) {
            double scale;
            if (this.geometryBackground == null) {
                scale = cv.canvasViewCache.getVworldToCoexistenceScale();
                cv.setModelViewMatrix(cv.ctx, cv.vpcToEc.mat, this.renderBin.vworldToVpc);
            } else {
                scale = cv.canvasViewCache.getInfVworldToCoexistenceScale();
                cv.setModelViewMatrix(cv.ctx, cv.vpcToEc.mat, this.renderBin.infVworldToVpc);
            }
            int i = 0;
            int mask = this.lightDirtyMask;
            while (mask != 0) {
                if ((mask & 1) != 0) {
                    this.lights[i].update(cv.ctx, i, scale);
                    cv.lights[i] = this.lights[i];
                    cv.frameCount[i] = frameCount;
                }
                mask >>= 1;
                ++i;
            }
            cv.canvasDirty &= 0xFFFFFFBF;
        } else if (this.pointLts.size() > 0 && (cv.canvasDirty & 0x8000) != 0) {
            double scale;
            if (this.geometryBackground == null) {
                scale = cv.canvasViewCache.getVworldToCoexistenceScale();
                cv.setModelViewMatrix(cv.ctx, cv.vpcToEc.mat, this.renderBin.vworldToVpc);
            } else {
                scale = cv.canvasViewCache.getInfVworldToCoexistenceScale();
                cv.setModelViewMatrix(cv.ctx, cv.vpcToEc.mat, this.renderBin.infVworldToVpc);
            }
            for (int i = 0; i < this.pointLts.size(); ++i) {
                PointLightRetained lt = this.pointLts.get(i);
                lt.update(cv.ctx, this.pointLtsSlotIndex[i], scale);
                cv.lights[this.pointLtsSlotIndex[i]] = lt;
                cv.frameCount[this.pointLtsSlotIndex[i]] = frameCount;
            }
        }
    }
}

