/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.jogamp.java3d.BehaviorRetained;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.BranchGroupRetained;
import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.HiResCoord;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.MasterControl;
import org.jogamp.java3d.MultipleParentException;
import org.jogamp.java3d.OrderedPath;
import org.jogamp.java3d.PickBounds;
import org.jogamp.java3d.PickInfo;
import org.jogamp.java3d.PickPoint;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.SceneGraphPath;
import org.jogamp.java3d.SetLiveState;
import org.jogamp.java3d.SwitchState;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.VirtualUniverse;

public class Locale {
    VirtualUniverse universe;
    HiResCoord hiRes;
    Vector<BranchGroup> branchGroups = new Vector();
    String nodeId = null;

    public Locale(VirtualUniverse universe) {
        this.universe = universe;
        this.universe.addLocale(this);
        this.hiRes = new HiResCoord();
        this.nodeId = universe.getNodeId();
    }

    public Locale(VirtualUniverse universe, int[] x, int[] y, int[] z) {
        this.universe = universe;
        this.universe.addLocale(this);
        this.hiRes = new HiResCoord(x, y, z);
        this.nodeId = universe.getNodeId();
    }

    public Locale(VirtualUniverse universe, HiResCoord hiRes) {
        this.universe = universe;
        this.universe.addLocale(this);
        this.hiRes = new HiResCoord(hiRes);
        this.nodeId = universe.getNodeId();
    }

    public VirtualUniverse getVirtualUniverse() {
        return this.universe;
    }

    public void setHiRes(int[] x, int[] y, int[] z) {
        this.hiRes.setHiResCoord(x, y, z);
    }

    public void setHiRes(HiResCoord hiRes) {
        this.hiRes.setHiResCoord(hiRes);
    }

    public void getHiRes(HiResCoord hiRes) {
        this.hiRes.getHiResCoord(hiRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBranchGraph(BranchGroup branchGroup) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        if (((BranchGroupRetained)branchGroup.retained).parent != null || branchGroup.isLive()) {
            throw new MultipleParentException(J3dI18N.getString("Locale0"));
        }
        this.universe.notifyStructureChangeListeners(true, (Object)this, branchGroup);
        this.universe.resetWaitMCFlag();
        Object object = this.universe.sceneGraphLock;
        synchronized (object) {
            this.doAddBranchGraph(branchGroup);
            this.universe.setLiveState.reset(this);
        }
        this.universe.waitForMC();
    }

    void doAddBranchGraph(BranchGroup branchGroup) {
        BranchGroupRetained bgr = (BranchGroupRetained)branchGroup.retained;
        SetLiveState s = this.universe.setLiveState;
        bgr.attachedToLocale = true;
        this.branchGroups.addElement(branchGroup);
        s.reset(this);
        s.currentTransforms[0] = new Transform3D[2];
        s.currentTransforms[0][0] = new Transform3D();
        s.currentTransforms[0][1] = new Transform3D();
        s.currentTransformsIndex[0] = new int[2];
        s.currentTransformsIndex[0][0] = 0;
        s.currentTransformsIndex[0][1] = 0;
        s.localToVworld = s.currentTransforms;
        s.localToVworldIndex = s.currentTransformsIndex;
        s.branchGroupPaths = new ArrayList();
        s.branchGroupPaths.add(new BranchGroupRetained[0]);
        s.orderedPaths = new ArrayList(1);
        s.orderedPaths.add(new OrderedPath());
        s.switchStates = new ArrayList(1);
        s.switchStates.add(new SwitchState(false));
        bgr.setLive(s);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4224;
        createMessage.type = 32;
        createMessage.universe = this.universe;
        createMessage.args[0] = s.ogList.toArray();
        createMessage.args[1] = s.ogChildIdList.toArray();
        createMessage.args[2] = s.ogOrderedIdList.toArray();
        createMessage.args[3] = s.ogCIOList.toArray();
        createMessage.args[4] = s.ogCIOTableList.toArray();
        VirtualUniverse.mc.processMessage(createMessage);
        createMessage = new J3dMessage();
        createMessage.threads = 4096;
        createMessage.type = 57;
        createMessage.universe = this.universe;
        createMessage.args[0] = s.changedViewGroup;
        createMessage.args[1] = s.changedViewList;
        createMessage.args[2] = s.keyList;
        VirtualUniverse.mc.processMessage(createMessage);
        createMessage = new J3dMessage();
        createMessage.threads = s.notifyThreads;
        createMessage.type = 0;
        createMessage.universe = this.universe;
        createMessage.args[0] = s.nodeList.toArray();
        createMessage.args[1] = null;
        createMessage.args[2] = null;
        if (s.viewScopedNodeList != null) {
            createMessage.args[3] = s.viewScopedNodeList;
            createMessage.args[4] = s.scopedNodesViewList;
        }
        VirtualUniverse.mc.processMessage(createMessage);
        int sz = s.behaviorNodes.size();
        for (int i = 0; i < sz; ++i) {
            BehaviorRetained b = s.behaviorNodes.get(i);
            b.executeInitialize();
        }
        createMessage = new J3dMessage();
        createMessage.threads = 256;
        createMessage.type = 49;
        createMessage.universe = this.universe;
        VirtualUniverse.mc.processMessage(createMessage);
        s.reset(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBranchGraph(BranchGroup branchGroup) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        if (!branchGroup.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Locale1"));
        }
        this.universe.resetWaitMCFlag();
        Object object = this.universe.sceneGraphLock;
        synchronized (object) {
            this.doRemoveBranchGraph(branchGroup, null, 0);
            this.universe.setLiveState.reset(this);
        }
        this.universe.waitForMC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromUniverse() {
        if (this.branchGroups.size() > 0) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                Object[] bg = this.branchGroups.toArray();
                for (int i = 0; i < bg.length; ++i) {
                    this.doRemoveBranchGraph((BranchGroup)bg[i], null, 0);
                }
            }
            this.universe.waitForMC();
        }
        if (this.nodeId != null) {
            this.universe.nodeIdFreeList.addElement(this.nodeId);
            this.nodeId = null;
        }
        this.universe = null;
    }

    void doRemoveBranchGraph(BranchGroup branchGroup, J3dMessage[] messages, int startIndex) {
        BranchGroupRetained bgr = (BranchGroupRetained)branchGroup.retained;
        if (!branchGroup.isLive()) {
            return;
        }
        bgr.attachedToLocale = false;
        this.branchGroups.removeElement(branchGroup);
        this.universe.setLiveState.reset(this);
        bgr.clearLive(this.universe.setLiveState);
        bgr.setParent(null);
        bgr.setLocale(null);
        J3dMessage destroyMessage = messages == null ? new J3dMessage() : messages[startIndex++];
        destroyMessage.threads = 4224;
        destroyMessage.type = 33;
        destroyMessage.universe = this.universe;
        destroyMessage.args[0] = this.universe.setLiveState.ogList.toArray();
        destroyMessage.args[1] = this.universe.setLiveState.ogChildIdList.toArray();
        destroyMessage.args[3] = this.universe.setLiveState.ogCIOList.toArray();
        destroyMessage.args[4] = this.universe.setLiveState.ogCIOTableList.toArray();
        if (messages == null) {
            VirtualUniverse.mc.processMessage(destroyMessage);
            destroyMessage = new J3dMessage();
        } else {
            destroyMessage = messages[startIndex++];
        }
        destroyMessage.threads = this.universe.setLiveState.notifyThreads;
        destroyMessage.type = 1;
        destroyMessage.universe = this.universe;
        destroyMessage.args[0] = this.universe.setLiveState.nodeList.toArray();
        if (this.universe.setLiveState.viewScopedNodeList != null) {
            destroyMessage.args[3] = this.universe.setLiveState.viewScopedNodeList;
            destroyMessage.args[4] = this.universe.setLiveState.scopedNodesViewList;
        }
        if (messages == null) {
            VirtualUniverse.mc.processMessage(destroyMessage);
            destroyMessage = new J3dMessage();
        } else {
            destroyMessage = messages[startIndex++];
        }
        destroyMessage.threads = 4096;
        destroyMessage.type = 58;
        destroyMessage.universe = this.universe;
        destroyMessage.args[0] = this.universe.setLiveState.changedViewGroup;
        destroyMessage.args[1] = this.universe.setLiveState.keyList;
        if (messages == null) {
            VirtualUniverse.mc.processMessage(destroyMessage);
        } else {
            destroyMessage = messages[startIndex++];
        }
        if (this.universe.isEmpty()) {
            VirtualUniverse.mc.postRequest(MasterControl.EMPTY_UNIVERSE, this.universe);
        }
        this.universe.setLiveState.reset(null);
        this.universe.notifyStructureChangeListeners(false, (Object)this, branchGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceBranchGraph(BranchGroup oldGroup, BranchGroup newGroup) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        if (!oldGroup.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Locale1"));
        }
        if (((BranchGroupRetained)newGroup.retained).parent != null) {
            throw new MultipleParentException(J3dI18N.getString("Locale3"));
        }
        this.universe.resetWaitMCFlag();
        this.universe.notifyStructureChangeListeners(true, (Object)this, newGroup);
        Object object = this.universe.sceneGraphLock;
        synchronized (object) {
            this.doReplaceBranchGraph(oldGroup, newGroup);
            this.universe.setLiveState.reset(this);
        }
        this.universe.notifyStructureChangeListeners(false, (Object)this, oldGroup);
        this.universe.waitForMC();
    }

    void doReplaceBranchGraph(BranchGroup oldGroup, BranchGroup newGroup) {
        BranchGroupRetained obgr = (BranchGroupRetained)oldGroup.retained;
        BranchGroupRetained nbgr = (BranchGroupRetained)newGroup.retained;
        this.branchGroups.removeElement(oldGroup);
        obgr.attachedToLocale = false;
        this.universe.setLiveState.reset(this);
        obgr.clearLive(this.universe.setLiveState);
        J3dMessage destroyMessage = new J3dMessage();
        destroyMessage.threads = 4224;
        destroyMessage.type = 33;
        destroyMessage.universe = this.universe;
        destroyMessage.args[0] = this.universe.setLiveState.ogList.toArray();
        destroyMessage.args[1] = this.universe.setLiveState.ogChildIdList.toArray();
        destroyMessage.args[3] = this.universe.setLiveState.ogCIOList.toArray();
        destroyMessage.args[4] = this.universe.setLiveState.ogCIOTableList.toArray();
        VirtualUniverse.mc.processMessage(destroyMessage);
        destroyMessage = new J3dMessage();
        destroyMessage.threads = 4096;
        destroyMessage.type = 58;
        destroyMessage.universe = this.universe;
        destroyMessage.args[0] = this.universe.setLiveState.changedViewGroup;
        destroyMessage.args[1] = this.universe.setLiveState.keyList;
        VirtualUniverse.mc.processMessage(destroyMessage);
        destroyMessage = new J3dMessage();
        destroyMessage.threads = this.universe.setLiveState.notifyThreads;
        destroyMessage.type = 1;
        destroyMessage.universe = this.universe;
        destroyMessage.args[0] = this.universe.setLiveState.nodeList.toArray();
        VirtualUniverse.mc.processMessage(destroyMessage);
        this.branchGroups.addElement(newGroup);
        nbgr.attachedToLocale = true;
        this.universe.setLiveState.reset(this);
        this.universe.setLiveState.currentTransforms[0] = new Transform3D[2];
        this.universe.setLiveState.currentTransforms[0][0] = new Transform3D();
        this.universe.setLiveState.currentTransforms[0][1] = new Transform3D();
        this.universe.setLiveState.currentTransformsIndex[0] = new int[2];
        this.universe.setLiveState.currentTransformsIndex[0][0] = 0;
        this.universe.setLiveState.currentTransformsIndex[0][1] = 0;
        this.universe.setLiveState.localToVworld = this.universe.setLiveState.currentTransforms;
        this.universe.setLiveState.localToVworldIndex = this.universe.setLiveState.currentTransformsIndex;
        this.universe.setLiveState.branchGroupPaths = new ArrayList();
        this.universe.setLiveState.branchGroupPaths.add(new BranchGroupRetained[0]);
        this.universe.setLiveState.orderedPaths = new ArrayList(1);
        this.universe.setLiveState.orderedPaths.add(new OrderedPath());
        this.universe.setLiveState.switchStates = new ArrayList(1);
        this.universe.setLiveState.switchStates.add(new SwitchState(false));
        nbgr.setLive(this.universe.setLiveState);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4224;
        createMessage.type = 32;
        createMessage.universe = this.universe;
        createMessage.args[0] = this.universe.setLiveState.ogList.toArray();
        createMessage.args[1] = this.universe.setLiveState.ogChildIdList.toArray();
        createMessage.args[2] = this.universe.setLiveState.ogOrderedIdList.toArray();
        createMessage.args[3] = this.universe.setLiveState.ogCIOList.toArray();
        createMessage.args[4] = this.universe.setLiveState.ogCIOTableList.toArray();
        VirtualUniverse.mc.processMessage(createMessage);
        createMessage = new J3dMessage();
        createMessage.threads = this.universe.setLiveState.notifyThreads;
        createMessage.type = 0;
        createMessage.universe = this.universe;
        createMessage.args[0] = this.universe.setLiveState.nodeList.toArray();
        createMessage.args[1] = null;
        createMessage.args[2] = null;
        if (this.universe.setLiveState.viewScopedNodeList != null) {
            createMessage.args[3] = this.universe.setLiveState.viewScopedNodeList;
            createMessage.args[4] = this.universe.setLiveState.scopedNodesViewList;
        }
        VirtualUniverse.mc.processMessage(createMessage);
        BehaviorRetained[] behavNodes = new BehaviorRetained[this.universe.setLiveState.behaviorNodes.size()];
        behavNodes = this.universe.setLiveState.behaviorNodes.toArray(behavNodes);
        if (this.universe.isEmpty()) {
            VirtualUniverse.mc.postRequest(MasterControl.EMPTY_UNIVERSE, this.universe);
        }
        for (int i = 0; i < behavNodes.length; ++i) {
            behavNodes[i].executeInitialize();
        }
        createMessage = new J3dMessage();
        createMessage.threads = 256;
        createMessage.type = 49;
        createMessage.universe = this.universe;
        VirtualUniverse.mc.processMessage(createMessage);
        this.universe.setLiveState.reset(null);
    }

    public int numBranchGraphs() {
        return this.branchGroups.size();
    }

    public Iterator<BranchGroup> getAllBranchGraphs() {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        return this.branchGroups.iterator();
    }

    void validateModeFlagAndPickShape(int mode, int flags, PickShape pickShape) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        if (mode != 1 && mode != 2) {
            throw new IllegalArgumentException(J3dI18N.getString("Locale5"));
        }
        if (pickShape instanceof PickPoint && mode == 2) {
            throw new IllegalArgumentException(J3dI18N.getString("Locale6"));
        }
        if ((flags & 0x20) != 0 && (flags & 0x40) != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("Locale7"));
        }
        if (mode == 1 && (flags & 0x78) != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("Locale8"));
        }
        if (pickShape instanceof PickBounds && (flags & 0x78) != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("Locale9"));
        }
    }

    public SceneGraphPath[] pickAll(PickShape pickShape) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        PickInfo[] pickInfoArr = this.pickAll(1, 1, pickShape);
        if (pickInfoArr == null) {
            return null;
        }
        SceneGraphPath[] sgpArr = new SceneGraphPath[pickInfoArr.length];
        for (int i = 0; i < sgpArr.length; ++i) {
            sgpArr[i] = pickInfoArr[i].getSceneGraphPath();
        }
        return sgpArr;
    }

    public PickInfo[] pickAll(int mode, int flags, PickShape pickShape) {
        this.validateModeFlagAndPickShape(mode, flags, pickShape);
        GeometryAtom[] geomAtoms = this.universe.geometryStructure.pickAll(this, pickShape);
        return PickInfo.pick(this, geomAtoms, mode, flags, pickShape, 1);
    }

    public SceneGraphPath[] pickAllSorted(PickShape pickShape) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        PickInfo[] pickInfoArr = this.pickAllSorted(1, 1, pickShape);
        if (pickInfoArr == null) {
            return null;
        }
        SceneGraphPath[] sgpArr = new SceneGraphPath[pickInfoArr.length];
        for (int i = 0; i < sgpArr.length; ++i) {
            sgpArr[i] = pickInfoArr[i].getSceneGraphPath();
        }
        return sgpArr;
    }

    public PickInfo[] pickAllSorted(int mode, int flags, PickShape pickShape) {
        this.validateModeFlagAndPickShape(mode, flags, pickShape);
        GeometryAtom[] geomAtoms = this.universe.geometryStructure.pickAll(this, pickShape);
        if (geomAtoms == null || geomAtoms.length == 0) {
            return null;
        }
        PickInfo[] pickInfoArr = null;
        if (mode == 2) {
            pickInfoArr = PickInfo.pick(this, geomAtoms, mode, flags |= 0x10, pickShape, 1);
            if (pickInfoArr != null) {
                PickInfo.sortPickInfoArray(pickInfoArr);
            }
        } else {
            PickInfo.sortGeomAtoms(geomAtoms, pickShape);
            pickInfoArr = PickInfo.pick(this, geomAtoms, mode, flags, pickShape, 1);
        }
        return pickInfoArr;
    }

    public SceneGraphPath pickClosest(PickShape pickShape) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        PickInfo pickInfo = this.pickClosest(1, 1, pickShape);
        if (pickInfo == null) {
            return null;
        }
        return pickInfo.getSceneGraphPath();
    }

    public PickInfo pickClosest(int mode, int flags, PickShape pickShape) {
        PickInfo[] pickInfoArr = null;
        pickInfoArr = this.pickAllSorted(mode, flags, pickShape);
        if (pickInfoArr == null) {
            return null;
        }
        return pickInfoArr[0];
    }

    public SceneGraphPath pickAny(PickShape pickShape) {
        if (this.universe == null) {
            throw new IllegalStateException(J3dI18N.getString("Locale4"));
        }
        PickInfo pickInfo = this.pickAny(1, 1, pickShape);
        if (pickInfo == null) {
            return null;
        }
        return pickInfo.getSceneGraphPath();
    }

    public PickInfo pickAny(int mode, int flags, PickShape pickShape) {
        this.validateModeFlagAndPickShape(mode, flags, pickShape);
        GeometryAtom[] geomAtoms = this.universe.geometryStructure.pickAll(this, pickShape);
        PickInfo[] pickInfoArr = PickInfo.pick(this, geomAtoms, mode, flags, pickShape, 2);
        if (pickInfoArr == null) {
            return null;
        }
        return pickInfoArr[0];
    }
}

