/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.EigenTensors2;
import edu.mines.jtk.dsp.EigenTensors3;
import edu.mines.jtk.dsp.RecursiveGaussianFilter;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;

public class ZeroMask {
    private int _n1;
    private int _n2;
    private int _n3;
    private boolean[][] _mask2;
    private boolean[][][] _mask3;

    public ZeroMask(double small, double sigma1, double sigma2, float[][] x) {
        this._n1 = x[0].length;
        this._n2 = x.length;
        float[][] t = ArrayMath.abs(x);
        float a = ArrayMath.sum(t) / (float)this._n1 / (float)this._n2;
        RecursiveGaussianFilter rgf1 = new RecursiveGaussianFilter(sigma1);
        RecursiveGaussianFilter rgf2 = new RecursiveGaussianFilter(sigma2);
        float[][] b = ArrayMath.zerofloat(this._n1, this._n2);
        rgf1.apply0X(t, b);
        rgf2.applyX0(b, t);
        this._mask2 = new boolean[this._n2][this._n1];
        for (int i2 = 0; i2 < this._n2; ++i2) {
            for (int i1 = 0; i1 < this._n1; ++i1) {
                this._mask2[i2][i1] = (double)t[i2][i1] >= small * (double)a;
            }
        }
    }

    public ZeroMask(double small, double sigma1, double sigma2, double sigma3, float[][][] x) {
        this._n1 = x[0][0].length;
        this._n2 = x[0].length;
        this._n3 = x.length;
        float[][][] t = ArrayMath.abs(x);
        float a = ArrayMath.sum(t) / (float)this._n1 / (float)this._n2 / (float)this._n3;
        RecursiveGaussianFilter rgf1 = new RecursiveGaussianFilter(sigma1);
        RecursiveGaussianFilter rgf2 = new RecursiveGaussianFilter(sigma2);
        RecursiveGaussianFilter rgf3 = new RecursiveGaussianFilter(sigma3);
        float[][][] b = ArrayMath.zerofloat(this._n1, this._n2, this._n3);
        rgf1.apply0XX(t, b);
        rgf2.applyX0X(b, t);
        rgf3.applyXX0(t, b);
        this._mask3 = new boolean[this._n3][this._n2][this._n1];
        for (int i3 = 0; i3 < this._n3; ++i3) {
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    this._mask3[i3][i2][i1] = (double)b[i3][i2][i1] >= small * (double)a;
                }
            }
        }
    }

    public ZeroMask(float[][] x) {
        this._n1 = x[0].length;
        this._n2 = x.length;
        this._mask2 = new boolean[this._n2][this._n1];
        for (int i2 = 0; i2 < this._n2; ++i2) {
            for (int i1 = 0; i1 < this._n1; ++i1) {
                if (x[i2][i1] == 0.0f) continue;
                this._mask2[i2][i1] = true;
            }
        }
    }

    public ZeroMask(float[][][] x) {
        this._n1 = x[0][0].length;
        this._n2 = x[0].length;
        this._n3 = x.length;
        this._mask3 = new boolean[this._n3][this._n2][this._n1];
        for (int i3 = 0; i3 < this._n3; ++i3) {
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    if (x[i3][i2][i1] == 0.0f) continue;
                    this._mask3[i3][i2][i1] = true;
                }
            }
        }
    }

    public float[][] getAsFloats2() {
        Check.state(this._mask2 != null, "mask constructed for a 2D image");
        float[][] mask = new float[this._n2][this._n1];
        this.getAsFloats(mask);
        return mask;
    }

    public void getAsFloats(float[][] mask) {
        Check.state(this._mask2 != null, "mask constructed for a 2D image");
        for (int i2 = 0; i2 < this._n2; ++i2) {
            for (int i1 = 0; i1 < this._n1; ++i1) {
                mask[i2][i1] = this._mask2[i2][i1] ? 1.0f : 0.0f;
            }
        }
    }

    public float[][][] getAsFloats3() {
        Check.state(this._mask3 != null, "mask constructed for a 3D image");
        float[][][] mask = new float[this._n3][this._n2][this._n1];
        this.getAsFloats(mask);
        return mask;
    }

    public void getAsFloats(float[][][] mask) {
        Check.state(this._mask3 != null, "mask constructed for a 3D image");
        for (int i3 = 0; i3 < this._n3; ++i3) {
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    mask[i3][i2][i1] = this._mask3[i3][i2][i1] ? 1.0f : 0.0f;
                }
            }
        }
    }

    public void apply(float vfalse, float[][] v) {
        Check.state(this._mask2 != null, "mask constructed for a 2D image");
        for (int i2 = 0; i2 < this._n2; ++i2) {
            for (int i1 = 0; i1 < this._n1; ++i1) {
                if (this._mask2[i2][i1]) continue;
                v[i2][i1] = vfalse;
            }
        }
    }

    public void apply(float vfalse, float[][][] v) {
        Check.state(this._mask3 != null, "mask constructed for a 3D image");
        for (int i3 = 0; i3 < this._n3; ++i3) {
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    if (this._mask3[i3][i2][i1]) continue;
                    v[i3][i2][i1] = vfalse;
                }
            }
        }
    }

    public void apply(float[] efalse, EigenTensors2 e) {
        Check.state(this._mask2 != null, "mask constructed for a 2D image");
        for (int i2 = 0; i2 < this._n2; ++i2) {
            for (int i1 = 0; i1 < this._n1; ++i1) {
                if (this._mask2[i2][i1]) continue;
                e.setTensor(i1, i2, efalse);
            }
        }
    }

    public void apply(float[] efalse, EigenTensors3 e) {
        Check.state(this._mask3 != null, "mask constructed for a 3D image");
        for (int i3 = 0; i3 < this._n3; ++i3) {
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    if (this._mask3[i3][i2][i1]) continue;
                    e.setTensor(i1, i2, i3, efalse);
                }
            }
        }
    }
}

