/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;

public class CubicInterpolator {
    private float[] _xd;
    private float[][] _yd;
    private int _index;
    private static final float FLT_O2 = 0.5f;
    private static final float FLT_O6 = 0.16666667f;

    public CubicInterpolator(float[] x, float[] y, float[] y1) {
        Check.argument(ArrayMath.isMonotonic(x), "array x is monotonic");
        int n = x.length;
        this._xd = new float[n];
        this._yd = new float[n][4];
        for (int i = 0; i < n; ++i) {
            this._xd[i] = x[i];
            this._yd[i][0] = y[i];
            this._yd[i][1] = y1[i];
        }
        CubicInterpolator.compute2ndAnd3rdDerivatives(this._xd, this._yd);
    }

    public CubicInterpolator(float[] x, float[] y) {
        this(Method.MONOTONIC, x, y);
    }

    public CubicInterpolator(Method method, float[] x, float[] y) {
        this(method, x.length, x, y);
    }

    public CubicInterpolator(Method method, int n, float[] x, float[] y) {
        Check.argument(ArrayMath.isMonotonic(x), "array x is monotonic");
        this._xd = new float[n];
        this._yd = new float[n][4];
        for (int i = 0; i < n; ++i) {
            this._xd[i] = x[i];
            this._yd[i][0] = y[i];
        }
        if (method == Method.LINEAR) {
            CubicInterpolator.initLinear(n, this._xd, this._yd);
        } else if (method == Method.MONOTONIC) {
            CubicInterpolator.initMonotonic(n, this._xd, this._yd);
        } else if (method == Method.SPLINE) {
            CubicInterpolator.initSpline(n, this._xd, this._yd);
        } else assert (false);
    }

    public float interpolate(float x) {
        return this.interpolate0(x);
    }

    public float interpolate0(float x) {
        int i = this.index(x);
        return CubicInterpolator.interpolate0(x - this._xd[i], this._yd[i]);
    }

    public float interpolate1(float x) {
        int i = this.index(x);
        return CubicInterpolator.interpolate1(x - this._xd[i], this._yd[i]);
    }

    public float interpolate2(float x) {
        int i = this.index(x);
        return CubicInterpolator.interpolate2(x - this._xd[i], this._yd[i]);
    }

    public float interpolate3(float x) {
        int i = this.index(x);
        return CubicInterpolator.interpolate3(x - this._xd[i], this._yd[i]);
    }

    public float[] interpolate(float[] x) {
        return this.interpolate0(x);
    }

    public float[] interpolate0(float[] x) {
        float[] y = new float[x.length];
        this.interpolate0(x.length, x, y);
        return y;
    }

    public void interpolate(float[] x, float[] y) {
        this.interpolate0(x, y);
    }

    public void interpolate0(float[] x, float[] y) {
        this.interpolate0(x.length, x, y);
    }

    public float[] interpolate1(float[] x) {
        float[] y = new float[x.length];
        this.interpolate1(x.length, x, y);
        return y;
    }

    public void interpolate1(float[] x, float[] y) {
        this.interpolate1(x.length, x, y);
    }

    public float[] interpolate2(float[] x) {
        float[] y = new float[x.length];
        this.interpolate2(x.length, x, y);
        return y;
    }

    public void interpolate2(float[] x, float[] y) {
        this.interpolate2(x.length, x, y);
    }

    public float[] interpolate3(float[] x) {
        float[] y = new float[x.length];
        this.interpolate3(x.length, x, y);
        return y;
    }

    public void interpolate3(float[] x, float[] y) {
        this.interpolate3(x.length, x, y);
    }

    public void interpolate(int n, float[] x, float[] y) {
        this.interpolate0(n, x, y);
    }

    public void interpolate0(int n, float[] x, float[] y) {
        int[] js = new int[]{0};
        for (int i = 0; i < n; ++i) {
            int j = CubicInterpolator.index(x[i], this._xd, js);
            y[i] = CubicInterpolator.interpolate0(x[i] - this._xd[j], this._yd[j]);
        }
    }

    public void interpolate1(int n, float[] x, float[] y) {
        int[] js = new int[]{0};
        for (int i = 0; i < n; ++i) {
            int j = CubicInterpolator.index(x[i], this._xd, js);
            y[i] = CubicInterpolator.interpolate1(x[i] - this._xd[j], this._yd[j]);
        }
    }

    public void interpolate2(int n, float[] x, float[] y) {
        int[] js = new int[]{0};
        for (int i = 0; i < n; ++i) {
            int j = CubicInterpolator.index(x[i], this._xd, js);
            y[i] = CubicInterpolator.interpolate2(x[i] - this._xd[j], this._yd[j]);
        }
    }

    public void interpolate3(int n, float[] x, float[] y) {
        int[] js = new int[]{0};
        for (int i = 0; i < n; ++i) {
            int j = CubicInterpolator.index(x[i], this._xd, js);
            y[i] = CubicInterpolator.interpolate3(x[i] - this._xd[j], this._yd[j]);
        }
    }

    private int index(float x) {
        int index = ArrayMath.binarySearch(this._xd, x, this._index);
        if (index < 0) {
            index = index < -1 ? -2 - index : 0;
        }
        this._index = index;
        return index;
    }

    private static int index(float x, float[] xs, int[] i) {
        int index = ArrayMath.binarySearch(xs, x, i[0]);
        if (index < 0) {
            index = index < -1 ? -2 - index : 0;
        }
        i[0] = index;
        return index;
    }

    private static float interpolate0(float dx, float[] yd) {
        return yd[0] + dx * (yd[1] + dx * (yd[2] * 0.5f + dx * (yd[3] * 0.16666667f)));
    }

    private static float interpolate1(float dx, float[] yd) {
        return yd[1] + dx * (yd[2] + dx * (yd[3] * 0.5f));
    }

    private static float interpolate2(float dx, float[] yd) {
        return yd[2] + dx * yd[3];
    }

    private static float interpolate3(float dx, float[] yd) {
        return yd[3];
    }

    private static void initLinear(int n, float[] x, float[][] y) {
        if (n == 1) {
            y[0][1] = 0.0f;
            y[0][2] = 0.0f;
            y[0][3] = 0.0f;
            return;
        }
        for (int i = 0; i < n - 1; ++i) {
            y[i][1] = (y[i + 1][0] - y[i][0]) / (x[i + 1] - x[i]);
            y[i][3] = 0.0f;
            y[i][2] = 0.0f;
        }
        y[n - 1][1] = y[n - 2][1];
        y[n - 1][3] = 0.0f;
        y[n - 1][2] = 0.0f;
    }

    private static void initMonotonic(int n, float[] x, float[][] y) {
        if (n == 1) {
            y[0][1] = 0.0f;
            y[0][2] = 0.0f;
            y[0][3] = 0.0f;
            return;
        }
        if (n == 2) {
            float f = (y[1][0] - y[0][0]) / (x[1] - x[0]);
            y[1][1] = f;
            y[0][1] = f;
            y[1][2] = 0.0f;
            y[0][2] = 0.0f;
            y[1][3] = 0.0f;
            y[0][3] = 0.0f;
            return;
        }
        float h1 = x[1] - x[0];
        float h2 = x[2] - x[1];
        float hsum = h1 + h2;
        float del1 = (y[1][0] - y[0][0]) / h1;
        float del2 = (y[2][0] - y[1][0]) / h2;
        float w1 = (h1 + hsum) / hsum;
        float w2 = -h1 / hsum;
        y[0][1] = w1 * del1 + w2 * del2;
        if (y[0][1] * del1 <= 0.0f) {
            y[0][1] = 0.0f;
        } else if (del1 * del2 < 0.0f) {
            float dmax = 3.0f * del1;
            if (ArrayMath.abs(y[0][1]) > ArrayMath.abs(dmax)) {
                y[0][1] = dmax;
            }
        }
        for (int i = 1; i < n - 1; ++i) {
            h1 = x[i] - x[i - 1];
            h2 = x[i + 1] - x[i];
            hsum = h1 + h2;
            del1 = (y[i][0] - y[i - 1][0]) / h1;
            del2 = (y[i + 1][0] - y[i][0]) / h2;
            if (del1 * del2 <= 0.0f) {
                y[i][1] = 0.0f;
                continue;
            }
            float dmin = ArrayMath.min(ArrayMath.abs(del1), ArrayMath.abs(del2));
            float dmax = ArrayMath.max(ArrayMath.abs(del1), ArrayMath.abs(del2));
            float drat1 = del1 / dmax;
            float drat2 = del2 / dmax;
            float hsum3 = hsum + hsum + hsum;
            w1 = (hsum + h1) / hsum3;
            w2 = (hsum + h2) / hsum3;
            y[i][1] = dmin / (w1 * drat1 + w2 * drat2);
        }
        w1 = -h2 / hsum;
        w2 = (h2 + hsum) / hsum;
        y[n - 1][1] = w1 * del1 + w2 * del2;
        if (y[n - 1][1] * del2 <= 0.0f) {
            y[n - 1][1] = 0.0f;
        } else if (del1 * del2 < 0.0f) {
            float dmax = 3.0f * del2;
            if (ArrayMath.abs(y[n - 1][1]) > ArrayMath.abs(dmax)) {
                y[n - 1][1] = dmax;
            }
        }
        CubicInterpolator.compute2ndAnd3rdDerivatives(x, y);
    }

    private static void initSpline(int n, float[] x, float[][] y) {
        int i;
        if (n == 1) {
            y[0][1] = 0.0f;
            y[0][2] = 0.0f;
            y[0][3] = 0.0f;
            return;
        }
        if (n == 2) {
            float f = (y[1][0] - y[0][0]) / (x[1] - x[0]);
            y[1][1] = f;
            y[0][1] = f;
            y[1][2] = 0.0f;
            y[0][2] = 0.0f;
            y[1][3] = 0.0f;
            y[0][3] = 0.0f;
            return;
        }
        float h1 = x[1] - x[0];
        float h2 = x[2] - x[1];
        float hsum = h1 + h2;
        float w1 = (h1 + hsum) / hsum;
        float del1 = (y[1][0] - y[0][0]) / h1;
        float w2 = -h1 / hsum;
        float del2 = (y[2][0] - y[1][0]) / h2;
        float sleft = w1 * del1 + w2 * del2;
        if (sleft * del1 <= 0.0f) {
            sleft = 0.0f;
        } else if (del1 * del2 < 0.0f) {
            float dmax = 3.0f * del1;
            if (ArrayMath.abs(sleft) > ArrayMath.abs(dmax)) {
                sleft = dmax;
            }
        }
        h1 = x[n - 2] - x[n - 3];
        h2 = x[n - 1] - x[n - 2];
        hsum = h1 + h2;
        del1 = (y[n - 2][0] - y[n - 3][0]) / h1;
        del2 = (y[n - 1][0] - y[n - 2][0]) / h2;
        w1 = -h2 / hsum;
        w2 = (h2 + hsum) / hsum;
        float sright = w1 * del1 + w2 * del2;
        if (sright * del2 <= 0.0f) {
            sright = 0.0f;
        } else if (del1 * del2 < 0.0f) {
            float dmax = 3.0f * del2;
            if (ArrayMath.abs(sright) > ArrayMath.abs(dmax)) {
                sright = dmax;
            }
        }
        float[] work = new float[n];
        work[0] = 1.0f;
        y[0][2] = 2.0f * sleft;
        for (int i2 = 1; i2 < n - 1; ++i2) {
            float alpha;
            h1 = x[i2] - x[i2 - 1];
            h2 = x[i2 + 1] - x[i2];
            del1 = (y[i2][0] - y[i2 - 1][0]) / h1;
            del2 = (y[i2 + 1][0] - y[i2][0]) / h2;
            work[i2] = alpha = h2 / (h1 + h2);
            y[i2][2] = 3.0f * (alpha * del1 + (1.0f - alpha) * del2);
        }
        work[n - 1] = 0.0f;
        y[n - 1][2] = 2.0f * sright;
        float t = 2.0f;
        y[0][1] = y[0][2] / t;
        for (i = 1; i < n; ++i) {
            y[i][3] = (1.0f - work[i - 1]) / t;
            t = 2.0f - work[i] * y[i][3];
            y[i][1] = (y[i][2] - work[i] * y[i - 1][1]) / t;
        }
        for (i = n - 2; i >= 0; --i) {
            float[] fArray = y[i];
            fArray[1] = fArray[1] - y[i + 1][3] * y[i + 1][1];
        }
        CubicInterpolator.compute2ndAnd3rdDerivatives(x, y);
    }

    private static void compute2ndAnd3rdDerivatives(float[] x, float[][] y) {
        int n = x.length;
        for (int i = 0; i < n - 1; ++i) {
            float h2 = x[i + 1] - x[i];
            float del2 = (y[i + 1][0] - y[i][0]) / h2;
            float divdf3 = y[i][1] + y[i + 1][1] - 2.0f * del2;
            y[i][2] = 2.0f * (del2 - y[i][1] - divdf3) / h2;
            y[i][3] = divdf3 / h2 * (6.0f / h2);
        }
        y[n - 1][2] = y[n - 2][2] + (x[n - 1] - x[n - 2]) * y[n - 2][3];
        y[n - 1][3] = y[n - 2][3];
    }

    public static enum Method {
        LINEAR,
        MONOTONIC,
        SPLINE;

    }
}

