/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.interp.LasserreVolume;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LasserreVolumeTest
extends TestCase {
    private LasserreVolume lv2 = new LasserreVolume(2);
    private LasserreVolume lv3 = new LasserreVolume(3);

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(LasserreVolumeTest.class);
        TestRunner.run((Test)suite);
    }

    public void testTriangle() {
        this.lv2.clear();
        this.lv2.addHalfSpace(1.0, 1.0, 1.0);
        this.lv2.addHalfSpace(-1.0, 0.0, 0.0);
        this.lv2.addHalfSpace(0.0, -1.0, 0.0);
        LasserreVolumeTest.assertEquals(0.5, this.lv2.getVolume());
    }

    public void testRedundant() {
        this.lv2.clear();
        this.lv2.addHalfSpace(-1.0, 1.0, 0.0);
        this.lv2.addHalfSpace(1.0, 0.0, 1.0);
        this.lv2.addHalfSpace(0.0, -1.0, 0.0);
        LasserreVolumeTest.assertEquals(0.5, this.lv2.getVolume());
        this.lv2.addHalfSpace(-1.0, 0.0, 0.0);
        LasserreVolumeTest.assertEquals(0.5, this.lv2.getVolume());
        this.lv2.addHalfSpace(1.0, 1.0, 2.0);
        LasserreVolumeTest.assertEquals(0.5, this.lv2.getVolume());
        this.lv2.addHalfSpace(2.0, -1.0, 2.0);
        LasserreVolumeTest.assertEquals(0.5, this.lv2.getVolume());
        this.lv2.addHalfSpace(2.0, -1.0, 4.0);
        LasserreVolumeTest.assertEquals(0.5, this.lv2.getVolume());
        this.lv2.addHalfSpace(2.0, 0.0, 2.0);
        LasserreVolumeTest.assertEquals(1.0, this.lv2.getVolume());
    }

    public void testUnitSquare() {
        this.lv2.clear();
        this.lv2.addHalfSpace(1.0, 0.0, 1.0);
        this.lv2.addHalfSpace(-1.0, 0.0, 0.0);
        this.lv2.addHalfSpace(0.0, 1.0, 1.0);
        this.lv2.addHalfSpace(0.0, -1.0, 0.0);
        LasserreVolumeTest.assertEquals(1.0, this.lv2.getVolume());
        this.lv2.addHalfSpace(1.0, 0.0, 2.0);
        LasserreVolumeTest.assertEquals(2.0, this.lv2.getVolume());
    }

    public void testOctahedron() {
        this.lv2.clear();
        this.lv2.addHalfSpace(1.0, 0.0, 1.0);
        this.lv2.addHalfSpace(-1.0, 0.0, 1.0);
        this.lv2.addHalfSpace(0.0, 1.0, 1.0);
        this.lv2.addHalfSpace(0.0, -1.0, 1.0);
        this.lv2.addHalfSpace(1.0, 1.0, 1.5);
        this.lv2.addHalfSpace(-1.0, 1.0, 1.5);
        this.lv2.addHalfSpace(1.0, -1.0, 1.5);
        this.lv2.addHalfSpace(-1.0, -1.0, 1.5);
        LasserreVolumeTest.assertEquals(3.5, this.lv2.getVolume());
    }

    public void testUnitCube() {
        this.lv3.clear();
        this.lv3.addHalfSpace(1.0, 0.0, 0.0, 1.0);
        this.lv3.addHalfSpace(-1.0, 0.0, 0.0, 0.0);
        this.lv3.addHalfSpace(0.0, 1.0, 0.0, 1.0);
        this.lv3.addHalfSpace(0.0, -1.0, 0.0, 0.0);
        this.lv3.addHalfSpace(0.0, 0.0, 1.0, 1.0);
        this.lv3.addHalfSpace(0.0, 0.0, -1.0, 0.0);
        LasserreVolumeTest.assertEquals(1.0, this.lv3.getVolume());
    }

    private static void assertEquals(double e, double a) {
        LasserreVolumeTest.assertEquals((double)e, (double)a, (double)1.0E-10);
    }
}

