/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.awt.ColorMap;
import edu.mines.jtk.dsp.Tensors2;
import edu.mines.jtk.mosaic.PixelsView;
import edu.mines.jtk.mosaic.SimplePlot;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Parallel;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class TimeMarker2 {
    private static final float INFINITY = Float.MAX_VALUE;
    private static final float EPSILON = 0.001f;
    private static final float ONE_MINUS_EPSILON = 0.999f;
    private int _n1;
    private int _n2;
    private Tensors2 _tensors;
    private Sample[][] _s;
    private Concurrency _concurrency = Concurrency.PARALLEL;
    private static final int[] K1 = new int[]{-1, 1, 0, 0};
    private static final int[] K2 = new int[]{0, 0, -1, 1};
    private static final int[][] K1S = new int[][]{{1, 1, 1}, {-1, -1, -1}, {-1, 1, 0}, {-1, 1, 0}, {-1, 1, -1, 1, -1, 1, 0, 0}};
    private static final int[][] K2S = new int[][]{{-1, 1, 0}, {-1, 1, 0}, {1, 1, 1}, {-1, -1, -1}, {-1, -1, 1, 1, 0, 0, -1, 1}};
    private int _activated = 1;

    public TimeMarker2(int n1, int n2, Tensors2 tensors) {
        this.init(n1, n2, tensors);
    }

    public void setTensors(Tensors2 tensors) {
        this._tensors = tensors;
    }

    public void setConcurrency(Concurrency concurrency) {
        this._concurrency = concurrency;
    }

    public void apply(float[][] times, int[][] marks) {
        for (int i2 = 0; i2 < this._n2; ++i2) {
            for (int i1 = 0; i1 < this._n1; ++i1) {
                if (times[i2][i1] == 0.0f) continue;
                times[i2][i1] = Float.MAX_VALUE;
            }
        }
        short[][] kk = this.indexKnownSamples(times);
        short[] k1 = kk[0];
        short[] k2 = kk[1];
        TimeMarker2.shuffle(k1, k2);
        int nk = k1.length;
        float[][] t = new float[this._n2][this._n1];
        ActiveList al = new ActiveList();
        for (int ik = 0; ik < nk; ++ik) {
            short i1 = k1[ik];
            short i2 = k2[ik];
            this.clearActivated();
            t[i2][i1] = 0.0f;
            al.append(this._s[i2][i1]);
            int m = marks[i2][i1];
            this.solve(al, t, m, times, marks);
        }
    }

    private void solve(ActiveList al, float[][] t, int m, float[][] times, int[][] marks) {
        if (this._concurrency == Concurrency.PARALLEL) {
            this.solveParallel(al, t, m, times, marks);
        } else if (this._concurrency == Concurrency.PARALLELX) {
            this.solveParallelX(al, t, m, times, marks);
        } else {
            this.solveSerial(al, t, m, times, marks);
        }
    }

    private void init(int n1, int n2, Tensors2 tensors) {
        this._n1 = n1;
        this._n2 = n2;
        this._tensors = tensors;
        this._s = new Sample[n2][n1];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                this._s[i2][i1] = new Sample(i1, i2);
            }
        }
    }

    private void clearActivated() {
        if (this._activated == Integer.MAX_VALUE) {
            this._activated = 1;
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    this._s[i2][i1].activated = 0;
                }
            }
        } else {
            ++this._activated;
        }
    }

    private void setActivated(Sample s) {
        s.activated = this._activated;
    }

    private void clearActivated(Sample s) {
        s.activated = 0;
    }

    private boolean wasActivated(Sample s) {
        return s.activated == this._activated;
    }

    private short[][] indexKnownSamples(float[][] times) {
        ShortStack ss1 = new ShortStack();
        ShortStack ss2 = new ShortStack();
        for (int i2 = 0; i2 < this._n2; ++i2) {
            block1: for (int i1 = 0; i1 < this._n1; ++i1) {
                if (times[i2][i1] != 0.0f) continue;
                for (int k = 0; k < 4; ++k) {
                    int j2;
                    int j1 = i1 + K1[k];
                    if (j1 < 0 || j1 >= this._n1 || (j2 = i2 + K2[k]) < 0 || j2 >= this._n2 || times[j2][j1] == 0.0f) continue;
                    ss1.push(i1);
                    ss2.push(i2);
                    continue block1;
                }
            }
        }
        short[] i1 = ss1.array();
        short[] i2 = ss2.array();
        return new short[][]{i1, i2};
    }

    private static void shuffle(short[] i1, short[] i2) {
        int n = i1.length;
        Random r = new Random(314159L);
        for (int i = n - 1; i > 0; --i) {
            int j = r.nextInt(i + 1);
            short ii = i1[i];
            i1[i] = i1[j];
            i1[j] = ii;
            ii = i2[i];
            i2[i] = i2[j];
            i2[j] = ii;
        }
    }

    private void solveSerial(ActiveList al, float[][] t, int m, float[][] times, int[][] marks) {
        float[] d = new float[3];
        ActiveList bl = new ActiveList();
        while (!al.isEmpty()) {
            int n = al.size();
            for (int i = 0; i < n; ++i) {
                Sample s = al.get(i);
                this.solveOne(t, m, times, marks, s, bl, d);
            }
            bl.setAllAbsent();
            al.clear();
            al.appendIfAbsent(bl);
            bl.clear();
        }
    }

    private void solveParallelX(final ActiveList al, final float[][] t, final int m, final float[][] times, final int[][] marks) {
        int nthread = Runtime.getRuntime().availableProcessors();
        ExecutorService es = Executors.newFixedThreadPool(nthread);
        ExecutorCompletionService<Void> cs = new ExecutorCompletionService<Void>(es);
        ActiveList[] bl = new ActiveList[nthread];
        float[][] d = new float[nthread][];
        for (int ithread = 0; ithread < nthread; ++ithread) {
            bl[ithread] = new ActiveList();
            d[ithread] = new float[3];
        }
        final AtomicInteger ai = new AtomicInteger();
        while (!al.isEmpty()) {
            int itask;
            ai.set(0);
            final int n = al.size();
            int mb = 32;
            final int nb = 1 + (n - 1) / 32;
            int ntask = ArrayMath.min(nb, nthread);
            for (itask = 0; itask < ntask; ++itask) {
                final ActiveList bltask = bl[itask];
                final float[] dtask = d[itask];
                cs.submit(new Callable<Void>(){

                    @Override
                    public Void call() {
                        int ib = ai.getAndIncrement();
                        while (ib < nb) {
                            int i = ib * 32;
                            int j = ArrayMath.min(i + 32, n);
                            for (int k = i; k < j; ++k) {
                                Sample s = al.get(k);
                                TimeMarker2.this.solveOne(t, m, times, marks, s, bltask, dtask);
                            }
                            ib = ai.getAndIncrement();
                        }
                        bltask.setAllAbsent();
                        return null;
                    }
                });
            }
            try {
                for (itask = 0; itask < ntask; ++itask) {
                    cs.take();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            al.clear();
            for (itask = 0; itask < ntask; ++itask) {
                al.appendIfAbsent(bl[itask]);
                bl[itask].clear();
            }
        }
        es.shutdown();
    }

    private void solveParallel(final ActiveList al, final float[][] t, final int m, final float[][] times, final int[][] marks) {
        int mbmin = 64;
        int nbmax = 256;
        final float[][] dtask = new float[nbmax][];
        final ActiveList[] bltask = new ActiveList[nbmax];
        while (!al.isEmpty()) {
            final int n = al.size();
            int mbmax = ArrayMath.max(mbmin, 1 + (n - 1) / nbmax);
            int nb = 1 + (n - 1) / mbmax;
            final int mb = 1 + (n - 1) / nb;
            Parallel.loop(nb, new Parallel.LoopInt(){

                @Override
                public void compute(int ib) {
                    if (bltask[ib] == null) {
                        dtask[ib] = new float[3];
                        bltask[ib] = new ActiveList();
                    }
                    int i = ib * mb;
                    int j = ArrayMath.min(i + mb, n);
                    for (int k = i; k < j; ++k) {
                        Sample s = al.get(k);
                        TimeMarker2.this.solveOne(t, m, times, marks, s, bltask[ib], dtask[ib]);
                    }
                    bltask[ib].setAllAbsent();
                }
            });
            al.clear();
            for (int ib = 0; ib < nb; ++ib) {
                if (bltask[ib] == null) continue;
                al.appendIfAbsent(bltask[ib]);
                bltask[ib].clear();
            }
        }
    }

    private float currentTime(float[][] t, int i1, int i2) {
        return this.wasActivated(this._s[i2][i1]) ? t[i2][i1] : Float.MAX_VALUE;
    }

    private void solveOne(float[][] t, int m, float[][] times, int[][] marks, Sample s, ActiveList bl, float[] d) {
        float ci;
        int i1 = s.i1;
        int i2 = s.i2;
        float ti = this.currentTime(t, i1, i2);
        t[i2][i1] = ci = this.computeTime(t, i1, i2, K1S[4], K2S[4], d);
        if (ci >= ti * 0.999f) {
            boolean checkNabors;
            boolean bl2 = checkNabors = ci <= 1.5f * times[i2][i1];
            if (ci < times[i2][i1]) {
                times[i2][i1] = ci;
                marks[i2][i1] = m;
            }
            if (checkNabors) {
                for (int k = 0; k < 4; ++k) {
                    int j2;
                    int j1 = i1 + K1[k];
                    if (j1 < 0 || j1 >= this._n1 || (j2 = i2 + K2[k]) < 0 || j2 >= this._n2) continue;
                    float tj = this.currentTime(t, j1, j2);
                    float cj = this.computeTime(t, j1, j2, K1S[k], K2S[k], d);
                    if (!(cj < tj * 0.999f)) continue;
                    t[j2][j1] = cj;
                    bl.append(this._s[j2][j1]);
                }
            }
        } else {
            bl.append(s);
        }
    }

    private float t1m(float[][] t, int i1, int i2) {
        return --i1 >= 0 && this.wasActivated(this._s[i2][i1]) ? t[i2][i1] : Float.MAX_VALUE;
    }

    private float t1p(float[][] t, int i1, int i2) {
        return ++i1 < this._n1 && this.wasActivated(this._s[i2][i1]) ? t[i2][i1] : Float.MAX_VALUE;
    }

    private float t2m(float[][] t, int i1, int i2) {
        return --i2 >= 0 && this.wasActivated(this._s[i2][i1]) ? t[i2][i1] : Float.MAX_VALUE;
    }

    private float t2p(float[][] t, int i1, int i2) {
        return ++i2 < this._n2 && this.wasActivated(this._s[i2][i1]) ? t[i2][i1] : Float.MAX_VALUE;
    }

    private float computeTime(float[][] t, int i1, int i2, int[] k1s, int[] k2s, float[] d) {
        this._tensors.getTensor(i1, i2, d);
        float d11 = d[0];
        float d12 = d[1];
        float d22 = d[2];
        float e12 = 1.0f / (d11 * d22 - d12 * d12);
        float tc = this.currentTime(t, i1, i2);
        float t1m = this.t1m(t, i1, i2);
        float t1p = this.t1p(t, i1, i2);
        float t2m = this.t2m(t, i1, i2);
        float t2p = this.t2p(t, i1, i2);
        for (int k = 0; k < k1s.length; ++k) {
            float t0;
            float t2;
            float t1;
            int k1 = k1s[k];
            int k2 = k2s[k];
            if (k1 != 0 && k2 != 0) {
                float f = t1 = k1 < 0 ? t1m : t1p;
                if (t1 == Float.MAX_VALUE) continue;
                float f2 = t2 = k2 < 0 ? t2m : t2p;
                if (t2 == Float.MAX_VALUE) continue;
                t0 = TimeMarker2.computeTime(d11, d12, d22, k1, k2, t1, t2);
            } else if (k1 != 0) {
                float f = t1 = k1 < 0 ? t1m : t1p;
                if (t1 == Float.MAX_VALUE) continue;
                t0 = t1 + ArrayMath.sqrt(d22 * e12);
            } else {
                float f = t2 = k2 < 0 ? t2m : t2p;
                if (t2 == Float.MAX_VALUE) continue;
                t0 = t2 + ArrayMath.sqrt(d11 * e12);
            }
            if (!(t0 < tc)) continue;
            return t0;
        }
        return tc;
    }

    private static float computeTime(float d11, float d12, float d22, float s1, float s2, float t1, float t2) {
        double u2;
        double ds12 = d12 * s1 * s2;
        double ds22 = d22 * s2 * s2;
        double t12 = t1 - t2;
        double b = 2.0 * (ds12 + ds22) * t12;
        double ds11 = d11 * s1 * s1;
        double a = ds11 + 2.0 * ds12 + ds22;
        double c = ds22 * t12 * t12 - 1.0;
        double d = b * b - 4.0 * a * c;
        if (d < 0.0) {
            return Float.MAX_VALUE;
        }
        double u1 = (-b + ArrayMath.sqrt(d)) / (2.0 * a);
        if (ds11 * u1 + ds12 * (u2 = u1 + t12) < 0.0 || ds12 * u1 + ds22 * u2 < 0.0) {
            return Float.MAX_VALUE;
        }
        return t1 + (float)u1;
    }

    private static void trace(String s) {
        System.out.println(s);
    }

    private static float[][] toFloat(int[][] i) {
        int n1 = i[0].length;
        int n2 = i.length;
        float[][] f = new float[n2][n1];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                f[i2][i1] = i[i2][i1];
            }
        }
        return f;
    }

    private static void plot(int[][] i) {
        TimeMarker2.plot(TimeMarker2.toFloat(i));
    }

    private static void plot(float[][] f) {
        TimeMarker2.trace("plot f min=" + ArrayMath.min(f) + " max=" + ArrayMath.max(f));
        SimplePlot sp = new SimplePlot(SimplePlot.Origin.UPPER_LEFT);
        sp.setSize(920, 900);
        PixelsView pv = sp.addPixels(f);
        pv.setColorModel(ColorMap.JET);
        pv.setInterpolation(PixelsView.Interpolation.NEAREST);
    }

    private static class ShortStack {
        private int _n = 0;
        private short[] _a = new short[2048];

        private ShortStack() {
        }

        void push(int k) {
            if (this._n == this._a.length) {
                short[] a = new short[2 * this._n];
                System.arraycopy(this._a, 0, a, 0, this._n);
                this._a = a;
            }
            this._a[this._n++] = (short)k;
        }

        short pop() {
            return this._a[--this._n];
        }

        int size() {
            return this._n;
        }

        void clear() {
            this._n = 0;
        }

        boolean isEmpty() {
            return this._n == 0;
        }

        short[] array() {
            short[] a = new short[this._n];
            System.arraycopy(this._a, 0, a, 0, this._n);
            return a;
        }
    }

    private class ActiveList {
        private int _n;
        private Sample[] _a = new Sample[128];

        private ActiveList() {
        }

        void append(Sample s) {
            s.activated = TimeMarker2.this._activated;
            if (this._n == this._a.length) {
                this.growTo(2 * this._n);
            }
            this._a[this._n++] = s;
        }

        boolean isEmpty() {
            return this._n == 0;
        }

        int size() {
            return this._n;
        }

        Sample get(int i) {
            return this._a[i];
        }

        void clear() {
            this._n = 0;
        }

        void setAllAbsent() {
            for (int i = 0; i < this._n; ++i) {
                this._a[i].absent = true;
            }
        }

        void appendIfAbsent(ActiveList al) {
            if (this._n + al._n > this._a.length) {
                this.growTo(2 * (this._n + al._n));
            }
            int n = al._n;
            for (int i = 0; i < n; ++i) {
                Sample s = al.get(i);
                if (!s.absent) continue;
                this._a[this._n++] = s;
                s.absent = false;
            }
        }

        void shuffle() {
            Random r = new Random();
            for (int i = 0; i < this._n; ++i) {
                int j = r.nextInt(this._n);
                int k = r.nextInt(this._n);
                Sample aj = this._a[j];
                this._a[j] = this._a[k];
                this._a[k] = aj;
            }
        }

        void dump() {
            TimeMarker2.trace("ActiveList.dump: n=" + this._n);
            for (int i = 0; i < this._n; ++i) {
                Sample s = this._a[i];
                TimeMarker2.trace(" s[" + i + "] = (" + s.i1 + "," + s.i2 + ")");
            }
        }

        private void growTo(int capacity) {
            Sample[] a = new Sample[capacity];
            System.arraycopy(this._a, 0, a, 0, this._n);
            this._a = a;
        }
    }

    private static class Sample {
        int i1;
        int i2;
        int activated;
        boolean absent;

        Sample(int i1, int i2) {
            this.i1 = i1;
            this.i2 = i2;
        }
    }

    public static enum Concurrency {
        PARALLELX,
        PARALLEL,
        SERIAL;

    }
}

