/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JPanel;

public class IPanel
extends JPanel {
    private static final long serialVersionUID = 1L;

    public void paintToRect(Graphics2D g2d, int x, int y, int w, int h) {
        g2d = this.createGraphics(g2d, x, y, w, h);
        double ws = (double)w / (double)this.getWidth();
        double hs = (double)h / (double)this.getHeight();
        int nc = this.getComponentCount();
        for (int ic = 0; ic < nc; ++ic) {
            Component c = this.getComponent(ic);
            int xc = c.getX();
            int yc = c.getY();
            int wc = c.getWidth();
            int hc = c.getHeight();
            xc = (int)Math.round((double)xc * ws);
            yc = (int)Math.round((double)yc * hs);
            wc = (int)Math.round((double)wc * ws);
            hc = (int)Math.round((double)hc * hs);
            if (!(c instanceof IPanel)) continue;
            IPanel ip = (IPanel)c;
            ip.paintToRect(g2d, xc, yc, wc, hc);
        }
        g2d.dispose();
    }

    public void paintToImage(BufferedImage image) {
        Graphics2D g2d = image.createGraphics();
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2d.setColor(this.getForeground());
        g2d.setFont(this.getFont());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintToRect(g2d, 0, 0, image.getWidth(), image.getHeight());
        g2d.dispose();
    }

    public BufferedImage paintToImage(int width) {
        int wpanel = this.getWidth();
        int hpanel = this.getHeight();
        double scale = (double)width / (double)wpanel;
        int wimage = (int)(scale * (double)wpanel + 0.5);
        int himage = (int)(scale * (double)hpanel + 0.5);
        int type = 1;
        BufferedImage image = new BufferedImage(wimage, himage, type);
        this.paintToImage(image);
        return image;
    }

    public void paintToPng(double dpi, double win, String fileName) throws IOException {
        BufferedImage image = this.paintToImage((int)Math.ceil(dpi * win));
        Iterator<ImageWriter> i = ImageIO.getImageWritersBySuffix("png");
        if (!i.hasNext()) {
            throw new IOException("cannot get a PNG image writer");
        }
        ImageWriter iw = i.next();
        FileOutputStream fos = new FileOutputStream(fileName);
        ImageOutputStream ios = ImageIO.createImageOutputStream(fos);
        iw.setOutput(ios);
        ImageWriteParam iwp = iw.getDefaultWriteParam();
        ImageTypeSpecifier its = new ImageTypeSpecifier(image);
        IIOMetadata imd = iw.getDefaultImageMetadata(its, iwp);
        String format = "javax_imageio_png_1.0";
        IIOMetadataNode tree = (IIOMetadataNode)imd.getAsTree(format);
        IIOMetadataNode node = new IIOMetadataNode("pHYs");
        String dpm = Integer.toString((int)Math.ceil(dpi / 0.0254));
        node.setAttribute("pixelsPerUnitXAxis", dpm);
        node.setAttribute("pixelsPerUnitYAxis", dpm);
        node.setAttribute("unitSpecifier", "meter");
        tree.appendChild(node);
        imd.setFromTree(format, tree);
        iw.write(new IIOImage(image, null, imd));
        ios.flush();
        ios.close();
        fos.flush();
        fos.close();
        iw.dispose();
    }

    protected double computeScale(int w, int h) {
        double wscale = (double)w / (double)this.getWidth();
        double hscale = (double)h / (double)this.getHeight();
        double scale = Math.min(wscale, hscale);
        return scale;
    }

    protected Graphics2D createGraphics(Graphics2D g2d, int x, int y, int w, int h) {
        g2d = (Graphics2D)g2d.create();
        double scale = this.computeScale(w, h);
        Rectangle clipRect = g2d.getClipBounds();
        Rectangle g2dRect = new Rectangle(x, y, w, h);
        g2d.setClip(clipRect == null ? g2dRect : clipRect.intersection(g2dRect));
        g2d.translate(x, y);
        float lineWidth = (float)scale;
        g2d.setStroke(new BasicStroke(lineWidth));
        Font font = this.getFont();
        float fontSize = (float)scale * font.getSize2D();
        g2d.setFont(font.deriveFont(fontSize));
        return g2d;
    }

    protected float getLineWidth(Graphics2D g2d) {
        float lineWidth = 1.0f;
        Stroke stroke = g2d.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)stroke;
            lineWidth = bs.getLineWidth();
        }
        return lineWidth;
    }

    protected void scaleLineWidth(Graphics2D g2d, double scale) {
        float lineWidth = this.getLineWidth(g2d);
        lineWidth = (float)((double)lineWidth * scale);
        g2d.setStroke(new BasicStroke(lineWidth));
    }
}

