/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.ArrayStack;
import edu.mines.jtk.sgl.Matrix44;
import edu.mines.jtk.sgl.TraversalContext;
import edu.mines.jtk.sgl.View;
import edu.mines.jtk.sgl.ViewCanvas;
import edu.mines.jtk.sgl.World;

public class TransformContext
extends TraversalContext {
    private ViewCanvas _canvas;
    private View _view;
    private World _world;
    private Matrix44 _localToWorld = new Matrix44();
    private Matrix44 _worldToView = new Matrix44();
    private Matrix44 _viewToCube = new Matrix44();
    private Matrix44 _cubeToPixel = new Matrix44();
    private ArrayStack<Matrix44> _localToWorldStack = new ArrayStack();

    public TransformContext(ViewCanvas canvas) {
        this._canvas = canvas;
        this._view = this._canvas.getView();
        this._world = this._view.getWorld();
        this._localToWorld = Matrix44.identity();
        this._worldToView = this._view.getWorldToView();
        this._viewToCube = this._canvas.getViewToCube();
        this._cubeToPixel = this._canvas.getCubeToPixel();
    }

    public ViewCanvas getViewCanvas() {
        return this._canvas;
    }

    public View getView() {
        return this._view;
    }

    public World getWorld() {
        return this._world;
    }

    public Matrix44 getLocalToWorld() {
        return new Matrix44(this._localToWorld);
    }

    public Matrix44 getWorldToLocal() {
        return this.getLocalToWorld().inverseEquals();
    }

    public Matrix44 getLocalToView() {
        return this.getWorldToView().timesEquals(this._localToWorld);
    }

    public Matrix44 getViewToLocal() {
        return this.getLocalToView().inverseEquals();
    }

    public Matrix44 getLocalToCube() {
        return this.getWorldToCube().timesEquals(this._localToWorld);
    }

    public Matrix44 getCubeToLocal() {
        return this.getLocalToCube().inverseEquals();
    }

    public Matrix44 getLocalToPixel() {
        return this.getWorldToPixel().timesEquals(this._localToWorld);
    }

    public Matrix44 getPixelToLocal() {
        return this.getLocalToPixel().inverseEquals();
    }

    public Matrix44 getWorldToView() {
        return new Matrix44(this._worldToView);
    }

    public Matrix44 getViewToWorld() {
        return this.getWorldToView().inverseEquals();
    }

    public Matrix44 getWorldToCube() {
        return this.getViewToCube().timesEquals(this._worldToView);
    }

    public Matrix44 getCubeToWorld() {
        return this.getWorldToCube().inverseEquals();
    }

    public Matrix44 getWorldToPixel() {
        return this.getViewToPixel().timesEquals(this._worldToView);
    }

    public Matrix44 getPixelToWorld() {
        return this.getWorldToPixel().inverseEquals();
    }

    public Matrix44 getViewToCube() {
        return new Matrix44(this._viewToCube);
    }

    public Matrix44 getCubeToView() {
        return this.getViewToCube().inverseEquals();
    }

    public Matrix44 getViewToPixel() {
        return this.getCubeToPixel().timesEquals(this._viewToCube);
    }

    public Matrix44 getPixelToView() {
        return this.getViewToPixel().inverseEquals();
    }

    public Matrix44 getCubeToPixel() {
        return new Matrix44(this._cubeToPixel);
    }

    public Matrix44 getPixelToCube() {
        return this.getCubeToPixel().inverseEquals();
    }

    public void pushLocalToWorld(Matrix44 transform) {
        this._localToWorldStack.push(new Matrix44(this._localToWorld));
        this._localToWorld.timesEquals(transform);
    }

    public void popLocalToWorld() {
        this._localToWorld = this._localToWorldStack.pop();
    }
}

