/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.Clips;
import edu.mines.jtk.util.Float3;

public class FloatByteMap {
    private Clips _clips;
    private float _fmin;
    private float _fmax;
    private float _flower;
    private float _fupper;
    private float _fscale;
    private boolean _dirty = true;

    public FloatByteMap(float[] f) {
        this._clips = new Clips(f);
    }

    public FloatByteMap(float[][] f) {
        this._clips = new Clips(f);
    }

    public FloatByteMap(float[][][] f) {
        this._clips = new Clips(f);
    }

    public FloatByteMap(Float3 f3) {
        this._clips = new Clips(f3);
    }

    public FloatByteMap(double percMin, double percMax, float[] f) {
        this._clips = new Clips(percMin, percMax, f);
    }

    public FloatByteMap(double percMin, double percMax, float[][] f) {
        this._clips = new Clips(percMin, percMax, f);
    }

    public FloatByteMap(double percMin, double percMax, float[][][] f) {
        this._clips = new Clips(percMin, percMax, f);
    }

    public FloatByteMap(double percMin, double percMax, Float3 f3) {
        this._clips = new Clips(percMin, percMax, f3);
    }

    public int getByte(float f) {
        if (this._dirty) {
            this.update();
        }
        if (f < this._flower) {
            f = this._flower;
        }
        if (f > this._fupper) {
            f = this._fupper;
        }
        return (int)((f - this._flower) * this._fscale);
    }

    public void getBytes(float[] f, byte[] b) {
        this.getBytes(f, b, 0);
    }

    public void getBytes(float[][] f, byte[][] b) {
        int n = f.length;
        for (int i = 0; i < n; ++i) {
            this.getBytes(f[i], b[i]);
        }
    }

    public void getBytes(float[][] f, byte[] b) {
        int n1 = f[0].length;
        int n2 = f.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.getBytes(f[i2], b, i2 * n1);
        }
    }

    public void getBytes(float[][][] f, byte[][][] b) {
        int n = f.length;
        for (int i = 0; i < n; ++i) {
            this.getBytes(f[i], b[i]);
        }
    }

    public void getBytes(float[][][] f, byte[] b) {
        int n1 = f[0][0].length;
        int n2 = f[0].length;
        int n3 = f.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.getBytes(f[i3][i2], b, i2 * n1 + i3 * n1 * n2);
            }
        }
    }

    public void getBytes(Float3 f3, byte[][][] b) {
        int n1 = f3.getN1();
        int n2 = f3.getN2();
        int n3 = f3.getN3();
        float[][] fi3 = new float[n2][n1];
        for (int i3 = 0; i3 < n3; ++i3) {
            f3.get12(n1, n2, 0, 0, i3, fi3);
            this.getBytes(fi3, b[i3]);
        }
    }

    public void getBytes(Float3 f3, byte[] b) {
        int n1 = f3.getN1();
        int n2 = f3.getN2();
        int n3 = f3.getN3();
        float[][] fi3 = new float[n2][n1];
        for (int i3 = 0; i3 < n3; ++i3) {
            f3.get12(n1, n2, 0, 0, i3, fi3);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.getBytes(fi3[i2], b, i2 * n1 + i3 * n1 * n2);
            }
        }
    }

    public void setClips(double clipMin, double clipMax) {
        this._clips.setClips(clipMin, clipMax);
    }

    public float getClipMin() {
        return this._clips.getClipMin();
    }

    public float getClipMax() {
        return this._clips.getClipMax();
    }

    public void setPercentiles(double percMin, double percMax) {
        this._clips.setPercentiles(percMin, percMax);
    }

    public float getPercentileMin() {
        return this._clips.getPercentileMin();
    }

    public float getPercentileMax() {
        return this._clips.getPercentileMax();
    }

    private void update() {
        if (this._dirty) {
            this._fmin = this._clips.getClipMin();
            this._fmax = this._clips.getClipMax();
            this._fscale = 256.0f / (this._fmax - this._fmin);
            this._flower = this._fmin;
            this._fupper = this._flower + 255.5f / this._fscale;
            this._dirty = false;
        }
    }

    private void getBytes(float[] f, byte[] b, int j) {
        if (this._dirty) {
            this.update();
        }
        int n = f.length;
        int i = 0;
        while (i < n) {
            float fi = f[i];
            if (fi < this._flower) {
                fi = this._flower;
            }
            if (fi > this._fupper) {
                fi = this._fupper;
            }
            b[j] = (byte)((fi - this._flower) * this._fscale);
            ++i;
            ++j;
        }
    }
}

