/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gpu;

import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.type.numeric.real.FloatType;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuApi;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuView;
import sc.fiji.labkit.pixel_classification.gpu.compute_cache.GpuComputeCache;
import sc.fiji.labkit.pixel_classification.gpu.compute_cache.GpuDerivativeContent;
import sc.fiji.labkit.pixel_classification.gpu.compute_cache.GpuGaussContent;
import sc.fiji.labkit.pixel_classification.gpu.compute_cache.GpuOriginalContent;
import sc.fiji.labkit.pixel_classification.gpu.compute_cache.GpuSecondDerivativeContent;

public class GpuFeatureInput {
    private final GpuApi gpu;
    private final Interval targetInterval;
    private final GpuComputeCache cache;

    public GpuFeatureInput(GpuApi gpu, RandomAccessible<FloatType> original, Interval targetInterval, double[] pixelSize) {
        this.gpu = gpu;
        this.targetInterval = targetInterval;
        this.cache = new GpuComputeCache(gpu, original, pixelSize);
    }

    public void prefetchOriginal(Interval interval) {
        this.cache.request(new GpuOriginalContent(this.cache), interval);
    }

    public GpuView original(Interval interval) {
        return this.cache.get(new GpuOriginalContent(this.cache), interval);
    }

    public void prefetchGauss(double sigma, Interval interval) {
        this.cache.request(this.gaussKey(sigma), interval);
    }

    public GpuView gauss(double sigma, Interval interval) {
        return this.cache.get(this.gaussKey(sigma), interval);
    }

    public void prefetchDerivative(double sigma, int dimension, Interval interval) {
        this.cache.request(new GpuDerivativeContent(this.cache, this.gaussKey(sigma), dimension), interval);
    }

    public GpuView derivative(double sigma, int dimension, Interval interval) {
        return this.cache.get(new GpuDerivativeContent(this.cache, this.gaussKey(sigma), dimension), interval);
    }

    public void prefetchSecondDerivative(double sigma, int dimensionA, int dimensionB, Interval interval) {
        this.cache.request(this.secondDerivativeKey(sigma, dimensionA, dimensionB), interval);
    }

    public GpuView secondDerivative(double sigma, int dimensionA, int dimensionB, Interval interval) {
        return this.cache.get(this.secondDerivativeKey(sigma, dimensionA, dimensionB), interval);
    }

    private GpuGaussContent gaussKey(double sigma) {
        return new GpuGaussContent(this.cache, sigma);
    }

    private GpuComputeCache.Content secondDerivativeKey(double sigma, int dimensionA, int dimensionB) {
        if (dimensionA > dimensionB) {
            return this.secondDerivativeKey(sigma, dimensionB, dimensionA);
        }
        if (dimensionA == dimensionB) {
            return new GpuSecondDerivativeContent(this.cache, this.gaussKey(sigma), dimensionA);
        }
        return new GpuDerivativeContent(this.cache, new GpuDerivativeContent(this.cache, this.gaussKey(sigma), dimensionA), dimensionB);
    }

    public Interval targetInterval() {
        return this.targetInterval;
    }

    public GpuApi gpuApi() {
        return this.gpu;
    }
}

