/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.metadata.imagej;

import ij.ImagePlus;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import net.imglib2.realtransform.AffineTransform3D;
import org.janelia.saalfeldlab.n5.metadata.imagej.ImageplusMetadata;
import org.janelia.saalfeldlab.n5.metadata.imagej.SpatialMetadataToImagePlus;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadataParser;

public class N5ViewerToImagePlus
extends SpatialMetadataToImagePlus<N5SingleScaleMetadata> {
    @Override
    public N5SingleScaleMetadata readMetadata(ImagePlus imp) throws IOException {
        int nd = imp.getNSlices() > 1 ? 3 : 2;
        Object[] units = new String[nd];
        Arrays.fill(units, imp.getCalibration().getUnit());
        double[] scale = new double[3];
        double[] translation = new double[3];
        if (nd == 2) {
            scale[0] = imp.getCalibration().pixelWidth;
            scale[1] = imp.getCalibration().pixelHeight;
            scale[2] = 1.0;
            translation[0] = imp.getCalibration().xOrigin;
            translation[1] = imp.getCalibration().yOrigin;
            translation[2] = 0.0;
        } else if (nd == 3) {
            scale[0] = imp.getCalibration().pixelWidth;
            scale[1] = imp.getCalibration().pixelHeight;
            scale[2] = imp.getCalibration().pixelDepth;
            translation[0] = imp.getCalibration().xOrigin;
            translation[1] = imp.getCalibration().yOrigin;
            translation[2] = imp.getCalibration().zOrigin;
        }
        double[] downsamplingFactors = new double[]{1.0, 1.0, 1.0};
        AffineTransform3D transform = N5SingleScaleMetadataParser.buildTransform((double[])downsamplingFactors, (double[])scale, Optional.empty());
        return new N5SingleScaleMetadata("", transform, downsamplingFactors, scale, translation, (String)units[0], ImageplusMetadata.datasetAttributes(imp));
    }
}

