/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.ui;

import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ImprovedFormattedTextField
extends JFormattedTextField {
    private static final long serialVersionUID = 6986337989217402465L;
    private static final Color ERROR_BACKGROUND_COLOR = new Color(255, 215, 215);
    private static final Color ERROR_FOREGROUND_COLOR = null;
    private Color fBackground;
    private Color fForeground;
    private Runnable updateCallback;
    private boolean runCallback;

    public ImprovedFormattedTextField(JFormattedTextField.AbstractFormatter formatter) {
        super(formatter);
        this.setFocusLostBehavior(1);
        this.updateBackgroundOnEachUpdate();
        this.addFocusListener(new MousePositionCorrectorListener());
        this.addFocusListener(new ContainerTextUpdateOnFocus(this));
        this.runCallback = true;
    }

    public ImprovedFormattedTextField(JFormattedTextField.AbstractFormatter formatter, Object aValue) {
        this(formatter);
        String strValue = aValue instanceof String ? (String)aValue : "";
        try {
            this.setValue(new URI(strValue));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public void setCallback(Runnable updateCallback) {
        this.updateCallback = updateCallback;
    }

    private void updateBackgroundOnEachUpdate() {
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            public void update() {
                ImprovedFormattedTextField.this.updateBackground();
                if (ImprovedFormattedTextField.this.runCallback && ImprovedFormattedTextField.this.updateCallback != null) {
                    ImprovedFormattedTextField.this.updateCallback.run();
                }
            }
        });
    }

    private void updateBackground() {
        boolean valid = this.validContent();
        if (ERROR_BACKGROUND_COLOR != null) {
            this.setBackground(valid ? this.fBackground : ERROR_BACKGROUND_COLOR);
        }
        if (ERROR_FOREGROUND_COLOR != null) {
            this.setForeground(valid ? this.fForeground : ERROR_FOREGROUND_COLOR);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.fBackground = this.getBackground();
        this.fForeground = this.getForeground();
    }

    private boolean validContent() {
        JFormattedTextField.AbstractFormatter formatter = this.getFormatter();
        if (formatter != null) {
            try {
                formatter.stringToValue(this.getText());
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }
        return true;
    }

    public void setValue(Object value, boolean callback, boolean validate) {
        boolean validValue = true;
        try {
            JFormattedTextField.AbstractFormatter formatter = this.getFormatter();
            if (formatter != null && validate) {
                formatter.stringToValue(this.getText());
            }
        }
        catch (ParseException e) {
            validValue = false;
            this.updateBackground();
        }
        if (validValue) {
            int old_caret_position = this.getCaretPosition();
            boolean before = this.runCallback;
            this.runCallback = callback;
            super.setValue(value);
            this.runCallback = before;
            this.setCaretPosition(Math.min(old_caret_position, this.getText().length()));
        }
    }

    public void setValue(Object value, boolean callback) {
        this.setValue(value, callback, true);
    }

    public void setValueNoCallback(Object value) {
        this.setValue(value, false);
    }

    @Override
    public void setValue(Object value) {
        this.setValue(value, true);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (this.validContent()) {
            return super.processKeyBinding(ks, e, condition, pressed) && ks != KeyStroke.getKeyStroke(10, 0);
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public void validateAndUpdate() {
        JFormattedTextField.AbstractFormatter formatter = this.getFormatter();
        if (formatter != null) {
            try {
                Object result = formatter.stringToValue(this.getText());
                this.setValue((URI)result, false, false);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private static class ContainerTextUpdateOnFocus
    extends FocusAdapter {
        private final ImprovedFormattedTextField field;

        public ContainerTextUpdateOnFocus(ImprovedFormattedTextField field) {
            this.field = field;
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.field.validateAndUpdate();
        }
    }

    private static class MousePositionCorrectorListener
    extends FocusAdapter {
        private MousePositionCorrectorListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            final JTextField field = (JTextField)e.getSource();
            final int dot = field.getCaret().getDot();
            final int mark = field.getCaret().getMark();
            if (field.isEnabled() && field.isEditable()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (dot == mark) {
                            field.getCaret().setDot(dot);
                        }
                    }
                });
            }
        }
    }
}

