/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.transform;

import mpicbg.trakem2.transform.InvertibleCoordinateTransform;

public class SimilarityModel2D
extends mpicbg.models.SimilarityModel2D
implements InvertibleCoordinateTransform {
    @Override
    public void init(String data) throws NumberFormatException {
        String[] fields = data.split("\\s+");
        if (fields.length != 4) {
            throw new NumberFormatException("Inappropriate parameters for " + this.getClass().getCanonicalName());
        }
        float scos = Float.parseFloat(fields[0]);
        float ssin = Float.parseFloat(fields[1]);
        float tx = Float.parseFloat(fields[2]);
        float ty = Float.parseFloat(fields[3]);
        this.set(scos, ssin, tx, ty);
    }

    @Override
    public String toDataString() {
        return this.scos + " " + this.ssin + " " + this.tx + " " + this.ty;
    }

    @Override
    public String toXML(String indent) {
        return indent + "<iict_transform class=\"" + this.getClass().getCanonicalName() + "\" data=\"" + this.toDataString() + "\" />";
    }

    @Override
    public SimilarityModel2D copy() {
        SimilarityModel2D m = new SimilarityModel2D();
        m.scos = this.scos;
        m.ssin = this.ssin;
        m.tx = this.tx;
        m.ty = this.ty;
        m.cost = this.cost;
        m.invert();
        return m;
    }
}

