/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler;

import com.google.common.collect.Maps;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.renjin.compiler.ByteCodeUtil;
import org.renjin.compiler.ConstantGeneratingVisitor;
import org.renjin.compiler.GenerationContext;
import org.renjin.compiler.cfg.BasicBlock;
import org.renjin.compiler.ir.ssa.PhiFunction;
import org.renjin.compiler.ir.ssa.SsaVariable;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.expressions.CallExpression;
import org.renjin.compiler.ir.tac.expressions.CmpGE;
import org.renjin.compiler.ir.tac.expressions.Constant;
import org.renjin.compiler.ir.tac.expressions.DynamicCall;
import org.renjin.compiler.ir.tac.expressions.ElementAccess;
import org.renjin.compiler.ir.tac.expressions.Elipses;
import org.renjin.compiler.ir.tac.expressions.EnvironmentVariable;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.ExpressionVisitor;
import org.renjin.compiler.ir.tac.expressions.IRThunk;
import org.renjin.compiler.ir.tac.expressions.Increment;
import org.renjin.compiler.ir.tac.expressions.LValue;
import org.renjin.compiler.ir.tac.expressions.Length;
import org.renjin.compiler.ir.tac.expressions.LocalVariable;
import org.renjin.compiler.ir.tac.expressions.MakeClosure;
import org.renjin.compiler.ir.tac.expressions.PrimitiveCall;
import org.renjin.compiler.ir.tac.expressions.Temp;
import org.renjin.compiler.ir.tac.statements.Assignment;
import org.renjin.compiler.ir.tac.statements.ExprStatement;
import org.renjin.compiler.ir.tac.statements.GotoStatement;
import org.renjin.compiler.ir.tac.statements.IfStatement;
import org.renjin.compiler.ir.tac.statements.ReturnStatement;
import org.renjin.compiler.ir.tac.statements.StatementVisitor;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class ByteCodeVisitor
implements StatementVisitor,
ExpressionVisitor,
Opcodes {
    private GenerationContext generationContext;
    private MethodVisitor mv;
    private Map<LValue, Integer> variableSlots = Maps.newHashMap();
    private Map<IRLabel, Label> labels = Maps.newHashMap();
    private int work1;
    private int localVariablesStart;

    public ByteCodeVisitor(GenerationContext generationContext, MethodVisitor mv) {
        this.generationContext = generationContext;
        this.mv = mv;
        this.work1 = generationContext.getFirstFreeLocalVariable();
        this.localVariablesStart = this.work1 + 1;
    }

    @Override
    public void visitAssignment(Assignment assignment) {
        LValue lhs = assignment.getLHS();
        if (lhs instanceof EnvironmentVariable) {
            this.environmentAssignment(((EnvironmentVariable)lhs).getName(), assignment.getRHS());
        } else {
            this.localVariableAssignment(lhs, assignment.getRHS());
        }
    }

    private void localVariableAssignment(LValue lhs, Expression rhs) {
        if (rhs instanceof Increment) {
            Increment inc = (Increment)rhs;
            if (inc.getCounter().equals(lhs)) {
                this.mv.visitIincInsn(this.getVariableSlot(lhs), 1);
                return;
            }
        } else if (rhs instanceof Constant) {
            Constant constant = (Constant)rhs;
            constant.accept(this);
            if (constant.getValue() instanceof Integer) {
                this.mv.visitVarInsn(54, this.getVariableSlot(lhs));
            } else {
                this.mv.visitVarInsn(58, this.getVariableSlot(lhs));
            }
        } else if (rhs instanceof Length) {
            rhs.accept(this);
            this.mv.visitVarInsn(54, this.getVariableSlot(lhs));
        } else {
            rhs.accept(this);
            this.mv.visitVarInsn(58, this.getVariableSlot(lhs));
        }
    }

    private void environmentAssignment(Symbol name, Expression rhs) {
        this.loadContext();
        this.mv.visitMethodInsn(182, "org/renjin/eval/Context", "getEnvironment", "()Lorg/renjin/sexp/Environment;");
        this.mv.visitLdcInsn((Object)name.getPrintName());
        this.mv.visitMethodInsn(184, "org/renjin/sexp/Symbol", "get", "(Ljava/lang/String;)Lorg/renjin/sexp/Symbol;");
        rhs.accept(this);
        this.mv.visitMethodInsn(182, "org/renjin/sexp/Environment", "setVariable", "(Lorg/renjin/sexp/Symbol;Lorg/renjin/sexp/SEXP;)V");
    }

    public void startBasicBlock(BasicBlock bb) {
        if (bb.getLabels() != null) {
            for (IRLabel label : bb.getLabels()) {
                this.mv.visitLabel(this.getAsmLabel(label));
            }
        }
    }

    @Override
    public void visitConstant(Constant constant) {
        if (constant.getValue() instanceof SEXP) {
            SEXP exp2 = (SEXP)constant.getValue();
            exp2.accept(new ConstantGeneratingVisitor(this.mv));
        } else if (constant.getValue() instanceof Integer) {
            ByteCodeUtil.pushInt(this.mv, (Integer)constant.getValue());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void visitDynamicCall(DynamicCall call2) {
        if (call2.getFunctionSexp() instanceof Symbol) {
            this.loadEnvironment();
            this.loadContext();
            this.mv.visitLdcInsn((Object)((Symbol)call2.getFunctionSexp()).getPrintName());
            this.mv.visitMethodInsn(184, "org/renjin/sexp/Symbol", "get", "(Ljava/lang/String;)Lorg/renjin/sexp/Symbol;");
            this.mv.visitMethodInsn(182, "org/renjin/sexp/Environment", "findFunctionOrThrow", "(Lorg/renjin/eval/Context;Lorg/renjin/sexp/Symbol;)Lorg/renjin/sexp/Function;");
        } else {
            call2.getFunction().accept(this);
        }
        Label finish = new Label();
        Label builtinCall = new Label();
        this.mv.visitInsn(89);
        this.mv.visitTypeInsn(193, "org/renjin/sexp/BuiltinFunction");
        this.mv.visitJumpInsn(154, builtinCall);
        Label closureCall = new Label();
        this.mv.visitInsn(89);
        this.mv.visitTypeInsn(193, "org/renjin/sexp/Closure");
        this.mv.visitJumpInsn(154, closureCall);
        this.applySpecialDynamically(call2);
        this.mv.visitJumpInsn(167, finish);
        this.mv.visitLabel(closureCall);
        this.applyClosureDynamically(call2);
        this.mv.visitJumpInsn(167, finish);
        this.mv.visitLabel(builtinCall);
        this.applyBuiltinDynamically(call2);
        this.mv.visitLabel(finish);
    }

    private void applySpecialDynamically(DynamicCall call2) {
        this.loadContext();
        this.loadEnvironment();
        this.pushSexp(call2.getSExpression());
        this.mv.visitInsn(89);
        this.mv.visitMethodInsn(182, "org/renjin/sexp/FunctionCall", "getArguments", "()Lorg/renjin/sexp/PairList;");
        this.mv.visitMethodInsn(185, "org/renjin/sexp/Function", "apply", "(Lorg/renjin/eval/Context;Lorg/renjin/sexp/Environment;Lorg/renjin/sexp/FunctionCall;Lorg/renjin/sexp/PairList;)Lorg/renjin/sexp/SEXP;");
    }

    private void loadEnvironment() {
        this.mv.visitVarInsn(25, this.generationContext.getEnvironmentLdc());
    }

    private void applyClosureDynamically(DynamicCall call2) {
        this.mv.visitTypeInsn(192, "org/renjin/sexp/Closure");
        this.loadContext();
        this.loadEnvironment();
        this.pushSexp(call2.getSExpression());
        this.mv.visitTypeInsn(187, "org/renjin/sexp/PairList$Builder");
        this.mv.visitInsn(89);
        this.mv.visitMethodInsn(183, "org/renjin/sexp/PairList$Builder", "<init>", "()V");
        for (int i = 0; i != call2.getArguments().size(); ++i) {
            Expression argument = call2.getArguments().get(i);
            if (argument == Elipses.INSTANCE) {
                this.loadElipses();
                this.mv.visitMethodInsn(182, "org/renjin/sexp/PairList$Builder", "addAll", "(Lorg/renjin/sexp/PairList;)Lorg/renjin/sexp/PairList$Builder;");
                continue;
            }
            if (call2.getArgumentNames().get(i) != null) {
                this.mv.visitLdcInsn((Object)call2.getArgumentNames().get(i));
            }
            if (argument instanceof IRThunk) {
                if (argument.getSExpression() instanceof Symbol) {
                    Symbol symbol2 = (Symbol)argument.getSExpression();
                    this.mv.visitTypeInsn(187, "org/renjin/compiler/runtime/VariablePromise");
                    this.mv.visitInsn(89);
                    this.loadContext();
                    this.mv.visitLdcInsn((Object)symbol2.getPrintName());
                    this.mv.visitMethodInsn(183, "org/renjin/compiler/runtime/VariablePromise", "<init>", "(Lorg/renjin/eval/Context;Ljava/lang/String;)V");
                } else {
                    String thunkClass = this.generationContext.getThunkMap().getClassName((IRThunk)argument);
                    this.mv.visitTypeInsn(187, thunkClass);
                    this.mv.visitInsn(89);
                    this.loadContext();
                    this.loadEnvironment();
                    this.mv.visitMethodInsn(183, thunkClass, "<init>", "(Lorg/renjin/eval/Context;Lorg/renjin/sexp/Environment;)V");
                }
            } else {
                argument.accept(this);
            }
            if (call2.getArgumentNames().get(i) != null) {
                this.mv.visitMethodInsn(182, "org/renjin/sexp/PairList$Builder", "add", "(Ljava/lang/String;Lorg/renjin/sexp/SEXP;)Lorg/renjin/sexp/PairList$Builder;");
                continue;
            }
            this.mv.visitMethodInsn(182, "org/renjin/sexp/PairList$Builder", "add", "(Lorg/renjin/sexp/SEXP;)Lorg/renjin/sexp/PairList$Builder;");
        }
        this.mv.visitMethodInsn(182, "org/renjin/sexp/PairList$Builder", "build", "()Lorg/renjin/sexp/PairList;");
        this.mv.visitMethodInsn(182, "org/renjin/sexp/Closure", "matchAndApply", "(Lorg/renjin/eval/Context;Lorg/renjin/sexp/Environment;Lorg/renjin/sexp/FunctionCall;Lorg/renjin/sexp/PairList;)Lorg/renjin/sexp/SEXP;");
    }

    private void loadContext() {
        this.mv.visitVarInsn(25, this.generationContext.getContextLdc());
    }

    private void applyBuiltinDynamically(DynamicCall call2) {
        this.mv.visitTypeInsn(192, "org/renjin/sexp/BuiltinFunction");
        this.maybeStoreElipses(call2);
        this.loadContext();
        this.loadEnvironment();
        this.pushSexp(call2.getCall());
        this.pushArgNames(call2);
        this.maybeSpliceArgumentNames(call2);
        if (call2.hasElipses()) {
            this.loadContext();
            this.pushEvaluatedArgs(call2);
            this.spliceArgumentValues(call2);
        } else {
            this.pushEvaluatedArgs(call2);
        }
        this.mv.visitMethodInsn(182, "org/renjin/sexp/BuiltinFunction", "apply", "(Lorg/renjin/eval/Context;Lorg/renjin/sexp/Environment;Lorg/renjin/sexp/FunctionCall;[Ljava/lang/String;[Lorg/renjin/sexp/SEXP;)Lorg/renjin/sexp/SEXP;");
    }

    private void pushArgNames(CallExpression call2) {
        this.pushInt(call2.getArgumentNames().size());
        this.mv.visitTypeInsn(189, "java/lang/String");
        for (int i = 0; i != call2.getArgumentNames().size(); ++i) {
            if (call2.getArgumentNames().get(i) == null) continue;
            this.mv.visitInsn(89);
            ByteCodeUtil.pushInt(this.mv, i);
            this.mv.visitLdcInsn((Object)call2.getArgumentNames().get(i));
            this.mv.visitInsn(83);
        }
    }

    private void maybeSpliceArgumentNames(CallExpression call2) {
        if (call2.hasElipses()) {
            this.mv.visitVarInsn(25, this.work1);
            this.pushInt(call2.getElipsesIndex());
            this.mv.visitMethodInsn(184, "org/renjin/compiler/runtime/CompiledRuntime", "spliceArgNames", "([Ljava/lang/String;Lorg/renjin/sexp/PairList;I)[Ljava/lang/String;");
        }
    }

    private void pushSexp(FunctionCall call2) {
        this.generationContext.getSexpPool().pushSexp(this.mv, call2, "Lorg/renjin/sexp/FunctionCall;");
    }

    private void pushEvaluatedArgs(DynamicCall call2) {
        this.pushInt(call2.getArguments().size());
        this.mv.visitTypeInsn(189, "org/renjin/sexp/SEXP");
        for (int i = 0; i != call2.getArguments().size(); ++i) {
            if (call2.getArguments().get(i) == Elipses.INSTANCE) continue;
            this.mv.visitInsn(89);
            this.pushInt(i);
            Expression arg = call2.getArguments().get(i);
            if (arg instanceof IRThunk) {
                SEXP sexp = ((IRThunk)arg).getSEXP();
                if (sexp instanceof Symbol) {
                    this.visitEnvironmentVariable(new EnvironmentVariable((Symbol)sexp));
                } else {
                    this.loadContext();
                    this.loadEnvironment();
                    String thunkClass = this.generationContext.getThunkMap().getClassName((IRThunk)arg);
                    this.mv.visitMethodInsn(184, thunkClass, "doEval", "(Lorg/renjin/eval/Context;Lorg/renjin/sexp/Environment;)Lorg/renjin/sexp/SEXP;");
                }
            } else {
                arg.accept(this);
            }
            this.mv.visitInsn(83);
        }
    }

    @Override
    public void visitElementAccess(ElementAccess expr) {
        expr.getVector().accept(this);
        expr.getIndex().accept(this);
        this.mv.visitMethodInsn(185, "org/renjin/sexp/Vector", "getElementAsSEXP", "(I)Lorg/renjin/sexp/SEXP;");
    }

    @Override
    public void visitEnvironmentVariable(EnvironmentVariable variable) {
        this.loadEnvironment();
        this.mv.visitLdcInsn((Object)variable.getName().getPrintName());
        this.mv.visitMethodInsn(182, "org/renjin/sexp/Environment", "findVariableOrThrow", "(Ljava/lang/String;)Lorg/renjin/sexp/SEXP;");
        this.loadContext();
        this.mv.visitMethodInsn(185, "org/renjin/sexp/SEXP", "force", "(Lorg/renjin/eval/Context;)Lorg/renjin/sexp/SEXP;");
    }

    @Override
    public void visitIncrement(Increment increment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitLocalVariable(LocalVariable variable) {
        this.mv.visitVarInsn(21, this.getVariableSlot(variable));
    }

    @Override
    public void visitMakeClosure(MakeClosure closure) {
        String closureClass = this.generationContext.addClosure(closure.getFunction());
        this.mv.visitTypeInsn(187, closureClass);
        this.mv.visitInsn(89);
        this.loadEnvironment();
        this.mv.visitMethodInsn(183, closureClass, "<init>", "(Lorg/renjin/sexp/Environment;)V");
    }

    @Override
    public void visitPrimitiveCall(PrimitiveCall call2) {
        this.loadContext();
        this.loadEnvironment();
        this.pushSexp(call2.getSExpression());
        this.maybeStoreElipses(call2);
        this.pushArgNames(call2);
        this.maybeSpliceArgumentNames(call2);
        if (call2.hasElipses()) {
            this.loadContext();
            this.pushPrimitiveArgArray(call2);
            this.spliceArgumentValues(call2);
        } else {
            this.pushPrimitiveArgArray(call2);
        }
        this.mv.visitMethodInsn(184, call2.getWrapperClass().getName().replace('.', '/'), "doApply", "(Lorg/renjin/eval/Context;Lorg/renjin/sexp/Environment;Lorg/renjin/sexp/FunctionCall;[Ljava/lang/String;[Lorg/renjin/sexp/SEXP;)Lorg/renjin/sexp/SEXP;");
    }

    private void spliceArgumentValues(CallExpression call2) {
        this.mv.visitVarInsn(25, this.work1);
        this.pushInt(call2.getElipsesIndex());
        this.mv.visitMethodInsn(184, "org/renjin/compiler/runtime/CompiledRuntime", "spliceArgValues", "(Lorg/renjin/eval/Context;[Lorg/renjin/sexp/SEXP;Lorg/renjin/sexp/PairList;I)[Lorg/renjin/sexp/SEXP;");
    }

    private void maybeStoreElipses(CallExpression call2) {
        if (call2.hasElipses()) {
            this.loadElipses();
            this.mv.visitVarInsn(58, this.work1);
        }
    }

    private void loadElipses() {
        this.loadEnvironment();
        this.mv.visitFieldInsn(178, "org/renjin/sexp/Symbols", "ELLIPSES", "Lorg/renjin/sexp/Symbol;");
        this.mv.visitMethodInsn(182, "org/renjin/sexp/Environment", "getVariable", "(Lorg/renjin/sexp/Symbol;)Lorg/renjin/sexp/SEXP;");
        this.mv.visitTypeInsn(192, "org/renjin/sexp/PairList");
    }

    private void pushPrimitiveArgArray(PrimitiveCall call2) {
        this.pushInt(call2.getArguments().size());
        this.mv.visitTypeInsn(189, "org/renjin/sexp/SEXP");
        for (int i = 0; i != call2.getArguments().size(); ++i) {
            if (call2.getArguments().get(i) == Elipses.INSTANCE) continue;
            this.mv.visitInsn(89);
            this.pushInt(i);
            call2.getArguments().get(i).accept(this);
            this.mv.visitInsn(83);
        }
    }

    private void pushInt(int i) {
        ByteCodeUtil.pushInt(this.mv, i);
    }

    @Override
    public void visitLength(Length length2) {
        length2.getVector().accept(this);
        this.mv.visitMethodInsn(185, "org/renjin/sexp/SEXP", "length", "()I");
    }

    @Override
    public void visitTemp(Temp temp) {
        this.mv.visitVarInsn(25, this.getVariableSlot(temp));
    }

    @Override
    public void visitCmpGE(CmpGE cmp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitSsaVariable(SsaVariable variable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitPhiFunction(PhiFunction phiFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitExprStatement(ExprStatement statement) {
        statement.getRHS().accept(this);
        this.mv.visitInsn(87);
    }

    @Override
    public void visitGoto(GotoStatement statement) {
        this.mv.visitJumpInsn(167, this.getAsmLabel(statement.getTarget()));
    }

    @Override
    public void visitIf(IfStatement stmt) {
        if (stmt.getCondition() instanceof CmpGE) {
            CmpGE cmp = (CmpGE)stmt.getCondition();
            this.mv.visitVarInsn(21, this.getVariableSlot((LValue)cmp.getOp1()));
            this.mv.visitVarInsn(21, this.getVariableSlot((LValue)cmp.getOp2()));
            this.mv.visitJumpInsn(161, this.getAsmLabel(stmt.getFalseTarget()));
        } else {
            stmt.getCondition().accept(this);
            this.mv.visitMethodInsn(184, "org/renjin/compiler/runtime/CompiledRuntime", "evaluateCondition", "(Lorg/renjin/sexp/SEXP;)Z");
            this.mv.visitJumpInsn(153, this.getAsmLabel(stmt.getFalseTarget()));
        }
        this.mv.visitJumpInsn(167, this.getAsmLabel(stmt.getTrueTarget()));
    }

    private Label getAsmLabel(IRLabel label) {
        Label asmLabel = this.labels.get(label);
        if (asmLabel == null) {
            asmLabel = new Label();
            this.labels.put(label, asmLabel);
        }
        return asmLabel;
    }

    private int getVariableSlot(LValue lvalue) {
        Integer index = this.variableSlots.get(lvalue);
        if (index == null) {
            index = this.variableSlots.size();
            this.variableSlots.put(lvalue, index);
        }
        return index + this.localVariablesStart;
    }

    @Override
    public void visitReturn(ReturnStatement returnStatement) {
        returnStatement.getValue().accept(this);
        this.mv.visitInsn(176);
    }

    @Override
    public void visitPromise(IRThunk promise) {
    }
}

