/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline.accessor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.renjin.compiler.pipeline.ComputeMethod;
import org.renjin.compiler.pipeline.DeferredNode;
import org.renjin.compiler.pipeline.accessor.Accessor;
import org.renjin.compiler.pipeline.accessor.Accessors;
import org.renjin.compiler.pipeline.accessor.InputGraph;
import org.renjin.sexp.Vector;

public class BinaryVectorOpAccessor
extends Accessor {
    private Accessor operandAccessor1;
    private Accessor operandAccessor2;
    private int lengthLocal1;
    private int lengthLocal2;
    private int lengthLocal;
    private Method applyMethod;

    public BinaryVectorOpAccessor(DeferredNode node, InputGraph inputGraph) {
        this.operandAccessor1 = Accessors.create(node.getOperands().get(0), inputGraph);
        this.operandAccessor2 = Accessors.create(node.getOperands().get(1), inputGraph);
        this.applyMethod = BinaryVectorOpAccessor.findStaticApply(node.getVector());
        assert (this.applyMethod != null);
    }

    public static boolean accept(DeferredNode node) {
        return BinaryVectorOpAccessor.findStaticApply(node.getVector()) != null;
    }

    private static Method findStaticApply(Vector vector2) {
        for (Method method : vector2.getClass().getMethods()) {
            if (!method.getName().equals("compute") || !Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 2) continue;
            return method;
        }
        return null;
    }

    @Override
    public void init(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        this.operandAccessor1.init(method);
        this.operandAccessor2.init(method);
        this.lengthLocal1 = method.reserveLocal(1);
        this.lengthLocal2 = method.reserveLocal(1);
        this.lengthLocal = method.reserveLocal(1);
        this.operandAccessor1.pushLength(method);
        mv.visitInsn(89);
        mv.visitVarInsn(54, this.lengthLocal1);
        this.operandAccessor2.pushLength(method);
        mv.visitInsn(89);
        mv.visitVarInsn(54, this.lengthLocal2);
        method.getVisitor().visitMethodInsn(184, "java/lang/Math", "max", "(II)I");
        mv.visitVarInsn(54, this.lengthLocal);
    }

    @Override
    public void pushLength(ComputeMethod method) {
        method.getVisitor().visitVarInsn(21, this.lengthLocal);
    }

    @Override
    public void pushDouble(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        mv.visitInsn(89);
        mv.visitVarInsn(21, this.lengthLocal1);
        mv.visitInsn(112);
        this.operandAccessor1.pushDouble(method);
        mv.visitInsn(93);
        mv.visitInsn(88);
        mv.visitVarInsn(21, this.lengthLocal2);
        mv.visitInsn(112);
        this.operandAccessor2.pushDouble(method);
        mv.visitMethodInsn(184, Type.getInternalName(this.applyMethod.getDeclaringClass()), this.applyMethod.getName(), Type.getMethodDescriptor((Method)this.applyMethod));
    }
}

