/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.graphics;

import org.renjin.eval.EvalException;
import org.renjin.graphics.Axis;
import org.renjin.graphics.AxisIntervalCalculationStyle;
import org.renjin.graphics.GraphicParameters;
import org.renjin.graphics.geom.Point;
import org.renjin.graphics.geom.Rectangle;
import org.renjin.sexp.DoubleVector;

public class UserWindow {
    private static final int EPS_FAC_1 = 16;
    private static final int EPS_FAC_2 = 100;
    private Rectangle coordinates;
    private Rectangle logCoordinates;
    private boolean xLog;
    private boolean yLog;

    public UserWindow() {
        this.setUserCoordinates(new Rectangle(0.0, 1.0, 0.0, 1.0));
    }

    public Rectangle getUserCoordinates() {
        return this.coordinates;
    }

    public void setUserCoordinates(Rectangle coords) {
        double y2;
        double y1;
        double logY2;
        double logY1;
        double x2;
        double x1;
        double logX2;
        double logX1;
        if (this.xLog) {
            logX1 = coords.getX1();
            logX2 = coords.getX2();
            x1 = Math.pow(logX1, 10.0);
            x2 = Math.pow(logX2, 10.0);
        } else {
            x1 = coords.getX1();
            x2 = coords.getX2();
            logX1 = Math.log10(x1);
            logX2 = Math.log10(x2);
        }
        if (this.yLog) {
            logY1 = coords.getY1();
            logY2 = coords.getY2();
            y1 = Math.pow(logY1, 10.0);
            y2 = Math.pow(logY2, 10.0);
        } else {
            y1 = coords.getY1();
            y2 = coords.getY2();
            logY1 = Math.log10(y1);
            logY2 = Math.log10(y2);
        }
        this.coordinates = new Rectangle(x1, x2, y1, y2);
        this.logCoordinates = new Rectangle(logX1, logX2, logY1, logY2);
    }

    public Rectangle normalize(Rectangle rect2) {
        return new Rectangle((rect2.getX1() - this.coordinates.getX1()) / this.coordinates.getWidth(), (rect2.getX2() - this.coordinates.getX1()) / this.coordinates.getWidth(), (rect2.getY1() - this.coordinates.getY1()) / this.coordinates.getHeight(), (rect2.getY2() - this.coordinates.getY1()) / this.coordinates.getHeight());
    }

    public Point normalize(Point point) {
        return new Point((point.getX() - this.coordinates.getX1()) / this.coordinates.getWidth(), (point.getY() - this.coordinates.getY1()) / this.coordinates.getHeight());
    }

    public boolean isLog(Axis axis2) {
        switch (axis2) {
            case X: {
                return this.xLog;
            }
            case Y: {
                return this.yLog;
            }
        }
        throw new IllegalArgumentException("" + (Object)((Object)axis2));
    }

    public void setLimits(Rectangle limits, GraphicParameters parameters) {
        this.computeScale(Axis.X, limits.getX1(), limits.getX2(), parameters);
        this.computeScale(Axis.Y, limits.getY1(), limits.getY2(), parameters);
    }

    private void computeScale(Axis axis2, double min2, double max2, GraphicParameters parameters) {
        double temp;
        double min_o = 0.0;
        double max_o = 0.0;
        double tmp2 = 0.0;
        int n = parameters.getAxisStyle(axis2).getTickmarkCount();
        AxisIntervalCalculationStyle style = parameters.getAxisStyle(axis2).getCalculationStyle();
        if (this.isLog(axis2)) {
            min_o = min2;
            max_o = max2;
            min2 = Math.log10(min2);
            max2 = Math.log10(max2);
        }
        if (!DoubleVector.isFinite(min2) || !DoubleVector.isFinite(max2)) {
            if (!DoubleVector.isFinite(min2)) {
                min2 = -8.089619106880421E307;
            }
            if (!DoubleVector.isFinite(max2)) {
                max2 = 8.089619106880421E307;
            }
        }
        if ((temp = Math.max(Math.abs(max2), Math.abs(min2))) == 0.0) {
            min2 = -1.0;
            max2 = 1.0;
        } else if (Math.abs(max2 - min2) < temp * 16.0 * 2.220446E-16) {
            min2 -= (temp *= min2 == max2 ? 0.4 : 0.01);
            max2 += temp;
        }
        switch (style) {
            case REGULAR: {
                temp = 0.04 * (max2 - min2);
                min2 -= temp;
                max2 += temp;
                break;
            }
            case INTERNAL: {
                break;
            }
            default: {
                throw new EvalException("axis style \"%c\" unimplemented", style.name());
            }
        }
        if (this.isLog(axis2)) {
            temp = Math.pow(10.0, min2);
            if (temp == 0.0) {
                temp = Math.min(min_o, Double.MIN_VALUE);
                min2 = Math.log10(temp);
            }
            if ((tmp2 = Math.pow(10.0, max2)) == Double.POSITIVE_INFINITY) {
                tmp2 = Math.max(max_o, 1.7797162035136925E308);
                max2 = Math.log10(tmp2);
            }
        }
        if (this.isLog(axis2)) {
            this.updateLimits(axis2, temp, tmp2);
            this.updateLogLimits(axis2, min2, max2);
        } else {
            this.updateLimits(axis2, min2, max2);
        }
    }

    private void updateLimits(Axis axis2, double min2, double max2) {
        switch (axis2) {
            case X: {
                this.coordinates = this.coordinates.withXLimits(min2, max2);
                break;
            }
            case Y: {
                this.coordinates = this.coordinates.withYLimits(min2, max2);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void updateLogLimits(Axis axis2, double min2, double max2) {
        switch (axis2) {
            case X: {
                this.logCoordinates = this.logCoordinates.withXLimits(min2, max2);
                break;
            }
            case Y: {
                this.logCoordinates = this.logCoordinates.withYLimits(min2, max2);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

