/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.graphics.internals;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.graphics.Color;
import org.renjin.graphics.GraphicsDevice;
import org.renjin.graphics.LineType;
import org.renjin.graphics.geom.Point;
import org.renjin.graphics.geom.Rectangle;
import org.renjin.graphics.internals.Devices;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class Plot {
    @Internal(value="plot.new")
    public static void do_plot_new(@Current Context context) {
        GraphicsDevice dd = Devices.GEcurrentDevice(context);
        dd.setUserLimits(Rectangle.UNIT_RECT);
    }

    @Internal(value="plot.window")
    public static void plotWindow(@Current Context context, Vector xlim, Vector ylim, Vector log3, Vector asp, @ArgumentList ListVector parameters) {
        GraphicsDevice dd = Devices.GEcurrentDevice(context);
        dd.setUserLimits(Rectangle.from(xlim, ylim));
    }

    @Internal
    public static void rect(@Current Context context, Vector xleft, Vector ybottom, Vector xright, Vector ytop, Vector col2, Vector border, Vector lty, Vector lwd, @ArgumentList ListVector parameters) {
        GraphicsDevice dd = Devices.GEcurrentDevice(context);
        dd.saveParameters();
        int numRects = Plot.maxLength(xleft, ybottom, xright, ytop);
        for (int i = 0; i != numRects; ++i) {
            Color fillColor = Color.fromExp(context, dd, col2, i % col2.length());
            Color borderColor = border == Null.INSTANCE ? Color.TRANSPARENT_WHITE : Color.fromExp(context, dd, border, i % border.length());
            dd.getParameters().setLineType(LineType.valueOf(lty, i % lty.length())).setLineWidth(lwd.getElementAsDouble(i % lwd.length()));
            dd.drawRectangle(new Rectangle(xleft.getElementAsDouble(i % xleft.length()), xright.getElementAsDouble(i % xright.length()), ybottom.getElementAsDouble(i % ybottom.length()), ytop.getElementAsDouble(i % ytop.length())), fillColor, borderColor);
        }
        dd.restoreParameters();
    }

    @Internal
    public static void title(@Current Context context, SEXP main, SEXP sub2, SEXP xlab, SEXP ylab, double line, boolean outer, @ArgumentList ListVector arguments) {
        GraphicsDevice dd = Devices.GEcurrentDevice(context);
        dd.saveParameters();
        double adj = dd.getParameters().getTextJustification();
        if (main != Null.INSTANCE) {
            double adjy;
            double vpos;
            dd.getParameters().getMainTitleStyle();
            if (outer) {
                throw new EvalException("main title in outer margins not yet implemented", new Object[0]);
            }
            if (DoubleVector.isFinite(line)) {
                vpos = line;
                adjy = 0.0;
            } else {
                vpos = 0.5 * dd.getInnerMargins().getTop();
                adjy = 0.5;
            }
            double hpos = 0.0;
            double where = 0.0;
            if (!(main instanceof ExpressionVector)) {
                int n = main.length();
                double offset = 0.5 * (double)(n - 1) + vpos;
                for (int i = 0; i < n; ++i) {
                    String text = ((Vector)main).getElementAsString(i);
                    if (StringVector.isNA(text)) continue;
                    dd.text(new Point(hpos, offset - (double)i), where, text, new Point(adj, adjy), 0.0);
                }
            }
        }
        dd.restoreParameters();
    }

    @Internal
    public static void axis(SEXP side, SEXP at2, SEXP labels, SEXP tick, SEXP line, SEXP pos, SEXP outer, SEXP font, SEXP lty, SEXP lwd, SEXP lwdTicks, SEXP col2, SEXP colTicks, SEXP hadj, SEXP padj, @ArgumentList ListVector arguments) {
    }

    private static int maxLength(Vector ... vectors) {
        int n = 0;
        for (Vector vector2 : vectors) {
            if (vector2.length() <= n) continue;
            n = vector2.length();
        }
        return n;
    }
}

