/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.matrix;

import org.renjin.parser.NumericLiterals;
import org.renjin.primitives.matrix.AbstractMatrixBuilder;
import org.renjin.primitives.matrix.MatrixBuilder;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.StringVector;

public class StringMatrixBuilder
extends AbstractMatrixBuilder<StringVector.Builder, StringVector>
implements MatrixBuilder {
    public StringMatrixBuilder(int nrows, int ncols) {
        super(StringVector.VECTOR_TYPE, nrows, ncols);
    }

    @Override
    public void setValue(int row2, int col2, double value) {
        if (DoubleVector.isNA(value)) {
            this.setValue(row2, col2, StringVector.NA);
        } else {
            this.setValue(row2, col2, NumericLiterals.toString(value));
        }
    }

    @Override
    public void setValue(int row2, int col2, int value) {
        if (IntVector.isNA(value)) {
            this.setValue(row2, col2, StringVector.NA);
        } else {
            this.setValue(row2, col2, NumericLiterals.format(value));
        }
    }

    public void setValue(int row2, int col2, String value) {
        ((StringVector.Builder)this.builder).set(this.computeIndex(row2, col2), value);
    }
}

