/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.sequence;

import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class DoubleSequence
extends DoubleVector {
    private double from;
    private double by;
    private int length;

    public DoubleSequence(AttributeMap attributes2, double from, double by, int length2) {
        super(attributes2);
        this.from = from;
        this.by = by;
        this.length = length2;
    }

    public DoubleSequence(double from, double by, int length2) {
        this.from = from;
        this.by = by;
        this.length = length2;
    }

    @Override
    public double getElementAsDouble(int index) {
        return this.from + (double)index * this.by;
    }

    @Override
    public boolean isConstantAccessTime() {
        return false;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new DoubleSequence(attributes2, this.from, this.by, this.length);
    }

    public static Vector fromTo(double n1, double n2) {
        if (n1 == n2) {
            return new DoubleArrayVector(n1);
        }
        if (n1 <= n2) {
            return new DoubleSequence(n1, 1.0, (int)Math.ceil(n2 - n1));
        }
        return new DoubleSequence(n1, -1.0, (int)(Math.floor(n1 - n2) + 1.0));
    }
}

