/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import java.util.BitSet;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.SEXP;

public class LogicalBitSetVector
extends LogicalVector {
    private final BitSet bitSet;
    private final int length;

    public LogicalBitSetVector(BitSet bitSet, int length2, AttributeMap attributes2) {
        super(attributes2);
        this.length = length2;
        this.bitSet = (BitSet)bitSet.clone();
    }

    public LogicalBitSetVector(BitSet bitSet, int length2) {
        this.bitSet = (BitSet)bitSet.clone();
        this.length = length2;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int getElementAsRawLogical(int index) {
        return this.bitSet.get(index) ? 1 : 0;
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    @Override
    public Logical getElementAsLogical(int index) {
        return this.bitSet.get(index) ? Logical.TRUE : Logical.FALSE;
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new LogicalBitSetVector(this.bitSet, this.length, attributes2);
    }
}

