/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.apache.commons.math.special.Gamma;
import org.renjin.eval.Session;
import org.renjin.invoke.annotations.DataParallel;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.Recycle;
import org.renjin.sexp.DoubleVector;
import org.renjin.stats.internals.Distributions;
import org.renjin.stats.internals.distributions.Normal;
import org.renjin.stats.internals.distributions.Poisson;
import org.renjin.stats.internals.distributions.SignRank;
import org.renjin.stats.internals.distributions.Utils;

public class Beta {
    public static double expmax = 127.0 * Math.log(2.0);
    static double beta;
    static double gamma;
    static double delta;
    static double k1;
    static double k2;
    static double olda;
    static double oldb;

    @Internal
    @DataParallel
    public static double rbeta(Session context, double aa, double bb) {
        double t2;
        double u2;
        double u1;
        double z;
        double w;
        double v;
        double r;
        double s;
        boolean qsame;
        if (aa <= 0.0 || bb <= 0.0 || Double.isInfinite(aa) && Double.isInfinite(bb)) {
            return Double.NaN;
        }
        if (Double.isInfinite(aa)) {
            return 1.0;
        }
        if (Double.isInfinite(bb)) {
            return 0.0;
        }
        boolean bl = qsame = olda == aa && oldb == bb;
        if (!qsame) {
            olda = aa;
            oldb = bb;
        }
        double a = Math.min(aa, bb);
        double b = Math.max(aa, bb);
        double alpha = a + b;
        if (a <= 1.0) {
            double w2;
            if (!qsame) {
                beta = 1.0 / a;
                delta = 1.0 + b - a;
                k1 = delta * (0.0138889 + 0.0416667 * a) / (b * beta - 0.777778);
                k2 = 0.25 + (0.5 + 0.25 / delta) * a;
            }
            while (true) {
                double v2;
                double z2;
                double u12 = context.rng.unif_rand();
                double u22 = context.rng.unif_rand();
                if (u12 < 0.5) {
                    double y = u12 * u22;
                    z2 = u12 * y;
                    if (0.25 * u22 + z2 - y >= k1) {
                        continue;
                    }
                } else {
                    z2 = u12 * u12 * u22;
                    if (z2 <= 0.25) {
                        v2 = beta * Math.log(u12 / (1.0 - u12));
                        if (v2 <= expmax) {
                            w2 = b * Math.exp(v2);
                            if (!Double.isInfinite(w2)) break;
                            w2 = Double.MAX_VALUE;
                            break;
                        }
                        w2 = Double.MAX_VALUE;
                        break;
                    }
                    if (z2 >= k2) continue;
                }
                if ((v2 = beta * Math.log(u12 / (1.0 - u12))) <= expmax) {
                    w2 = b * Math.exp(v2);
                    if (Double.isInfinite(w2)) {
                        w2 = Double.MAX_VALUE;
                    }
                } else {
                    w2 = Double.MAX_VALUE;
                }
                if (alpha * (Math.log(alpha / (a + w2)) + v2) - 1.3862944 >= Math.log(z2)) break;
            }
            return aa == a ? a / (a + w2) : w2 / (a + w2);
        }
        if (!qsame) {
            beta = Math.sqrt((alpha - 2.0) / (2.0 * a * b - alpha));
            gamma = a + 1.0 / beta;
        }
        do {
            u1 = context.rng.unif_rand();
            u2 = context.rng.unif_rand();
            v = beta * Math.log(u1 / (1.0 - u1));
            if (v <= expmax) {
                w = a * Math.exp(v);
                if (!Double.isInfinite(w)) continue;
                w = Double.MAX_VALUE;
                continue;
            }
            w = Double.MAX_VALUE;
        } while (!((s = a + (r = gamma * v - 1.3862944) - w) + 2.609438 >= 5.0 * (z = u1 * u1 * u2)) && !(s > (t2 = Math.log(z))) && r + alpha * Math.log(alpha / (b + w)) < t2);
        return aa != a ? b / (b + w) : w / (b + w);
    }

    @Internal
    public static double dnbeta(double x, double a, double b, double ncp, boolean give_log) {
        double q;
        double eps = 1.0E-15;
        if (DoubleVector.isNaN(x) || DoubleVector.isNaN(a) || DoubleVector.isNaN(b) || DoubleVector.isNaN(ncp)) {
            return x + a + b + ncp;
        }
        if (ncp < 0.0 || a <= 0.0 || b <= 0.0) {
            return Double.NaN;
        }
        if (!(DoubleVector.isFinite(a) && DoubleVector.isFinite(b) && DoubleVector.isFinite(ncp))) {
            return Double.NaN;
        }
        if (x < 0.0 || x > 1.0) {
            return SignRank.R_D__0(true, give_log);
        }
        if (ncp == 0.0) {
            return Distributions.dbeta(x, a, b, give_log);
        }
        double ncp2 = 0.5 * ncp;
        double dx2 = ncp2 * x;
        double d = (dx2 - a - 1.0) / 2.0;
        double D = d * d + dx2 * (a + b) - a;
        int kMax = D <= 0.0 ? 0 : ((D = Math.ceil(d + Math.sqrt(D))) > 0.0 ? (int)D : 0);
        double term = Distributions.dbeta(x, a + (double)kMax, b, true);
        double p_k = Poisson.dpois_raw(kMax, ncp2, true);
        if (x == 0.0 || !DoubleVector.isFinite(term) || !DoubleVector.isFinite(p_k)) {
            return SignRank.R_D_exp(p_k + term, true, give_log);
        }
        p_k += term;
        term = 1.0;
        double sum2 = 1.0;
        double k = kMax;
        while (k > 0.0 && term > sum2 * 1.0E-15) {
            q = ((k -= 1.0) + 1.0) * (k + a) / (k + a + b) / dx2;
            sum2 += (term *= q);
        }
        term = 1.0;
        k = kMax;
        do {
            q = dx2 * (k + a + b) / (k + a) / (k + 1.0);
            k += 1.0;
        } while ((term *= q) > (sum2 += term) * 1.0E-15);
        return SignRank.R_D_exp(p_k + Math.log(sum2), true, give_log);
    }

    public static double pnbeta_raw(double x, double o_x, double a, double b, double ncp) {
        double errbd;
        double ax;
        double errmax = 1.0E-9;
        int itrmax = 10000;
        double[] temp = new double[1];
        double[] tmp_c = new double[1];
        int[] ierr = new int[1];
        if (ncp < 0.0 || a <= 0.0 || b <= 0.0) {
            return Double.NaN;
        }
        if (x < 0.0 || o_x > 1.0 || x == 0.0 && o_x == 1.0) {
            return 0.0;
        }
        if (x > 1.0 || o_x < 0.0 || x == 1.0 && o_x == 0.0) {
            return 1.0;
        }
        double c2 = ncp / 2.0;
        double x0 = Math.floor(Math.max(c2 - 7.0 * Math.sqrt(c2), 0.0));
        double a0 = a + x0;
        double lbeta2 = Gamma.logGamma((double)a0) + Gamma.logGamma((double)b) - Gamma.logGamma((double)(a0 + b));
        Utils.bratio(a0, b, x, o_x, temp, tmp_c, ierr, false);
        double gx = Math.exp(a0 * Math.log(x) + b * (x < 0.5 ? Math.log1p(-x) : Math.log(o_x)) - lbeta2 - Math.log(a0));
        double q = a0 > a ? Math.exp(-c2 + x0 * Math.log(c2) - Gamma.logGamma((double)(x0 + 1.0))) : Math.exp(-c2);
        double sumq = 1.0 - q;
        double ans = ax = q * temp[0];
        int j = (int)x0;
        do {
            temp[0] = temp[0] - gx;
            ax = temp[0] * q;
            ans += ax;
        } while ((errbd = (temp[0] - (gx *= x * (a + b + (double)(++j) - 1.0) / (a + (double)j))) * (sumq -= (q *= c2 / (double)j))) > 1.0E-9 && (double)j < 10000.0 + x0);
        if (errbd > 1.0E-9) {
            // empty if block
        }
        if ((double)j >= 10000.0 + x0) {
            // empty if block
        }
        return ans;
    }

    public static double pnbeta2(double x, double o_x, double a, double b, double ncp, boolean lower_tail, boolean log_p) {
        double ans = Beta.pnbeta_raw(x, o_x, a, b, ncp);
        if (lower_tail) {
            return log_p ? Math.log(ans) : ans;
        }
        if (ans > 0.9999999999) {
            return Double.NaN;
        }
        ans = Math.min(ans, 1.0);
        return log_p ? Math.log1p(-ans) : 1.0 - ans;
    }

    @Internal
    @DataParallel
    public static double pnbeta(double x, double a, double b, double ncp, boolean lower_tail, boolean log_p) {
        if (DoubleVector.isNaN(x) || DoubleVector.isNaN(a) || DoubleVector.isNaN(b) || DoubleVector.isNaN(ncp)) {
            return x + a + b + ncp;
        }
        if (x <= 0.0) {
            return SignRank.R_DT_0(lower_tail, log_p);
        }
        if (x >= 1.0) {
            return SignRank.R_DT_1(lower_tail, log_p);
        }
        return Beta.pnbeta2(x, 1.0 - x, a, b, ncp, lower_tail, log_p);
    }

    @Internal
    @DataParallel
    public static double qnbeta(double p, double a, double b, double ncp, @Recycle(value=false) boolean lower_tail, @Recycle(value=false) boolean log_p) {
        double nx;
        double lx;
        double accu = 1.0E-15;
        double Eps = 1.0E-14;
        if (DoubleVector.isNaN(p) || DoubleVector.isNaN(a) || DoubleVector.isNaN(b) || DoubleVector.isNaN(ncp)) {
            return p + a + b + ncp;
        }
        if (!DoubleVector.isFinite(a)) {
            return Double.NaN;
        }
        if (ncp < 0.0 || a <= 0.0 || b <= 0.0) {
            return Double.NaN;
        }
        if (log_p && p > 0.0 || !log_p && (p < 0.0 || p > 1.0)) {
            return Double.NaN;
        }
        if (p == SignRank.R_DT_0(lower_tail, log_p)) {
            return 0.0;
        }
        if (p == SignRank.R_DT_1(lower_tail, log_p)) {
            return 1.0;
        }
        if ((p = Normal.R_DT_qIv(p, log_p ? 1.0 : 0.0, lower_tail ? 1.0 : 0.0)) > 1.0 - SignRank.DBL_EPSILON) {
            return 1.0;
        }
        double pp = Math.min(1.0 - SignRank.DBL_EPSILON, p * 1.00000000000001);
        double ux = 0.5;
        while (ux < 1.0 - SignRank.DBL_EPSILON && Beta.pnbeta(ux, a, b, ncp, true, false) < pp) {
            ux = 0.5 * (1.0 + ux);
        }
        pp = p * 0.99999999999999;
        for (lx = 0.5; lx > Double.MIN_VALUE && Beta.pnbeta(lx, a, b, ncp, true, false) > pp; lx *= 0.5) {
        }
        do {
            if (Beta.pnbeta(nx = 0.5 * (lx + ux), a, b, ncp, true, false) > p) {
                ux = nx;
                continue;
            }
            lx = nx;
        } while ((ux - lx) / nx > 1.0E-15);
        return 0.5 * (ux + lx);
    }

    static {
        olda = -1.0;
        oldb = -1.0;
    }
}

