/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.apache.commons.math.special.Gamma;
import org.renjin.eval.Session;
import org.renjin.sexp.DoubleVector;
import org.renjin.stats.internals.Distributions;
import org.renjin.stats.internals.distributions.ChiSquare;
import org.renjin.stats.internals.distributions.Normal;
import org.renjin.stats.internals.distributions.SignRank;

public class StudentsT {
    public static double rt(Session context, double df2) {
        if (Double.isNaN(df2) || df2 <= 0.0) {
            return Double.NaN;
        }
        return Normal.norm_rand(context) / Math.sqrt(ChiSquare.rchisq(context, df2) / df2);
    }

    public static double pnt(double t2, double df2, double ncp, boolean lower_tail, boolean log_p) {
        double tnc;
        double del;
        double tt;
        boolean negdel;
        int itrmax = 1000;
        double errmax = 1.0E-12;
        if (df2 <= 0.0) {
            return Double.NaN;
        }
        if (ncp == 0.0) {
            return Distributions.pt(t2, df2, lower_tail, log_p);
        }
        if (!DoubleVector.isFinite(t2)) {
            return t2 < 0.0 ? SignRank.R_DT_0(lower_tail, log_p) : SignRank.R_DT_1(lower_tail, log_p);
        }
        if (t2 >= 0.0) {
            negdel = false;
            tt = t2;
            del = ncp;
        } else {
            if (!(!(ncp > 40.0) || log_p && lower_tail)) {
                return SignRank.R_DT_0(lower_tail, log_p);
            }
            negdel = true;
            tt = -t2;
            del = -ncp;
        }
        if (df2 > 400000.0 || del * del > 2.0 * Math.log(2.0) * 1022.0) {
            double s = 1.0 / (4.0 * df2);
            return Distributions.pnorm(tt * (1.0 - s), del, Math.sqrt(1.0 + tt * tt * 2.0 * s), lower_tail != negdel, log_p);
        }
        double x = t2 * t2;
        double rxb = df2 / (x + df2);
        if ((x /= x + df2) > 0.0) {
            double lambda = del * del;
            double p = 0.5 * Math.exp(-0.5 * lambda);
            if (p == 0.0) {
                return SignRank.R_DT_0(lower_tail, log_p);
            }
            double q = Math.sqrt(0.6366197723675814) * p * del;
            double s = 0.5 - p;
            if (s < 1.0E-7) {
                s = -0.5 * Math.expm1(-0.5 * lambda);
            }
            double a = 0.5;
            double b = 0.5 * df2;
            rxb = Math.pow(rxb, b);
            double albeta = Math.log(Math.sqrt(Math.PI)) + Gamma.logGamma((double)b) - Gamma.logGamma((double)(0.5 + b));
            double xodd = Distributions.pbeta(x, a, b, true, false);
            double godd = 2.0 * rxb * Math.exp(a * Math.log(x) - albeta);
            tnc = b * x;
            double xeven = tnc < SignRank.DBL_EPSILON ? tnc : 1.0 - rxb;
            double geven = tnc * rxb;
            tnc = p * xodd + q * xeven;
            for (int it = 1; it <= 1000; ++it) {
                tnc += (p *= lambda / (double)(2 * it)) * (xodd -= (godd *= x * ((a += 1.0) + b - 1.0) / a)) + (q *= lambda / (double)(2 * it + 1)) * (xeven -= (geven *= x * (a + b - 0.5) / (a + 0.5)));
                if ((s -= p) < -1.0E-10) {
                    boolean bl = lower_tail = lower_tail != negdel;
                    if (!((tnc += Distributions.pnorm(-del, 0.0, 1.0, true, false)) > 0.9999999999) || lower_tail) {
                        // empty if block
                    }
                    return SignRank.R_DT_val(Math.min(tnc, 1.0), lower_tail, log_p);
                }
                if (s <= 0.0 && it > 1) {
                    boolean bl = lower_tail = lower_tail != negdel;
                    if (!((tnc += Distributions.pnorm(-del, 0.0, 1.0, true, false)) > 0.9999999999) || lower_tail) {
                        // empty if block
                    }
                    return SignRank.R_DT_val(Math.min(tnc, 1.0), lower_tail, log_p);
                }
                double errbd = 2.0 * s * (xodd - godd);
                if (!(Math.abs(errbd) < 1.0E-12)) continue;
                boolean bl = lower_tail = lower_tail != negdel;
                if (!((tnc += Distributions.pnorm(-del, 0.0, 1.0, true, false)) > 0.9999999999) || lower_tail) {
                    // empty if block
                }
                return SignRank.R_DT_val(Math.min(tnc, 1.0), lower_tail, log_p);
            }
        } else {
            tnc = 0.0;
        }
        boolean bl = lower_tail = lower_tail != negdel;
        if (!((tnc += Distributions.pnorm(-del, 0.0, 1.0, true, false)) > 0.9999999999) || lower_tail) {
            // empty if block
        }
        return SignRank.R_DT_val(Math.min(tnc, 1.0), lower_tail, log_p);
    }

    public static double qnt(double p, double df2, double ncp, boolean lower_tail, boolean log_p) {
        double nx;
        double lx;
        double ux;
        double accu = 1.0E-13;
        double Eps = 1.0E-11;
        if (DoubleVector.isNaN(p) || DoubleVector.isNaN(df2) || DoubleVector.isNaN(ncp)) {
            return p + df2 + ncp;
        }
        if (!DoubleVector.isFinite(df2)) {
            return Double.NaN;
        }
        if (df2 <= 0.0) {
            return Double.NaN;
        }
        if (ncp == 0.0 && df2 >= 1.0) {
            return Distributions.qt(p, df2, lower_tail, log_p);
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (p == 1.0) {
                return lower_tail ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
        }
        if ((p = Normal.R_DT_qIv(p, log_p ? 1.0 : 0.0, lower_tail ? 1.0 : 0.0)) > 1.0 - SignRank.DBL_EPSILON) {
            return Double.POSITIVE_INFINITY;
        }
        double pp = Math.min(1.0 - SignRank.DBL_EPSILON, p * 1.00000000001);
        for (ux = Math.max(1.0, ncp); ux < Double.MAX_VALUE && StudentsT.pnt(ux, df2, ncp, true, false) < pp; ux *= 2.0) {
        }
        pp = p * 0.99999999999;
        for (lx = Math.min(-1.0, -ncp); lx > -1.7976931348623157E308 && StudentsT.pnt(lx, df2, ncp, true, false) > pp; lx *= 2.0) {
        }
        do {
            if (StudentsT.pnt(nx = 0.5 * (lx + ux), df2, ncp, true, false) > p) {
                ux = nx;
                continue;
            }
            lx = nx;
        } while ((ux - lx) / Math.abs(nx) > 1.0E-13);
        return 0.5 * (lx + ux);
    }

    public static double dnt(double x, double df2, double ncp, boolean give_log) {
        if (DoubleVector.isNaN(x) || DoubleVector.isNaN(df2)) {
            return x + df2;
        }
        if (df2 <= 0.0) {
            return Double.NaN;
        }
        if (ncp == 0.0) {
            return Distributions.dt(x, df2, give_log);
        }
        if (!DoubleVector.isFinite(x)) {
            return SignRank.R_D__0(true, give_log);
        }
        if (!DoubleVector.isFinite(df2) || df2 > 1.0E8) {
            return Distributions.dnorm(x, ncp, 1.0, give_log);
        }
        double u = Math.abs(x) > Math.sqrt(df2 * SignRank.DBL_EPSILON) ? Math.log(df2) - Math.log(Math.abs(x)) + Math.log(Math.abs(Distributions.pnt(x * Math.sqrt((df2 + 2.0) / df2), df2 + 2.0, ncp, true, false) - Distributions.pnt(x, df2, ncp, true, false))) : Gamma.logGamma((double)((df2 + 1.0) / 2.0)) - Gamma.logGamma((double)(df2 / 2.0)) - 0.5 * (Math.log(Math.PI) + Math.log(df2) + ncp * ncp);
        return give_log ? u : Math.exp(u);
    }
}

