/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.models;

import java.util.List;
import org.renjin.stats.internals.models.ModelMatrixColumn;

public class InteractionMatrixColumn
implements ModelMatrixColumn {
    private final ModelMatrixColumn[] variables;
    private final String name;

    public InteractionMatrixColumn(ModelMatrixColumn[] variables) {
        this.variables = variables;
        StringBuilder name = new StringBuilder();
        for (ModelMatrixColumn variable : variables) {
            if (name.length() > 0) {
                name.append(":");
            }
            name.append(variable.getName());
        }
        this.name = name.toString();
    }

    public InteractionMatrixColumn(List<ModelMatrixColumn> parts) {
        this(parts.toArray(new ModelMatrixColumn[parts.size()]));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getValue(int observationIndex) {
        double value = 1.0;
        for (int i = 0; i != this.variables.length; ++i) {
            value *= this.variables[i].getValue(observationIndex);
        }
        return value;
    }
}

