/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.optimize;

class Blas_f77 {
    Blas_f77() {
    }

    public static int isamax_f77(int n, double[] x, int incx) {
        int isamax;
        if (n < 1) {
            isamax = 0;
        } else if (n == 1) {
            isamax = 1;
        } else if (incx == 1) {
            isamax = 1;
            double xmax = Math.abs(x[1]);
            for (int i = 2; i <= n; ++i) {
                if (!(Math.abs(x[i]) > xmax)) continue;
                isamax = i;
                xmax = Math.abs(x[i]);
            }
        } else {
            isamax = 1;
            int ix = 1;
            double xmax = Math.abs(x[ix]);
            ix += incx;
            for (int i = 2; i <= n; ++i) {
                if (Math.abs(x[ix]) > xmax) {
                    isamax = i;
                    xmax = Math.abs(x[ix]);
                }
                ix += incx;
            }
        }
        return isamax;
    }

    public static int colisamax_f77(int n, double[][] x, int incx, int begin, int j) {
        int isamax;
        if (n < 1) {
            isamax = 0;
        } else if (n == 1) {
            isamax = 1;
        } else if (incx == 1) {
            isamax = 1;
            int ix = begin;
            double xmax = Math.abs(x[ix][j]);
            ++ix;
            for (int i = 2; i <= n; ++i) {
                if (Math.abs(x[ix][j]) > xmax) {
                    isamax = i;
                    xmax = Math.abs(x[ix][j]);
                }
                ++ix;
            }
        } else {
            isamax = 1;
            int ix = begin;
            double xmax = Math.abs(x[ix][j]);
            ix += incx;
            for (int i = 2; i <= n; ++i) {
                if (Math.abs(x[ix][j]) > xmax) {
                    isamax = i;
                    xmax = Math.abs(x[ix][j]);
                }
                ix += incx;
            }
        }
        return isamax;
    }

    public static void daxpy_f77(int n, double da, double[] dx, int incx, double[] dy, int incy) {
        if (n <= 0) {
            return;
        }
        if (da == 0.0) {
            return;
        }
        if (incx == 1 && incy == 1) {
            int i;
            int m = n % 4;
            for (i = 1; i <= m; ++i) {
                int n2 = i;
                dy[n2] = dy[n2] + da * dx[i];
            }
            for (i = m + 1; i <= n; i += 4) {
                int n3 = i;
                dy[n3] = dy[n3] + da * dx[i];
                int n4 = i + 1;
                dy[n4] = dy[n4] + da * dx[i + 1];
                int n5 = i + 2;
                dy[n5] = dy[n5] + da * dx[i + 2];
                int n6 = i + 3;
                dy[n6] = dy[n6] + da * dx[i + 3];
            }
            return;
        }
        int ix = 1;
        int iy = 1;
        if (incx < 0) {
            ix = (-n + 1) * incx + 1;
        }
        if (incy < 0) {
            iy = (-n + 1) * incy + 1;
        }
        for (int i = 1; i <= n; ++i) {
            int n7 = iy;
            dy[n7] = dy[n7] + da * dx[ix];
            ix += incx;
            iy += incy;
        }
    }

    public static double ddot_f77(int n, double[] dx, int incx, double[] dy, int incy) {
        double ddot = 0.0;
        if (n <= 0) {
            return ddot;
        }
        if (incx == 1 && incy == 1) {
            int i;
            int m = n % 5;
            for (i = 1; i <= m; ++i) {
                ddot += dx[i] * dy[i];
            }
            for (i = m + 1; i <= n; i += 5) {
                ddot += dx[i] * dy[i] + dx[i + 1] * dy[i + 1] + dx[i + 2] * dy[i + 2] + dx[i + 3] * dy[i + 3] + dx[i + 4] * dy[i + 4];
            }
            return ddot;
        }
        int ix = 1;
        int iy = 1;
        if (incx < 0) {
            ix = (-n + 1) * incx + 1;
        }
        if (incy < 0) {
            iy = (-n + 1) * incy + 1;
        }
        for (int i = 1; i <= n; ++i) {
            ddot += dx[ix] * dy[iy];
            ix += incx;
            iy += incy;
        }
        return ddot;
    }

    public static void dscal_f77(int n, double da, double[] dx, int incx) {
        if (n <= 0 || incx <= 0) {
            return;
        }
        if (incx == 1) {
            int m = n % 5;
            int i = 1;
            while (i <= m) {
                int n2 = i++;
                dx[n2] = dx[n2] * da;
            }
            for (i = m + 1; i <= n; i += 5) {
                int n3 = i;
                dx[n3] = dx[n3] * da;
                int n4 = i + 1;
                dx[n4] = dx[n4] * da;
                int n5 = i + 2;
                dx[n5] = dx[n5] * da;
                int n6 = i + 3;
                dx[n6] = dx[n6] * da;
                int n7 = i + 4;
                dx[n7] = dx[n7] * da;
            }
            return;
        }
        int nincx = n * incx;
        for (int i = 1; i <= nincx; i += incx) {
            int n8 = i;
            dx[n8] = dx[n8] * da;
        }
    }

    public static void dswap_f77(int n, double[] dx, int incx, double[] dy, int incy) {
        if (n <= 0) {
            return;
        }
        if (incx == 1 && incy == 1) {
            double dtemp;
            int i;
            int m = n % 3;
            for (i = 1; i <= m; ++i) {
                dtemp = dx[i];
                dx[i] = dy[i];
                dy[i] = dtemp;
            }
            for (i = m + 1; i <= n; i += 3) {
                dtemp = dx[i];
                dx[i] = dy[i];
                dy[i] = dtemp;
                dtemp = dx[i + 1];
                dx[i + 1] = dy[i + 1];
                dy[i + 1] = dtemp;
                dtemp = dx[i + 2];
                dx[i + 2] = dy[i + 2];
                dy[i + 2] = dtemp;
            }
            return;
        }
        int ix = 1;
        int iy = 1;
        if (incx < 0) {
            ix = (-n + 1) * incx + 1;
        }
        if (incy < 0) {
            iy = (-n + 1) * incy + 1;
        }
        for (int i = 1; i <= n; ++i) {
            double dtemp = dx[ix];
            dx[ix] = dy[iy];
            dy[iy] = dtemp;
            ix += incx;
            iy += incy;
        }
    }

    public static double dnrm2_f77(int n, double[] x, int incx) {
        double norm;
        if (n < 1 || incx < 1) {
            norm = 0.0;
        } else if (n == 1) {
            norm = Math.abs(x[1]);
        } else {
            double scale = 0.0;
            double ssq = 1.0;
            int limit = 1 + (n - 1) * incx;
            for (int ix = 1; ix <= limit; ix += incx) {
                double fac;
                if (x[ix] == 0.0) continue;
                double absxi = Math.abs(x[ix]);
                if (scale < absxi) {
                    fac = scale / absxi;
                    ssq = 1.0 + ssq * fac * fac;
                    scale = absxi;
                    continue;
                }
                fac = absxi / scale;
                ssq += fac * fac;
            }
            norm = scale * Math.sqrt(ssq);
        }
        return norm;
    }

    public static void dcopy_f77(int n, double[] dx, int incx, double[] dy, int incy) {
        if (n <= 0) {
            return;
        }
        if (incx == 1 && incy == 1) {
            int i;
            int m = n % 7;
            for (i = 1; i <= m; ++i) {
                dy[i] = dx[i];
            }
            for (i = m + 1; i <= n; i += 7) {
                dy[i] = dx[i];
                dy[i + 1] = dx[i + 1];
                dy[i + 2] = dx[i + 2];
                dy[i + 3] = dx[i + 3];
                dy[i + 4] = dx[i + 4];
                dy[i + 5] = dx[i + 5];
                dy[i + 6] = dx[i + 6];
            }
            return;
        }
        int ix = 1;
        int iy = 1;
        if (incx < 0) {
            ix = (-n + 1) * incx + 1;
        }
        if (incy < 0) {
            iy = (-n + 1) * incy + 1;
        }
        for (int i = 1; i <= n; ++i) {
            dy[iy] = dx[ix];
            ix += incx;
            iy += incy;
        }
    }

    public static void drotg_f77(double[] rotvec) {
        double z;
        double s;
        double c2;
        double r;
        double scale;
        double b;
        double a = rotvec[1];
        double roe = b = rotvec[2];
        if (Math.abs(a) > Math.abs(b)) {
            roe = a;
        }
        if ((scale = Math.abs(a) + Math.abs(b)) != 0.0) {
            double ra = a / scale;
            double rb = b / scale;
            r = scale * Math.sqrt(ra * ra + rb * rb);
            r = Blas_f77.sign_f77(1.0, roe) * r;
            c2 = a / r;
            s = b / r;
            z = 1.0;
            if (Math.abs(a) > Math.abs(b)) {
                z = s;
            }
            if (Math.abs(b) >= Math.abs(a) && c2 != 0.0) {
                z = 1.0 / c2;
            }
        } else {
            c2 = 1.0;
            s = 0.0;
            r = 0.0;
            z = 0.0;
        }
        a = r;
        b = z;
        rotvec[1] = a;
        rotvec[2] = b;
        rotvec[3] = c2;
        rotvec[4] = s;
    }

    public static void colaxpy_f77(int nrow, double a, double[][] x, int begin, int j1, int j2) {
        int i;
        if (nrow <= 0) {
            return;
        }
        if (a == 0.0) {
            return;
        }
        int m = nrow % 4;
        int mpbegin = m + begin;
        int end = begin + nrow - 1;
        for (i = begin; i < mpbegin; ++i) {
            double[] dArray = x[i];
            int n = j2;
            dArray[n] = dArray[n] + a * x[i][j1];
        }
        for (i = mpbegin; i <= end; i += 4) {
            double[] dArray = x[i];
            int n = j2;
            dArray[n] = dArray[n] + a * x[i][j1];
            double[] dArray2 = x[i + 1];
            int n2 = j2;
            dArray2[n2] = dArray2[n2] + a * x[i + 1][j1];
            double[] dArray3 = x[i + 2];
            int n3 = j2;
            dArray3[n3] = dArray3[n3] + a * x[i + 2][j1];
            double[] dArray4 = x[i + 3];
            int n4 = j2;
            dArray4[n4] = dArray4[n4] + a * x[i + 3][j1];
        }
    }

    public static void colvaxpy_f77(int nrow, double a, double[][] x, double[] y, int begin, int j) {
        int i;
        if (nrow <= 0) {
            return;
        }
        if (a == 0.0) {
            return;
        }
        int m = nrow % 4;
        int mpbegin = m + begin;
        int end = begin + nrow - 1;
        for (i = begin; i < mpbegin; ++i) {
            int n = i;
            y[n] = y[n] + a * x[i][j];
        }
        for (i = mpbegin; i <= end; i += 4) {
            int n = i;
            y[n] = y[n] + a * x[i][j];
            int n2 = i + 1;
            y[n2] = y[n2] + a * x[i + 1][j];
            int n3 = i + 2;
            y[n3] = y[n3] + a * x[i + 2][j];
            int n4 = i + 3;
            y[n4] = y[n4] + a * x[i + 3][j];
        }
    }

    public static void colvraxpy_f77(int nrow, double a, double[] y, double[][] x, int begin, int j) {
        int i;
        if (nrow <= 0) {
            return;
        }
        if (a == 0.0) {
            return;
        }
        int m = nrow % 4;
        int mpbegin = m + begin;
        int end = begin + nrow - 1;
        for (i = begin; i < mpbegin; ++i) {
            double[] dArray = x[i];
            int n = j;
            dArray[n] = dArray[n] + a * y[i];
        }
        for (i = mpbegin; i <= end; i += 4) {
            double[] dArray = x[i];
            int n = j;
            dArray[n] = dArray[n] + a * y[i];
            double[] dArray2 = x[i + 1];
            int n2 = j;
            dArray2[n2] = dArray2[n2] + a * y[i + 1];
            double[] dArray3 = x[i + 2];
            int n3 = j;
            dArray3[n3] = dArray3[n3] + a * y[i + 2];
            double[] dArray4 = x[i + 3];
            int n4 = j;
            dArray4[n4] = dArray4[n4] + a * y[i + 3];
        }
    }

    public static double coldot_f77(int nrow, double[][] x, int begin, int j1, int j2) {
        int i;
        double coldot = 0.0;
        if (nrow <= 0) {
            return coldot;
        }
        int m = nrow % 5;
        int mpbegin = m + begin;
        int end = begin + nrow - 1;
        for (i = begin; i < mpbegin; ++i) {
            coldot += x[i][j1] * x[i][j2];
        }
        for (i = mpbegin; i <= end; i += 5) {
            coldot += x[i][j1] * x[i][j2] + x[i + 1][j1] * x[i + 1][j2] + x[i + 2][j1] * x[i + 2][j2] + x[i + 3][j1] * x[i + 3][j2] + x[i + 4][j1] * x[i + 4][j2];
        }
        return coldot;
    }

    public static double colvdot_f77(int nrow, double[][] x, double[] y, int begin, int j) {
        int i;
        double colvdot = 0.0;
        if (nrow <= 0) {
            return colvdot;
        }
        int m = nrow % 5;
        int mpbegin = m + begin;
        int end = begin + nrow - 1;
        for (i = begin; i < mpbegin; ++i) {
            colvdot += x[i][j] * y[i];
        }
        for (i = mpbegin; i <= end; i += 5) {
            colvdot += x[i][j] * y[i] + x[i + 1][j] * y[i + 1] + x[i + 2][j] * y[i + 2] + x[i + 3][j] * y[i + 3] + x[i + 4][j] * y[i + 4];
        }
        return colvdot;
    }

    public static void colscal_f77(int nrow, double a, double[][] x, int begin, int j) {
        int i;
        if (nrow <= 0) {
            return;
        }
        int m = nrow % 5;
        int mpbegin = m + begin;
        int end = begin + nrow - 1;
        for (i = begin; i < mpbegin; ++i) {
            double[] dArray = x[i];
            int n = j;
            dArray[n] = dArray[n] * a;
        }
        for (i = mpbegin; i <= end; i += 5) {
            double[] dArray = x[i];
            int n = j;
            dArray[n] = dArray[n] * a;
            double[] dArray2 = x[i + 1];
            int n2 = j;
            dArray2[n2] = dArray2[n2] * a;
            double[] dArray3 = x[i + 2];
            int n3 = j;
            dArray3[n3] = dArray3[n3] * a;
            double[] dArray4 = x[i + 3];
            int n4 = j;
            dArray4[n4] = dArray4[n4] * a;
            double[] dArray5 = x[i + 4];
            int n5 = j;
            dArray5[n5] = dArray5[n5] * a;
        }
    }

    public static void dscalp_f77(int nrow, double a, double[] x, int begin) {
        if (nrow <= 0) {
            return;
        }
        int m = nrow % 5;
        int mpbegin = m + begin;
        int end = begin + nrow - 1;
        int i = begin;
        while (i < mpbegin) {
            int n = i++;
            x[n] = x[n] * a;
        }
        for (i = mpbegin; i <= end; i += 5) {
            int n = i;
            x[n] = x[n] * a;
            int n2 = i + 1;
            x[n2] = x[n2] * a;
            int n3 = i + 2;
            x[n3] = x[n3] * a;
            int n4 = i + 3;
            x[n4] = x[n4] * a;
            int n5 = i + 4;
            x[n5] = x[n5] * a;
        }
    }

    public static void colswap_f77(int n, double[][] x, int j1, int j2) {
        double temp;
        int i;
        if (n <= 0) {
            return;
        }
        int m = n % 3;
        for (i = 1; i <= m; ++i) {
            temp = x[i][j1];
            x[i][j1] = x[i][j2];
            x[i][j2] = temp;
        }
        for (i = m + 1; i <= n; i += 3) {
            temp = x[i][j1];
            x[i][j1] = x[i][j2];
            x[i][j2] = temp;
            temp = x[i + 1][j1];
            x[i + 1][j1] = x[i + 1][j2];
            x[i + 1][j2] = temp;
            temp = x[i + 2][j1];
            x[i + 2][j1] = x[i + 2][j2];
            x[i + 2][j2] = temp;
        }
    }

    public static double colnrm2_f77(int nrow, double[][] x, int begin, int j) {
        double norm;
        if (nrow < 1) {
            norm = 0.0;
        } else if (nrow == 1) {
            norm = Math.abs(x[begin][j]);
        } else {
            double scale = 0.0;
            double ssq = 1.0;
            int end = begin + nrow - 1;
            for (int i = begin; i <= end; ++i) {
                double fac;
                if (x[i][j] == 0.0) continue;
                double absxij = Math.abs(x[i][j]);
                if (scale < absxij) {
                    fac = scale / absxij;
                    ssq = 1.0 + ssq * fac * fac;
                    scale = absxij;
                    continue;
                }
                fac = absxij / scale;
                ssq += fac * fac;
            }
            norm = scale * Math.sqrt(ssq);
        }
        return norm;
    }

    public static double dnrm2p_f77(int nrow, double[] x, int begin) {
        double norm;
        if (nrow < 1) {
            norm = 0.0;
        } else if (nrow == 1) {
            norm = Math.abs(x[begin]);
        } else {
            double scale = 0.0;
            double ssq = 1.0;
            int end = begin + nrow - 1;
            for (int i = begin; i <= end; ++i) {
                double fac;
                if (x[i] == 0.0) continue;
                double absxi = Math.abs(x[i]);
                if (scale < absxi) {
                    fac = scale / absxi;
                    ssq = 1.0 + ssq * fac * fac;
                    scale = absxi;
                    continue;
                }
                fac = absxi / scale;
                ssq += fac * fac;
            }
            norm = scale * Math.sqrt(ssq);
        }
        return norm;
    }

    public static void dcopyp_f77(int nrow, double[] x, double[] y, int begin) {
        int i;
        int m = nrow % 7;
        int mpbegin = m + begin;
        int end = begin + nrow - 1;
        for (i = begin; i < mpbegin; ++i) {
            y[i] = x[i];
        }
        for (i = mpbegin; i <= end; i += 7) {
            y[i] = x[i];
            y[i + 1] = x[i + 1];
            y[i + 2] = x[i + 2];
            y[i + 3] = x[i + 3];
            y[i + 4] = x[i + 4];
            y[i + 5] = x[i + 5];
            y[i + 6] = x[i + 6];
        }
    }

    public static void colrot_f77(int n, double[][] x, int j1, int j2, double c2, double s) {
        if (n <= 0) {
            return;
        }
        for (int i = 1; i <= n; ++i) {
            double temp = c2 * x[i][j1] + s * x[i][j2];
            x[i][j2] = c2 * x[i][j2] - s * x[i][j1];
            x[i][j1] = temp;
        }
    }

    public static double sign_f77(double a, double b) {
        if (b < 0.0) {
            return -Math.abs(a);
        }
        return Math.abs(a);
    }

    public static void matmat_f77(double[][] a, double[][] b, double[][] c2, int n, int p, int r) {
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= r; ++j) {
                int k;
                double vdot = 0.0;
                int m = p % 5;
                for (k = 1; k <= m; ++k) {
                    vdot += a[i][k] * b[k][j];
                }
                for (k = m + 1; k <= p; k += 5) {
                    vdot += a[i][k] * b[k][j] + a[i][k + 1] * b[k + 1][j] + a[i][k + 2] * b[k + 2][j] + a[i][k + 3] * b[k + 3][j] + a[i][k + 4] * b[k + 4][j];
                }
                c2[i][j] = vdot;
            }
        }
    }

    public static void mattran_f77(double[][] a, double[][] at2, int n, int p) {
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= p; ++j) {
                at2[j][i] = a[i][j];
            }
        }
    }

    public static void matvec_f77(double[][] a, double[] b, double[] c2, int n, int p) {
        for (int i = 1; i <= n; ++i) {
            int j;
            double vdot = 0.0;
            int m = p % 5;
            for (j = 1; j <= m; ++j) {
                vdot += a[i][j] * b[j];
            }
            for (j = m + 1; j <= p; j += 5) {
                vdot += a[i][j] * b[j] + a[i][j + 1] * b[j + 1] + a[i][j + 2] * b[j + 2] + a[i][j + 3] * b[j + 3] + a[i][j + 4] * b[j + 4];
            }
            c2[i] = vdot;
        }
    }
}

