/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.axispos;

import net.imagej.animation.AnimationService;
import net.imagej.axis.AxisType;
import net.imagej.display.ImageDisplay;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.input.InputService;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Axes", mnemonic=97), @Menu(label="Axis Position Backward", accelerator="LESS")}, headless=true, attrs={@Attr(name="no-legacy")})
public class AxisPositionBackward
extends ContextCommand {
    @Parameter
    private AnimationService animationService;
    @Parameter
    private InputService inputService;
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;

    public void run() {
        this.animationService.getAnimation(this.display).stop();
        AxisType axis = this.display.getActiveAxis();
        if (axis == null) {
            return;
        }
        long decrement = 1L;
        if (this.inputService.isAltDown()) {
            decrement = 10L;
        }
        this.display.setPosition(this.display.getLongPosition(axis) - decrement, axis);
    }

    public void setDisplay(ImageDisplay disp) {
        this.display = disp;
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }
}

