/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.restructure;

import net.imagej.ImgPlus;
import net.imglib2.display.ColorTable;

public class ColorTableRemapper {
    private RemapAlgorithm remapper;

    public ColorTableRemapper(RemapAlgorithm remapper) {
        this.remapper = remapper;
    }

    public void remapColorTables(ImgPlus<?> srcImgPlus, ImgPlus<?> dstImgPlus) {
        int i;
        long[] origDims = new long[srcImgPlus.numDimensions()];
        long[] newDims = new long[dstImgPlus.numDimensions()];
        long[] origPlaneDims = new long[origDims.length - 2];
        long[] newPlaneDims = new long[newDims.length - 2];
        long[] origPlanePos = new long[origPlaneDims.length];
        long[] newPlanePos = new long[newPlaneDims.length];
        srcImgPlus.dimensions(origDims);
        dstImgPlus.dimensions(newDims);
        for (i = 0; i < origPlaneDims.length; ++i) {
            origPlaneDims[i] = origDims[i + 2];
        }
        for (i = 0; i < newPlaneDims.length; ++i) {
            newPlaneDims[i] = newDims[i + 2];
        }
        for (int tNum = 0; tNum < srcImgPlus.getColorTableCount(); ++tNum) {
            if (!this.remapper.isValidSourcePlane(tNum)) continue;
            ColorTableRemapper.toND(origPlaneDims, tNum, origPlanePos);
            this.remapper.remapPlanePosition(origPlaneDims, origPlanePos, newPlanePos);
            long newLongIndex = ColorTableRemapper.to1D(newPlaneDims, newPlanePos);
            int newIndex = ColorTableRemapper.intIndex(newLongIndex);
            ColorTable colorTable = srcImgPlus.getColorTable(tNum);
            dstImgPlus.setColorTable(colorTable, newIndex);
        }
    }

    public static void toND(long[] dims, long index, long[] pos) {
        long divisor = 1L;
        for (int i = 0; i < dims.length; ++i) {
            divisor *= dims[i];
        }
        long val = index;
        for (int i = pos.length - 1; i >= 0; --i) {
            pos[i] = val / (divisor /= dims[i]);
            val %= divisor;
        }
    }

    public static long to1D(long[] dims, long[] pos) {
        long val = 0L;
        long multiplier = 1L;
        for (int i = 0; i < dims.length; ++i) {
            val += multiplier * pos[i];
            multiplier *= dims[i];
        }
        return val;
    }

    private static int intIndex(long val) {
        if (val < 0L) {
            throw new IllegalArgumentException("color table remap problem: bad index calculation");
        }
        if (val > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("color table remap problem: too many planes in output dataset");
        }
        return (int)val;
    }

    public static interface RemapAlgorithm {
        public boolean isValidSourcePlane(long var1);

        public void remapPlanePosition(long[] var1, long[] var2, long[] var3);
    }
}

