/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.restructure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.imagej.Dataset;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.VariableAxis;
import org.scijava.ItemIO;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.log.LogService;
import org.scijava.module.Module;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Axes", mnemonic=97), @Menu(label="Edit Axes...")}, headless=true, initializer="initFields", attrs={@Attr(name="no-legacy")})
public class EditAxes
extends DynamicCommand {
    @Parameter
    private LogService log;
    @Parameter(type=ItemIO.BOTH)
    private Dataset dataset;

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public AxisType getAxisType(int d) {
        String value = (String)this.typeInput(d).getValue((Module)this);
        return value == null || value.isEmpty() ? null : Axes.get((String)value);
    }

    public void setAxisType(int d, AxisType axisType) {
        this.typeInput(d).setValue((Module)this, (Object)axisType.toString());
    }

    public String getUnit(int d) {
        String value = (String)this.unitInput(d).getValue((Module)this);
        return value == null || value.isEmpty() ? null : value;
    }

    public void setUnit(int d, String unit) {
        this.unitInput(d).setValue((Module)this, (Object)unit);
    }

    public double getVar(int d, String var) {
        return (Double)this.varInput(d, var).getValue((Module)this);
    }

    public void setVar(int d, String var, double value) {
        this.varInput(d, var).setValue((Module)this, (Object)value);
    }

    public void run() {
        this.checkAxisTypes();
        if (this.isCanceled()) {
            return;
        }
        for (int d = 0; d < this.dataset.numDimensions(); ++d) {
            CalibratedAxis axis = (CalibratedAxis)this.dataset.axis(d);
            axis.setType(this.getAxisType(d));
            axis.setUnit(this.getUnit(d));
            if (!(axis instanceof VariableAxis)) continue;
            VariableAxis varAxis = (VariableAxis)axis;
            for (String var : this.vars(varAxis)) {
                varAxis.set(var, Double.valueOf(this.getVar(d, var)));
            }
        }
    }

    protected void initFields() {
        AxisType[] axes;
        ArrayList<String> choices = new ArrayList<String>();
        for (AxisType axis : axes = Axes.knownTypes()) {
            choices.add(axis.getLabel());
        }
        for (int d = 0; d < this.dataset.numDimensions(); ++d) {
            CalibratedAxis axis = (CalibratedAxis)this.dataset.axis(d);
            MutableModuleItem axisItem = this.addInput("axis" + d, String.class);
            axisItem.setPersisted(false);
            axisItem.setVisibility(ItemVisibility.MESSAGE);
            axisItem.setValue((Module)this, (Object)("-- Axis #" + (d + 1) + " --"));
            MutableModuleItem typeItem = this.addInput(this.typeName(d), String.class);
            typeItem.setPersisted(false);
            typeItem.setLabel("Type");
            typeItem.setChoices(choices);
            typeItem.setValue((Module)this, (Object)axis.type().toString());
            MutableModuleItem unitItem = this.addInput(this.unitName(d), String.class);
            unitItem.setPersisted(false);
            unitItem.setLabel("Unit");
            unitItem.setValue((Module)this, (Object)axis.unit());
            boolean isVariable = axis instanceof VariableAxis;
            String equation = isVariable ? axis.generalEquation() : axis.particularEquation();
            MutableModuleItem equationItem = this.addInput("equation" + d, String.class);
            equationItem.setPersisted(false);
            equationItem.setVisibility(ItemVisibility.MESSAGE);
            equationItem.setValue((Module)this, (Object)equation);
            if (!isVariable) continue;
            VariableAxis varAxis = (VariableAxis)axis;
            for (String var : this.vars(varAxis)) {
                MutableModuleItem varItem = this.addInput(this.varName(d, var), Double.class);
                varItem.setPersisted(false);
                varItem.setLabel(var);
                varItem.setValue((Module)this, (Object)varAxis.get(var));
            }
        }
    }

    private String typeName(int d) {
        return "type" + d;
    }

    private String unitName(int d) {
        return "unit" + d;
    }

    private String varName(int d, String var) {
        return "var" + d + ":" + var;
    }

    private MutableModuleItem<String> typeInput(int d) {
        return (MutableModuleItem)this.getInfo().getInput(this.typeName(d));
    }

    private MutableModuleItem<String> unitInput(int d) {
        return (MutableModuleItem)this.getInfo().getInput(this.unitName(d));
    }

    private MutableModuleItem<Double> varInput(int d, String var) {
        return (MutableModuleItem)this.getInfo().getInput(this.varName(d, var));
    }

    private void checkAxisTypes() {
        for (int i = 0; i < this.dataset.numDimensions(); ++i) {
            AxisType axisType = this.getAxisType(i);
            for (int j = i + 1; j < this.dataset.numDimensions(); ++j) {
                if (axisType != this.getAxisType(j)) continue;
                this.cancel("Axes #" + (i + 1) + " and #" + (j + 1) + " are both " + axisType + ". Axis designations must be mutually exclusive");
                return;
            }
        }
    }

    private List<String> vars(VariableAxis varAxis) {
        ArrayList<String> vars = new ArrayList<String>(varAxis.vars());
        Collections.sort(vars);
        return vars;
    }
}

