/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.registration;

import java.util.ArrayList;
import mpicbg.spim.data.SpimDataInstantiationException;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewTransform;
import mpicbg.spim.data.registration.ViewTransformAffine;
import mpicbg.spim.data.registration.XmlIoViewTransform;
import org.jdom2.Content;
import org.jdom2.Element;

public class XmlIoViewRegistration {
    private final XmlIoViewTransform xmlIoViewTransform = new XmlIoViewTransform();

    public String getTag() {
        return "ViewRegistration";
    }

    public Element toXml(ViewRegistration viewRegistration) {
        Element elem = new Element("ViewRegistration");
        elem.setAttribute("timepoint", Integer.toString(viewRegistration.getTimePointId()));
        elem.setAttribute("setup", Integer.toString(viewRegistration.getViewSetupId()));
        ArrayList<ViewTransform> transforms = new ArrayList<ViewTransform>(viewRegistration.getTransformList());
        if (transforms.isEmpty()) {
            transforms.add(new ViewTransformAffine(null, viewRegistration.getModel()));
        }
        for (ViewTransform t : transforms) {
            elem.addContent((Content)this.xmlIoViewTransform.toXml(t));
        }
        return elem;
    }

    public ViewRegistration fromXml(Element elem) throws SpimDataInstantiationException {
        int timepointId = Integer.parseInt(elem.getAttributeValue("timepoint"));
        int setupId = Integer.parseInt(elem.getAttributeValue("setup"));
        ArrayList<ViewTransform> transforms = new ArrayList<ViewTransform>();
        for (Element c : elem.getChildren(this.xmlIoViewTransform.getTag())) {
            transforms.add(this.xmlIoViewTransform.fromXml(c));
        }
        return new ViewRegistration(timepointId, setupId, transforms);
    }
}

