/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.fft2;

import edu.mines.jtk.dsp.FftComplex;
import edu.mines.jtk.dsp.FftReal;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.iterator.LocalizingZeroMinIntervalIterator;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

public class FFTMethods {
    public static final <C extends ComplexType<C>, R extends RealType<R>> boolean complexToReal(RandomAccessibleInterval<C> input, RandomAccessibleInterval<R> output, int dim) {
        return FFTMethods.complexToReal(input, output, output, dim, true);
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> boolean complexToReal(RandomAccessibleInterval<C> input, RandomAccessibleInterval<R> output, Interval interval, int dim) {
        return FFTMethods.complexToReal(input, output, interval, dim, true);
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> boolean complexToReal(RandomAccessibleInterval<C> input, RandomAccessibleInterval<R> output, Interval interval, int dim, boolean scale) {
        return FFTMethods.complexToReal(input, output, interval, dim, scale, Runtime.getRuntime().availableProcessors());
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> boolean complexToReal(RandomAccessibleInterval<C> input, RandomAccessibleInterval<R> output, int dim, boolean scale, int nThreads) {
        return FFTMethods.complexToReal(input, output, output, dim, scale, nThreads);
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> boolean complexToReal(RandomAccessibleInterval<C> input, RandomAccessibleInterval<R> output, Interval interval, int dim, boolean scale, int nThreads) {
        ExecutorService service = Executors.newFixedThreadPool(nThreads);
        boolean ret = FFTMethods.complexToReal(input, output, interval, dim, scale, service);
        service.shutdown();
        return ret;
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> boolean complexToReal(RandomAccessibleInterval<C> input, RandomAccessibleInterval<R> output, int dim, boolean scale, ExecutorService service) {
        return FFTMethods.complexToReal(input, output, output, dim, scale, service);
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> boolean complexToReal(final RandomAccessibleInterval<C> input, final RandomAccessibleInterval<R> output, final Interval interval, final int dim, final boolean scale, ExecutorService service) {
        final int numDimensions = input.numDimensions();
        final int[] inputSize = new int[numDimensions];
        final int numThreads = Runtime.getRuntime().availableProcessors();
        int numTasks = numThreads > 1 ? numThreads * 4 : 1;
        for (int d = 0; d < numDimensions; ++d) {
            inputSize[d] = (int)input.dimension(d);
        }
        final int complexSize = inputSize[dim];
        final int realSize = (complexSize - 1) * 2;
        if (!FFTMethods.verifyRealToComplexfftDimensions(realSize, complexSize)) {
            System.out.println("Unsupported combination of dimensionality of input and output");
            return false;
        }
        if (numDimensions > 1) {
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            final AtomicInteger ai = new AtomicInteger(0);
            for (int ithread = 0; ithread < numTasks; ++ithread) {
                Callable<Void> callable = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        int myNumber = ai.getAndIncrement();
                        float[] tempIn = new float[complexSize * 2];
                        float[] tempOut = new float[realSize];
                        FftReal fft = new FftReal(realSize);
                        RandomAccess randomAccessIn = input.randomAccess();
                        RandomAccess randomAccessOut = output.randomAccess();
                        int[] fakeSize = new int[numDimensions - 1];
                        int[] cursorInPosition = new int[numDimensions];
                        int[] cursorOutPosition = new int[numDimensions];
                        int countDim = 0;
                        for (int d = 0; d < numDimensions; ++d) {
                            if (d == dim) continue;
                            fakeSize[countDim++] = inputSize[d];
                        }
                        LocalizingZeroMinIntervalIterator cursorDim = new LocalizingZeroMinIntervalIterator(fakeSize);
                        block1: while (cursorDim.hasNext()) {
                            cursorDim.fwd();
                            if (cursorDim.getIntPosition(0) % numThreads != myNumber) continue;
                            cursorDim.localize(fakeSize);
                            cursorInPosition[dim] = (int)input.min(dim);
                            cursorOutPosition[dim] = (int)output.min(dim);
                            countDim = 0;
                            for (int d = 0; d < numDimensions; ++d) {
                                if (d == dim) continue;
                                if ((long)fakeSize[countDim] < interval.min(d) || (long)fakeSize[countDim] > interval.max(d)) continue block1;
                                cursorInPosition[d] = fakeSize[countDim] + (int)input.min(d);
                                cursorOutPosition[d] = fakeSize[countDim] + (int)output.min(d) - (int)interval.min(d);
                                ++countDim;
                            }
                            randomAccessIn.setPosition(cursorInPosition);
                            randomAccessOut.setPosition(cursorOutPosition);
                            FFTMethods.computeComplexToReal1dFFT(fft, randomAccessIn, randomAccessOut, interval, dim, tempIn, tempOut, scale);
                        }
                        return null;
                    }
                };
                futures.add(service.submit(callable));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        } else {
            float[] tempIn = new float[complexSize * 2];
            float[] tempOut = new float[realSize];
            FftReal fft = new FftReal(realSize);
            RandomAccess randomAccess = input.randomAccess();
            RandomAccess randomAccessOut = output.randomAccess();
            randomAccess.setPosition((int)input.min(0), 0);
            randomAccessOut.setPosition((int)output.min(0), 0);
            FFTMethods.computeComplexToReal1dFFT(fft, randomAccess, randomAccessOut, interval, 0, tempIn, tempOut, scale);
        }
        return true;
    }

    public static final <R extends RealType<R>, C extends ComplexType<C>> boolean realToComplex(RandomAccessibleInterval<R> input, RandomAccessibleInterval<C> output, int dim) {
        return FFTMethods.realToComplex(input, output, output, dim, false);
    }

    public static final <R extends RealType<R>, C extends ComplexType<C>> boolean realToComplex(RandomAccessibleInterval<R> input, RandomAccessibleInterval<C> output, Interval interval, int dim) {
        return FFTMethods.realToComplex(input, output, dim, false);
    }

    public static final <R extends RealType<R>, C extends ComplexType<C>> boolean realToComplex(RandomAccessibleInterval<R> input, RandomAccessibleInterval<C> output, int dim, boolean scale) {
        return FFTMethods.realToComplex(input, output, output, dim, scale);
    }

    public static final <R extends RealType<R>, C extends ComplexType<C>> boolean realToComplex(RandomAccessibleInterval<R> input, RandomAccessibleInterval<C> output, Interval interval, int dim, boolean scale) {
        return FFTMethods.realToComplex(input, output, interval, dim, scale, Runtime.getRuntime().availableProcessors());
    }

    public static final <R extends RealType<R>, C extends ComplexType<C>> boolean realToComplex(RandomAccessibleInterval<R> input, RandomAccessibleInterval<C> output, int dim, boolean scale, int nThreads) {
        return FFTMethods.realToComplex(input, output, output, dim, scale, nThreads);
    }

    public static final <R extends RealType<R>, C extends ComplexType<C>> boolean realToComplex(RandomAccessibleInterval<R> input, RandomAccessibleInterval<C> output, Interval interval, int dim, boolean scale, int nThreads) {
        ExecutorService service = Executors.newFixedThreadPool(nThreads);
        boolean ret = FFTMethods.realToComplex(input, output, interval, dim, scale, service);
        service.shutdown();
        return ret;
    }

    public static final <R extends RealType<R>, C extends ComplexType<C>> boolean realToComplex(RandomAccessibleInterval<R> input, RandomAccessibleInterval<C> output, int dim, boolean scale, ExecutorService service) {
        return FFTMethods.realToComplex(input, output, output, dim, scale, service);
    }

    public static final <R extends RealType<R>, C extends ComplexType<C>> boolean realToComplex(final RandomAccessibleInterval<R> input, final RandomAccessibleInterval<C> output, final Interval interval, final int dim, final boolean scale, ExecutorService service) {
        final int numDimensions = input.numDimensions();
        final int[] inputSize = new int[numDimensions];
        final int numThreads = Runtime.getRuntime().availableProcessors();
        for (int d = 0; d < numDimensions; ++d) {
            inputSize[d] = (int)input.dimension(d);
        }
        final int realSize = inputSize[dim];
        final int complexSize = realSize / 2 + 1;
        if (!FFTMethods.verifyRealToComplexfftDimensions(realSize, complexSize)) {
            System.out.println("Input dimensions not supported by FFT.");
            return false;
        }
        if (numDimensions > 1) {
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            final AtomicInteger ai = new AtomicInteger(0);
            for (int ithread = 0; ithread < numThreads; ++ithread) {
                Callable<Void> callable = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        int myNumber = ai.getAndIncrement();
                        float[] tempIn = new float[realSize];
                        float[] tempOut = new float[complexSize * 2];
                        FftReal fft = new FftReal(realSize);
                        RandomAccess randomAccessIn = input.randomAccess();
                        RandomAccess randomAccessOut = output.randomAccess();
                        int[] fakeSize = new int[numDimensions - 1];
                        int[] cursorInPosition = new int[numDimensions];
                        int[] cursorOutPosition = new int[numDimensions];
                        int countDim = 0;
                        for (int d = 0; d < numDimensions; ++d) {
                            if (d == dim) continue;
                            fakeSize[countDim++] = inputSize[d];
                        }
                        LocalizingZeroMinIntervalIterator cursorDim = new LocalizingZeroMinIntervalIterator(fakeSize);
                        block1: while (cursorDim.hasNext()) {
                            cursorDim.fwd();
                            if (cursorDim.getIntPosition(0) % numThreads != myNumber) continue;
                            cursorDim.localize(fakeSize);
                            cursorInPosition[dim] = (int)input.min(dim);
                            cursorOutPosition[dim] = (int)output.min(dim);
                            countDim = 0;
                            for (int d = 0; d < numDimensions; ++d) {
                                if (d == dim) continue;
                                if ((long)fakeSize[countDim] < interval.min(d) || (long)fakeSize[countDim] > interval.max(d)) continue block1;
                                cursorInPosition[d] = fakeSize[countDim] + (int)input.min(d);
                                cursorOutPosition[d] = fakeSize[countDim] + (int)output.min(d) - (int)interval.min(d);
                                ++countDim;
                            }
                            randomAccessIn.setPosition(cursorInPosition);
                            randomAccessOut.setPosition(cursorOutPosition);
                            FFTMethods.computeRealToComplex1dFFT(fft, randomAccessIn, randomAccessOut, interval, dim, tempIn, tempOut, scale);
                        }
                        return null;
                    }
                };
                futures.add(service.submit(callable));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        } else {
            float[] tempIn = new float[realSize];
            float[] tempOut = new float[complexSize * 2];
            FftReal fft = new FftReal(realSize);
            RandomAccess randomAccess = input.randomAccess();
            RandomAccess randomAccessOut = output.randomAccess();
            randomAccess.setPosition((int)input.min(0), 0);
            randomAccessOut.setPosition((int)output.min(0), 0);
            FFTMethods.computeRealToComplex1dFFT(fft, randomAccess, randomAccessOut, interval, 0, tempIn, tempOut, scale);
        }
        return true;
    }

    public static final <C extends ComplexType<C>> boolean complexToComplex(RandomAccessibleInterval<C> data, int dim, boolean forward) {
        if (forward) {
            return FFTMethods.complexToComplex(data, dim, forward, false);
        }
        return FFTMethods.complexToComplex(data, dim, forward, true);
    }

    public static final <C extends ComplexType<C>> boolean complexToComplex(RandomAccessibleInterval<C> data, int dim, boolean forward, boolean scale) {
        ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        boolean ret = FFTMethods.complexToComplex(data, dim, forward, scale, service);
        service.shutdown();
        return ret;
    }

    public static final <C extends ComplexType<C>> boolean complexToComplex(final RandomAccessibleInterval<C> data, final int dim, final boolean forward, final boolean scale, ExecutorService service) {
        final int numDimensions = data.numDimensions();
        final int[] dataSize = new int[numDimensions];
        final int numThreads = Runtime.getRuntime().availableProcessors();
        for (int d = 0; d < numDimensions; ++d) {
            dataSize[d] = (int)data.dimension(d);
        }
        if (!FFTMethods.verifyComplexToComplexfftDimensions(dataSize[dim], dataSize[dim])) {
            System.out.println("Unsupported combination of dimensionality of input and output");
            return false;
        }
        final int size = dataSize[dim];
        if (numDimensions > 1) {
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            final AtomicInteger ai = new AtomicInteger(0);
            for (int ithread = 0; ithread < numThreads; ++ithread) {
                Callable<Void> callable = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        int myNumber = ai.getAndIncrement();
                        float[] tempIn = new float[size * 2];
                        float[] tempOut = new float[size * 2];
                        FftComplex fft = new FftComplex(size);
                        RandomAccess randomAccess = data.randomAccess();
                        int[] fakeSize = new int[numDimensions - 1];
                        int[] randomAccessPosition = new int[numDimensions];
                        int countDim = 0;
                        for (int d = 0; d < numDimensions; ++d) {
                            if (d == dim) continue;
                            fakeSize[countDim++] = dataSize[d];
                        }
                        LocalizingZeroMinIntervalIterator cursorDim = new LocalizingZeroMinIntervalIterator(fakeSize);
                        while (cursorDim.hasNext()) {
                            cursorDim.fwd();
                            if (cursorDim.getIntPosition(0) % numThreads != myNumber) continue;
                            cursorDim.localize(fakeSize);
                            randomAccessPosition[dim] = (int)data.min(dim);
                            countDim = 0;
                            for (int d = 0; d < numDimensions; ++d) {
                                if (d == dim) continue;
                                randomAccessPosition[d] = fakeSize[countDim++] + (int)data.min(d);
                            }
                            randomAccess.setPosition(randomAccessPosition);
                            FFTMethods.computeComplexToComplex1dFFT(fft, forward, randomAccess, dim, tempIn, tempOut, scale);
                        }
                        return null;
                    }
                };
                futures.add(service.submit(callable));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        } else {
            float[] tempIn = new float[size * 2];
            float[] tempOut = new float[size * 2];
            FftComplex fft = new FftComplex(size);
            RandomAccess randomAccess = data.randomAccess();
            randomAccess.setPosition((int)data.min(0), 0);
            FFTMethods.computeComplexToComplex1dFFT(fft, forward, randomAccess, dim, tempIn, tempOut, scale);
        }
        return true;
    }

    private static final <R extends RealType<R>, C extends ComplexType<C>> void computeRealToComplex1dFFT(FftReal fft, RandomAccess<R> randomAccessIn, RandomAccess<C> randomAccessOut, Interval range, int dim, float[] tempIn, float[] tempOut, boolean scale) {
        int max;
        int min;
        int realSize = tempIn.length;
        int complexSize = tempOut.length / 2;
        int realMax = realSize - 1;
        int complexMax = complexSize - 1;
        for (int i = 0; i < realMax; ++i) {
            tempIn[i] = ((RealType)randomAccessIn.get()).getRealFloat();
            randomAccessIn.fwd(dim);
        }
        tempIn[realMax] = ((RealType)randomAccessIn.get()).getRealFloat();
        fft.realToComplex(-1, tempIn, tempOut);
        if (range == null) {
            min = 0;
            max = complexMax;
        } else {
            min = (int)range.min(dim);
            max = (int)range.max(dim);
        }
        int complexMax2 = max * 2;
        if (scale) {
            for (int i = min; i < max; ++i) {
                int j = i * 2;
                ((ComplexType)randomAccessOut.get()).setComplexNumber(tempOut[j] / (float)realSize, tempOut[j + 1] / (float)realSize);
                randomAccessOut.fwd(dim);
            }
            ((ComplexType)randomAccessOut.get()).setComplexNumber(tempOut[complexMax2] / (float)realSize, tempOut[complexMax2 + 1] / (float)realSize);
        } else {
            for (int i = min; i < max; ++i) {
                int j = i * 2;
                ((ComplexType)randomAccessOut.get()).setComplexNumber(tempOut[j], tempOut[j + 1]);
                randomAccessOut.fwd(dim);
            }
            ((ComplexType)randomAccessOut.get()).setComplexNumber(tempOut[complexMax2], tempOut[complexMax2 + 1]);
        }
    }

    private static final <C extends ComplexType<C>, R extends RealType<R>> void computeComplexToReal1dFFT(FftReal fft, RandomAccess<C> randomAccessIn, RandomAccess<R> randomAccessOut, Interval range, int dim, float[] tempIn, float[] tempOut, boolean scale) {
        int max;
        int min;
        int complexSize = tempIn.length / 2;
        int realSize = tempOut.length;
        int complexMax = complexSize - 1;
        int realMax = realSize - 1;
        int complexMax2 = complexMax * 2;
        for (int i = 0; i < complexMax; ++i) {
            int j = i * 2;
            tempIn[j] = ((ComplexType)randomAccessIn.get()).getRealFloat();
            tempIn[j + 1] = ((ComplexType)randomAccessIn.get()).getImaginaryFloat();
            randomAccessIn.fwd(0);
        }
        tempIn[complexMax2] = ((ComplexType)randomAccessIn.get()).getRealFloat();
        tempIn[complexMax2 + 1] = ((ComplexType)randomAccessIn.get()).getImaginaryFloat();
        fft.complexToReal(1, tempIn, tempOut);
        if (range == null) {
            min = 0;
            max = realMax;
        } else {
            min = (int)range.min(dim);
            max = (int)range.max(dim);
        }
        if (scale) {
            for (int x = min; x < max; ++x) {
                ((RealType)randomAccessOut.get()).setReal(tempOut[x] / (float)realSize);
                randomAccessOut.fwd(0);
            }
            ((RealType)randomAccessOut.get()).setReal(tempOut[max] / (float)realSize);
        } else {
            for (int x = min; x < max; ++x) {
                ((RealType)randomAccessOut.get()).setReal(tempOut[x]);
                randomAccessOut.fwd(0);
            }
            ((RealType)randomAccessOut.get()).setReal(tempOut[max]);
        }
    }

    private static final <C extends ComplexType<C>> void computeComplexToComplex1dFFT(FftComplex fft, boolean forward, RandomAccess<C> randomAccess, int dim, float[] tempIn, float[] tempOut, boolean scale) {
        int j;
        int i;
        int size = tempIn.length / 2;
        int max = size - 1;
        int max2 = max * 2;
        for (i = 0; i < max; ++i) {
            j = i * 2;
            tempIn[j] = ((ComplexType)randomAccess.get()).getRealFloat();
            tempIn[j + 1] = ((ComplexType)randomAccess.get()).getImaginaryFloat();
            randomAccess.fwd(dim);
        }
        tempIn[max2] = ((ComplexType)randomAccess.get()).getRealFloat();
        tempIn[max2 + 1] = ((ComplexType)randomAccess.get()).getImaginaryFloat();
        if (forward) {
            fft.complexToComplex(-1, tempIn, tempOut);
        } else {
            fft.complexToComplex(1, tempIn, tempOut);
        }
        randomAccess.move(-max, dim);
        if (scale) {
            for (i = 0; i < max; ++i) {
                j = i * 2;
                ((ComplexType)randomAccess.get()).setComplexNumber(tempOut[j] / (float)size, tempOut[j + 1] / (float)size);
                randomAccess.fwd(dim);
            }
            ((ComplexType)randomAccess.get()).setComplexNumber(tempOut[max2] / (float)size, tempOut[max2 + 1] / (float)size);
        } else {
            for (i = 0; i < max; ++i) {
                j = i * 2;
                ((ComplexType)randomAccess.get()).setComplexNumber(tempOut[j], tempOut[j + 1]);
                randomAccess.fwd(dim);
            }
            ((ComplexType)randomAccess.get()).setComplexNumber(tempOut[max2], tempOut[max2 + 1]);
        }
    }

    public static final Interval paddingIntervalCentered(Interval input, Dimensions paddingDimensions) {
        long[] min = new long[input.numDimensions()];
        long[] max = new long[input.numDimensions()];
        for (int d = 0; d < input.numDimensions(); ++d) {
            long difference = paddingDimensions.dimension(d) - input.dimension(d);
            if (difference % 2L == 0L) {
                min[d] = input.min(d) - difference / 2L;
                max[d] = input.max(d) + difference / 2L;
                continue;
            }
            min[d] = input.min(d) - difference / 2L;
            max[d] = input.max(d) + difference / 2L + 1L;
        }
        return new FinalInterval(min, max);
    }

    public static final Interval unpaddingIntervalCentered(Interval fftDimensions, Dimensions originalDimensions) {
        long[] min = new long[fftDimensions.numDimensions()];
        long[] max = new long[fftDimensions.numDimensions()];
        long realSize = (fftDimensions.dimension(0) - 1L) * 2L;
        long difference = realSize - originalDimensions.dimension(0);
        min[0] = fftDimensions.min(0) + difference / 2L;
        max[0] = min[0] + originalDimensions.dimension(0) - 1L;
        for (int d = 1; d < fftDimensions.numDimensions(); ++d) {
            difference = fftDimensions.dimension(d) - originalDimensions.dimension(d);
            min[d] = fftDimensions.min(d) + difference / 2L;
            max[d] = min[d] + originalDimensions.dimension(d) - 1L;
        }
        return new FinalInterval(min, max);
    }

    public static final void dimensionsComplexToRealSmall(Dimensions inputDimensions, long[] paddedDimensions, long[] realSize) {
        int d0 = ((int)inputDimensions.dimension(0) - 1) * 2;
        paddedDimensions[0] = FftReal.nfftSmall(d0) / 2 + 1;
        realSize[0] = (paddedDimensions[0] - 1L) * 2L;
        for (int d = 1; d < inputDimensions.numDimensions(); ++d) {
            realSize[d] = paddedDimensions[d] = (long)FftComplex.nfftSmall((int)inputDimensions.dimension(d));
        }
    }

    public static final void dimensionsComplexToRealFast(Dimensions inputDimensions, long[] paddedDimensions, long[] realSize) {
        int d0 = ((int)inputDimensions.dimension(0) - 1) * 2;
        paddedDimensions[0] = FftReal.nfftFast(d0) / 2 + 1;
        realSize[0] = (paddedDimensions[0] - 1L) * 2L;
        for (int d = 1; d < inputDimensions.numDimensions(); ++d) {
            realSize[d] = paddedDimensions[d] = (long)FftComplex.nfftFast((int)inputDimensions.dimension(d));
        }
    }

    public static final boolean dimensionsEqual(Interval interval, long[] paddedDimensions) {
        for (int d = 0; d < interval.numDimensions(); ++d) {
            if (interval.dimension(d) == paddedDimensions[d]) continue;
            return false;
        }
        return true;
    }

    public static final boolean dimensionsEqual(Dimensions interval, Dimensions padded) {
        for (int d = 0; d < interval.numDimensions(); ++d) {
            if (interval.dimension(d) == padded.dimension(d)) continue;
            return false;
        }
        return true;
    }

    public static final void dimensionsRealToComplexFast(Dimensions inputDimensions, long[] paddedDimensions, long[] fftDimensions) {
        paddedDimensions[0] = FftReal.nfftFast((int)inputDimensions.dimension(0));
        fftDimensions[0] = paddedDimensions[0] / 2L + 1L;
        for (int d = 1; d < inputDimensions.numDimensions(); ++d) {
            fftDimensions[d] = paddedDimensions[d] = (long)FftComplex.nfftFast((int)inputDimensions.dimension(d));
        }
    }

    public static final void dimensionsRealToComplexSmall(Dimensions inputDimensions, long[] paddedDimensions, long[] fftDimensions) {
        paddedDimensions[0] = FftReal.nfftSmall((int)inputDimensions.dimension(0));
        fftDimensions[0] = paddedDimensions[0] / 2L + 1L;
        for (int d = 1; d < inputDimensions.numDimensions(); ++d) {
            fftDimensions[d] = paddedDimensions[d] = (long)FftComplex.nfftSmall((int)inputDimensions.dimension(d));
        }
    }

    public static final void dimensionsComplexToComplexFast(Dimensions inputDimensions, long[] paddedDimensions) {
        for (int d = 0; d < inputDimensions.numDimensions(); ++d) {
            paddedDimensions[d] = FftComplex.nfftFast((int)inputDimensions.dimension(d));
        }
    }

    public static final void dimensionsComplexToComplexSmall(Dimensions inputDimensions, long[] paddedDimensions) {
        for (int d = 0; d < inputDimensions.numDimensions(); ++d) {
            paddedDimensions[d] = FftComplex.nfftSmall((int)inputDimensions.dimension(d));
        }
    }

    protected static final boolean verifyRealToComplexfftDimensions(int inputSize, int outputSize) {
        return FftReal.nfftFast(inputSize) / 2 + 1 == outputSize || FftReal.nfftSmall(inputSize) / 2 + 1 == outputSize;
    }

    protected static final boolean verifyComplexToComplexfftDimensions(int inputSize, int outputSize) {
        return FftComplex.nfftFast(inputSize) == outputSize || FftComplex.nfftSmall(inputSize) == outputSize;
    }

    public static final <T extends ComplexType<T>> void complexConjugate(RandomAccessibleInterval<T> complexData) {
        for (ComplexType type : Views.iterable(complexData)) {
            type.complexConjugate();
        }
    }
}

