/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.compute;

import edu.utexas.clm.archipelago.Cluster;
import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.compute.ArchipelagoFuture;
import edu.utexas.clm.archipelago.compute.ProcessManager;
import edu.utexas.clm.archipelago.listen.ProcessListener;
import edu.utexas.clm.archipelago.network.node.ClusterNode;
import edu.utexas.clm.archipelago.util.ProcessManagerCoreComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class Scheduler
extends Thread
implements ProcessListener {
    private static final boolean ENABLE_VERBOSE_DEBUGGING = false;
    private static final int DEFAULT_PAUSE_MS = 1000;
    private final Cluster cluster;
    private final Map<Long, ProcessManager> runningProcesses;
    private final Map<Long, ProcessManager> allProcesses;
    private final Map<Long, ArchipelagoFuture<?>> futures;
    private final LinkedList<ProcessManager<?>> normalQueue;
    private final LinkedList<ProcessManager<?>> priorityQueue;
    private final LinkedList<ProcessManager<?>> internalPriorityQueue;
    private final LinkedList<ProcessManager<?>> internalNormalQueue;
    private final AtomicBoolean running;
    private final AtomicBoolean okToSleep;
    private final AtomicBoolean ateAnApple;
    private final AtomicInteger pauseTime;
    private final AtomicInteger nRunningJobs;
    private final AtomicInteger nQueuedJobs;
    private final ReentrantLock queueLock;
    private final ReentrantLock schedulerLock;
    private final ReentrantLock futureLock;
    private final ArrayList<ProcessManager<?>> remainingProcessManagers;

    private static void verboseDebug(String message) {
    }

    public Scheduler(Cluster cluster) {
        this.cluster = cluster;
        this.runningProcesses = Collections.synchronizedMap(new HashMap());
        this.allProcesses = new HashMap<Long, ProcessManager>();
        this.normalQueue = new LinkedList();
        this.priorityQueue = new LinkedList();
        this.internalNormalQueue = new LinkedList();
        this.internalPriorityQueue = new LinkedList();
        this.running = new AtomicBoolean(false);
        this.okToSleep = new AtomicBoolean(false);
        this.ateAnApple = new AtomicBoolean(false);
        this.pauseTime = new AtomicInteger(1000);
        this.nRunningJobs = new AtomicInteger(0);
        this.nQueuedJobs = new AtomicInteger(0);
        this.queueLock = new ReentrantLock();
        this.schedulerLock = new ReentrantLock();
        this.futureLock = new ReentrantLock();
        this.futures = Collections.synchronizedMap(new HashMap());
        this.remainingProcessManagers = new ArrayList();
    }

    private void rotate(LinkedList<ClusterNode> nodeList) {
        if (nodeList.size() > 1) {
            ClusterNode front = nodeList.remove(0);
            nodeList.addLast(front);
        }
    }

    private boolean trySubmit(ProcessManager<?> pm, LinkedList<ClusterNode> nodeList) {
        if (nodeList.isEmpty()) {
            FijiArchipelago.debug("Scheduler: could not schedule job " + pm.getID() + ": no available nodes");
            return false;
        }
        for (int i = 0; i < nodeList.size(); ++i) {
            ClusterNode node = nodeList.getFirst();
            if (node.numAvailableThreads() >= pm.requestedCores(node) && node.submit(pm, this)) {
                FijiArchipelago.debug("Scheduler: submitting job " + pm.getID() + " to node " + node.getHost());
                this.runningProcesses.put(pm.getID(), pm);
                this.nRunningJobs.set(this.runningProcesses.size());
                this.nQueuedJobs.decrementAndGet();
                if (node.numAvailableThreads() <= 0) {
                    nodeList.remove(node);
                }
                return true;
            }
            this.rotate(nodeList);
        }
        FijiArchipelago.debug("Scheduler: could not schedule job " + pm.getID() + ": no nodes with enough available cores");
        return false;
    }

    private void spawnPoke() {
        this.wake();
    }

    private void updateQueueSize() {
        int n = this.internalPriorityQueue.size() + this.internalNormalQueue.size() + this.normalQueue.size() + this.priorityQueue.size();
        this.nQueuedJobs.set(n);
    }

    private void doSubmit(LinkedList<ProcessManager<?>> queue, LinkedList<ClusterNode> nodeList) {
        ArrayList<ProcessManager> submittedPMs = new ArrayList<ProcessManager>(queue.size());
        for (ProcessManager processManager : queue) {
            if (this.trySubmit(processManager, nodeList)) {
                submittedPMs.add(processManager);
            }
            this.rotate(nodeList);
        }
        queue.removeAll(submittedPMs);
    }

    private boolean queue(ProcessManager<?> pm, LinkedList<ProcessManager<?>> queue) {
        if (this.running.get()) {
            this.queueLock.lock();
            pm.setRunningOn(null);
            queue.add(pm);
            this.okToSleep.set(true);
            this.allProcesses.put(pm.getID(), pm);
            this.queueLock.unlock();
            this.spawnPoke();
            return true;
        }
        return false;
    }

    private <T> ArchipelagoFuture<T> queue(Callable<T> callable, float np, boolean f, LinkedList<ProcessManager<?>> queue) {
        ArchipelagoFuture future = new ArchipelagoFuture(this);
        long id = future.getID();
        this.futureLock.lock();
        this.futures.put(id, future);
        this.futureLock.unlock();
        if (!this.queue(new ProcessManager<T>(callable, id, np, f), queue)) {
            this.futureLock.lock();
            this.futures.remove(id);
            this.futureLock.unlock();
            future.finish(new Exception("Could not queue"));
        }
        return future;
    }

    private void wake() {
        this.okToSleep.set(false);
        if (this.ateAnApple.get()) {
            super.interrupt();
        }
    }

    @Override
    public boolean processFinished(ProcessManager<?> process) {
        boolean ok = false;
        FijiArchipelago.debug("Scheduler: Got process finished for " + process.getID());
        this.futureLock.lock();
        this.queueLock.lock();
        FijiArchipelago.debug("Scheduler: process finished: got locks");
        if (this.runningProcesses.remove(process.getID()) != null) {
            ArchipelagoFuture<?> future = this.futures.remove(process.getID());
            this.nRunningJobs.set(this.runningProcesses.size());
            FijiArchipelago.debug("Scheduler: process finished: found process in map");
            if (future != null) {
                FijiArchipelago.debug("Scheduler: process finished: found future");
                try {
                    future.finish(process);
                    FijiArchipelago.debug("Scheduler: process finished: finished future");
                    ok = true;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            this.allProcesses.remove(process.getID());
        }
        FijiArchipelago.debug("Scheduler: process finished: releasing locks and finishing");
        this.queueLock.unlock();
        this.futureLock.unlock();
        return ok;
    }

    public void error(long id, Throwable t) {
        this.futureLock.lock();
        ArchipelagoFuture<?> future = this.futures.remove(id);
        if (future != null) {
            this.queueLock.lock();
            this.runningProcesses.remove(id);
            this.nRunningJobs.set(this.runningProcesses.size());
            this.allProcesses.remove(id);
            this.queueLock.unlock();
            future.finish(t);
        }
        this.futureLock.unlock();
    }

    public int numRunningJobs() {
        return this.nRunningJobs.get();
    }

    public int numQueuedJobs() {
        return this.nQueuedJobs.get();
    }

    public <T> ArchipelagoFuture<T> queueNormal(Callable<T> callable, float np, boolean f) {
        return this.queue(callable, np, f, this.normalQueue);
    }

    public <T> ArchipelagoFuture<T> queuePriority(Callable<T> callable, float np, boolean f) {
        return this.queue(callable, np, f, this.priorityQueue);
    }

    public boolean reschedule(ProcessManager pm) {
        boolean ok = false;
        this.queueLock.lock();
        if (this.runningProcesses.get(pm.getID()).equals(pm)) {
            this.runningProcesses.remove(pm.getID());
            this.nRunningJobs.set(this.runningProcesses.size());
            this.allProcesses.remove(pm.getID());
            ok = true;
        }
        this.queueLock.unlock();
        if (ok) {
            ok = this.queue(pm, this.priorityQueue);
        }
        return ok;
    }

    public ClusterNode getNode(ProcessManager pm) {
        return this.cluster.getNode(pm.getRunningOn());
    }

    public synchronized boolean cancelJob(long id, boolean force) {
        this.futureLock.lock();
        this.schedulerLock.lock();
        this.queueLock.lock();
        ProcessManager pm = this.allProcesses.get(id);
        if (pm == null) {
            this.queueLock.unlock();
            this.schedulerLock.unlock();
            this.futureLock.unlock();
            return false;
        }
        if (this.normalQueue.remove(pm) || this.priorityQueue.remove(pm) || this.internalNormalQueue.remove(pm) || this.internalPriorityQueue.remove(pm)) {
            this.updateQueueSize();
            this.allProcesses.remove(id);
            this.queueLock.unlock();
            this.schedulerLock.unlock();
            this.futureLock.unlock();
            return true;
        }
        this.schedulerLock.unlock();
        if (force && this.runningProcesses.remove(id) != null) {
            ClusterNode runningOn = this.cluster.getNode(pm.getRunningOn());
            ArchipelagoFuture<?> future = this.futures.remove(id);
            future.finish(new Exception("Cancelled"));
            this.futureLock.unlock();
            this.nRunningJobs.set(this.runningProcesses.size());
            this.allProcesses.remove(id);
            this.queueLock.unlock();
            if (runningOn != null) {
                runningOn.cancelJob(id);
            }
            return true;
        }
        this.futureLock.unlock();
        this.queueLock.unlock();
        return false;
    }

    @Override
    public void run() {
        ProcessManagerCoreComparator comparator = new ProcessManagerCoreComparator();
        LinkedList<ClusterNode> nodeList = new LinkedList<ClusterNode>();
        while (this.running.get()) {
            block9: {
                ArrayList<ClusterNode> removeList = new ArrayList<ClusterNode>();
                Scheduler.verboseDebug("Scheduler: run acquiring scheduler lock");
                this.schedulerLock.lock();
                Scheduler.verboseDebug("Scheduler: run got it");
                Set<ClusterNode> currentNodes = this.cluster.getNodeCoordinator().getAvailableNodes();
                for (ClusterNode node : nodeList) {
                    if (currentNodes.contains(node)) continue;
                    removeList.add(node);
                }
                nodeList.removeAll(removeList);
                for (ClusterNode node : currentNodes) {
                    if (nodeList.contains(node)) continue;
                    nodeList.addFirst(node);
                }
                Scheduler.verboseDebug("Scheduler: " + nodeList.size() + " nodes available");
                comparator.setThreadCount(this.cluster.getMaxThreads());
                Scheduler.verboseDebug("Scheduler: run acquiring queue lock");
                this.queueLock.lock();
                Scheduler.verboseDebug("Scheduler: run got it");
                this.okToSleep.set(false);
                if (!this.priorityQueue.isEmpty()) {
                    this.internalPriorityQueue.addAll(this.priorityQueue);
                    this.priorityQueue.clear();
                    Collections.sort(this.internalPriorityQueue, comparator);
                }
                if (!this.normalQueue.isEmpty()) {
                    this.internalNormalQueue.addAll(this.normalQueue);
                    this.normalQueue.clear();
                    Collections.sort(this.internalNormalQueue, comparator);
                }
                this.updateQueueSize();
                Scheduler.verboseDebug("Scheduler: run releasing queue lock");
                this.queueLock.unlock();
                Scheduler.verboseDebug("Scheduler: internal queues have " + (this.internalNormalQueue.size() + this.internalPriorityQueue.size()) + " jobs");
                if (!nodeList.isEmpty()) {
                    this.doSubmit(this.internalPriorityQueue, nodeList);
                    this.doSubmit(this.internalNormalQueue, nodeList);
                }
                Scheduler.verboseDebug("Scheduler: run releasing scheduler lock");
                this.schedulerLock.unlock();
                if (!this.okToSleep.getAndSet(false)) {
                    try {
                        Scheduler.verboseDebug("Scheduler: run going to sleep");
                        this.ateAnApple.set(true);
                        Thread.sleep(this.pauseTime.get());
                        this.ateAnApple.set(false);
                        Scheduler.verboseDebug("Scheduler: run awoke");
                    }
                    catch (InterruptedException ie) {
                        Scheduler.verboseDebug("Scheduler: run poked");
                        this.ateAnApple.set(false);
                        if (this.running.get()) break block9;
                        FijiArchipelago.log("Scheduler: finished. Ending");
                        FijiArchipelago.debug("Scheduler: finished. Ending");
                        return;
                    }
                }
            }
            Scheduler.verboseDebug("Scheduler: end of run loop");
        }
    }

    @Override
    public void start() {
        this.running.set(true);
        super.start();
    }

    public void close() {
        this.running.set(false);
        this.wake();
        this.queueLock.lock();
        this.remainingProcessManagers.addAll(this.normalQueue);
        this.remainingProcessManagers.addAll(this.priorityQueue);
        this.normalQueue.clear();
        this.priorityQueue.clear();
        this.queueLock.unlock();
        this.schedulerLock.lock();
        this.remainingProcessManagers.addAll(this.internalNormalQueue);
        this.remainingProcessManagers.addAll(this.internalPriorityQueue);
        this.internalNormalQueue.clear();
        this.internalPriorityQueue.clear();
        this.schedulerLock.unlock();
        super.interrupt();
    }

    public void poke() {
        this.wake();
    }

    public synchronized ArrayList<ProcessManager<?>> getRemainingJobs() {
        return new ArrayList(this.remainingProcessManagers);
    }
}

