/*
 * Decompiled with CFR 0.152.
 */
package fiji.util;

import fiji.tool.AbstractTool;
import fiji.tool.ToolWithOptions;
import fiji.util.ArrowOptionPanel;
import fiji.util.ArrowShape;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class ArrowTool
extends AbstractTool
implements ActionListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
ToolWithOptions {
    private ArrowShape arrow;
    private BasicStroke stroke = new BasicStroke(1.0f, 0, 0);
    private double drag_tolerance;
    private double start_X;
    private double start_Y;
    private double end_X;
    private double end_Y;
    private double start_drag_X;
    private double start_drag_Y;
    private ImagePlus imp;
    private ImageCanvas canvas;
    private InteractionStatus status;

    public void run(String arg) {
        this.arrow = new ArrowShape();
        this.imp = WindowManager.getCurrentImage();
        Roi roi = null;
        if (this.imp != null) {
            roi = this.imp.getRoi();
            this.canvas = this.imp.getCanvas();
        }
        if (roi != null && roi instanceof Line) {
            Line line = (Line)roi;
            this.arrow.setStartPoint(new Point2D.Double(line.x1d, line.y1d));
            this.arrow.setEndPoint(new Point2D.Double(line.x2d, line.y2d));
            ShapeRoi arrow_roi = new ShapeRoi((Shape)this.arrow);
            ImageProcessor ip = this.imp.getProcessor();
            ip.fill((Roi)arrow_roi);
            ip.draw((Roi)arrow_roi);
        } else {
            super.run(arg);
            this.drag_tolerance = this.arrow.getLength();
            this.status = InteractionStatus.NO_ARROW;
        }
    }

    public String getToolName() {
        return "Arrow";
    }

    public String getToolIcon() {
        return "C000P11aa8ceec8aa";
    }

    @Override
    public void mousePressed(MouseEvent e) {
        ImageCanvas source = (ImageCanvas)e.getSource();
        if (source != this.canvas) {
            ImageWindow window = (ImageWindow)source.getParent();
            this.imp = window.getImagePlus();
            this.canvas = source;
            Roi current_roi = this.imp.getRoi();
            if (current_roi == null || !(current_roi instanceof ArrowShapeRoi)) {
                this.status = InteractionStatus.NO_ARROW;
                this.arrow = new ArrowShape();
            } else {
                ArrowShapeRoi arrow_roi = (ArrowShapeRoi)current_roi;
                this.arrow = arrow_roi.getArrow();
                this.stroke = arrow_roi.getStroke();
                this.start_X = this.arrow.getStartPoint().getX();
                this.start_Y = this.arrow.getStartPoint().getY();
                this.end_X = this.arrow.getEndPoint().getX();
                this.end_Y = this.arrow.getEndPoint().getY();
                this.status = InteractionStatus.FREE;
            }
        }
        double x = this.canvas.offScreenXD(e.getX());
        double y = this.canvas.offScreenYD(e.getY());
        if (this.status == InteractionStatus.NO_ARROW) {
            this.start_X = x;
            this.start_Y = y;
            this.status = InteractionStatus.FREE;
        } else {
            double dist_to_line = this.distanceToLine(x, y);
            double dist_to_arrowhead = this.distanceToArrowHead(x, y);
            double dist_to_arrowbase = this.distanceToArrowBase(x, y);
            if (dist_to_arrowhead < this.drag_tolerance) {
                this.status = InteractionStatus.DRAGGING_ARROW_HEAD;
            } else if (dist_to_arrowbase < this.drag_tolerance) {
                this.status = InteractionStatus.DRAGGING_ARROW_BASE;
            } else if (dist_to_line < this.drag_tolerance) {
                this.status = InteractionStatus.DRAGGING_LINE;
                this.start_drag_X = x;
                this.start_drag_Y = y;
            } else {
                this.status = InteractionStatus.FREE;
                this.start_X = x;
                this.start_Y = y;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        double x = this.canvas.offScreenXD(e.getX());
        double y = this.canvas.offScreenYD(e.getY());
        int modifiers = e.getModifiersEx();
        switch (this.status) {
            case DRAGGING_ARROW_HEAD: 
            case FREE: {
                if ((modifiers & 0x40) == 64) {
                    double alpha = Math.atan2(y - this.start_Y, x - this.start_X);
                    if (alpha < 0.39269908169872414 && alpha >= -0.39269908169872414 || alpha >= 2.748893571891069 || alpha < -2.748893571891069) {
                        this.end_X = x;
                        this.end_Y = this.start_Y;
                        break;
                    }
                    if (alpha >= 0.39269908169872414 && alpha < 1.1780972450961724 || alpha < -1.9634954084936207 && alpha >= -2.748893571891069) {
                        double proj = x - this.start_X + y - this.start_Y;
                        this.end_X = this.start_X + proj / 2.0;
                        this.end_Y = this.start_Y + proj / 2.0;
                        break;
                    }
                    if (alpha >= 1.1780972450961724 && alpha < 1.9634954084936207 || alpha < -1.1780972450961724 && alpha >= -1.9634954084936207) {
                        this.end_X = this.start_X;
                        this.end_Y = y;
                        break;
                    }
                    double proj = -x + this.start_X + y - this.start_Y;
                    this.end_X = this.start_X - proj / 2.0;
                    this.end_Y = this.start_Y + proj / 2.0;
                    break;
                }
                this.end_X = x;
                this.end_Y = y;
                break;
            }
            case DRAGGING_ARROW_BASE: {
                this.start_X = x;
                this.start_Y = y;
                break;
            }
            case DRAGGING_LINE: {
                double dx = x - this.start_drag_X;
                double dy = y - this.start_drag_Y;
                this.start_X += dx;
                this.start_Y += dy;
                this.end_X += dx;
                this.end_Y += dy;
                this.start_drag_X = x;
                this.start_drag_Y = y;
            }
        }
        this.arrow.setStartPoint(new Point2D.Double(this.start_X, this.start_Y));
        this.arrow.setEndPoint(new Point2D.Double(this.end_X, this.end_Y));
        this.paint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        double x = this.canvas.offScreenXD(e.getX());
        double y = this.canvas.offScreenYD(e.getY());
        if (this.status != InteractionStatus.DRAGGING_ARROW_BASE && Math.abs(this.start_X - x) < 0.01 && Math.abs(this.start_Y - y) < 0.01) {
            this.imp.killRoi();
            this.status = InteractionStatus.NO_ARROW;
        } else {
            this.status = InteractionStatus.FREE;
            this.handleRecording();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double x = this.canvas.offScreenXD(e.getX());
        double y = this.canvas.offScreenYD(e.getY());
        double dist_to_line = this.distanceToLine(x, y);
        double dist_to_arrowhead = this.distanceToArrowHead(x, y);
        double dist_to_arrowbase = this.distanceToArrowBase(x, y);
        if (!e.isShiftDown()) {
            MouseWheelListener[] listeners;
            for (MouseWheelListener listener : listeners = ((Component)e.getSource()).getParent().getMouseWheelListeners()) {
                listener.mouseWheelMoved(e);
            }
            return;
        }
        if (e.isControlDown()) {
            if (dist_to_arrowhead < this.drag_tolerance || dist_to_arrowbase < this.drag_tolerance || dist_to_line < this.drag_tolerance) {
                ArrowShape.ArrowStyle style = this.arrow.getStyle();
                int style_index = style.ordinal();
                style_index += e.getWheelRotation();
                while (style_index < 0) {
                    style_index += ArrowShape.ArrowStyle.values().length;
                }
                while (style_index > ArrowShape.ArrowStyle.values().length - 1) {
                    style_index -= ArrowShape.ArrowStyle.values().length;
                }
                this.arrow.setStyle(ArrowShape.ArrowStyle.values()[style_index]);
                this.paint();
            }
        } else if (dist_to_arrowhead < this.drag_tolerance) {
            this.arrow.setLength(Math.max(0.0, this.arrow.getLength() + (double)e.getWheelRotation()));
            this.paint();
            e.consume();
        } else if (dist_to_arrowbase < this.drag_tolerance || dist_to_line < this.drag_tolerance) {
            this.stroke = new BasicStroke(Math.max(0.0f, this.stroke.getLineWidth() + (float)e.getWheelRotation()), 0, 0);
            this.paint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void showOptionDialog() {
        final ArrowTool current_instance = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArrowOptionPanel inst = ArrowTool.this.status == InteractionStatus.NO_ARROW ? new ArrowOptionPanel() : new ArrowOptionPanel(ArrowTool.this.arrow, ArrowTool.this.stroke);
                inst.setLocationRelativeTo(null);
                inst.setVisible(true);
                inst.addActionListener(current_instance);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrowOptionPanel panel = (ArrowOptionPanel)e.getSource();
        this.arrow.setLength(panel.getLength());
        this.arrow.setStyle(panel.getStyle());
        this.stroke = panel.getStroke();
        this.paint();
    }

    protected void handleRecording() {
        if (!Recorder.record) {
            return;
        }
        Point2D start = this.arrow.getStartPoint();
        Point2D end = this.arrow.getEndPoint();
        Recorder.record((String)"call", (String)(this.getClass().getName() + ".select\", \"" + (Object)((Object)this.arrow.getStyle()) + "\", \"" + start.getX() + "\", \"" + start.getY() + "\", \"" + end.getX() + "\", \"" + end.getY() + "\", \"" + this.stroke.getLineWidth() + "\", \"" + this.arrow.getLength()));
    }

    public static void select(String style, String x1, String y1, String x2, String y2, String width, String headLength) {
        ArrowTool.select(ArrowShape.ArrowStyle.valueOf(style), Double.parseDouble(x1), Double.parseDouble(y1), Double.parseDouble(x2), Double.parseDouble(y2), Float.parseFloat(width), Double.parseDouble(headLength));
    }

    public static void select(ArrowShape.ArrowStyle style, double x1, double y1, double x2, double y2, float width, double headLength) {
        IJ.getImage().setRoi(ArrowTool.makeRoi(style, x1, y1, x2, y2, width, headLength));
    }

    public static Roi makeRoi(ArrowShape.ArrowStyle style, double x1, double y1, double x2, double y2, float width, double headLength) {
        ArrowShape arrow = new ArrowShape(style, headLength);
        arrow.setStartPoint(new Point2D.Double(x1, y1));
        arrow.setEndPoint(new Point2D.Double(x2, y2));
        BasicStroke stroke = new BasicStroke(width, 0, 0);
        return new ArrowShapeRoi(arrow, stroke);
    }

    private void paint() {
        if (this.status != InteractionStatus.NO_ARROW) {
            ArrowShapeRoi roi = new ArrowShapeRoi(this.arrow, this.stroke);
            this.imp.setRoi((Roi)roi);
            this.drag_tolerance = 0.5 * Math.max(this.arrow.getLength(), (double)this.stroke.getLineWidth());
        }
    }

    private double distanceToLine(double x, double y) {
        double Ax = x - this.start_X;
        double Ay = y - this.start_Y;
        double Bx = x - this.end_X;
        double By = y - this.end_Y;
        double Lx = this.end_X - this.start_X;
        double Ly = this.end_Y - this.start_Y;
        double al = Ax * Lx + Ay * Ly;
        double bl = Bx * Lx + By * Ly;
        if (al < 0.0 || bl > 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double a_square = Ax * Ax + Ay * Ay;
        double b_square = Bx * Bx + By * By;
        double l = Math.sqrt(Lx * Lx + Ly * Ly);
        double h = Math.sqrt(a_square - al * al / l / l) + Math.sqrt(b_square - bl * bl / l / l);
        return h / 2.0;
    }

    private double distanceToArrowHead(double x, double y) {
        double dx = x - this.end_X;
        double dy = y - this.end_Y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private double distanceToArrowBase(double x, double y) {
        double dx = x - this.start_X;
        double dy = y - this.start_Y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private static class ArrowShapeRoi
    extends ShapeRoi {
        private static final long serialVersionUID = 1L;
        private ArrowShape arrow;
        private BasicStroke stroke;

        public ArrowShapeRoi(ArrowShape _arrow, BasicStroke _stroke) {
            super((Shape)_arrow);
            Shape out_lineshape = _stroke.createStrokedShape(_arrow);
            this.or(new ShapeRoi(out_lineshape));
            this.arrow = _arrow;
            this.stroke = _stroke;
        }

        public void draw(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.draw((Graphics)g2);
        }

        public ArrowShape getArrow() {
            return this.arrow;
        }

        public BasicStroke getStroke() {
            return this.stroke;
        }
    }

    private static enum InteractionStatus {
        NO_ARROW,
        FREE,
        DRAGGING_ARROW_HEAD,
        DRAGGING_ARROW_BASE,
        DRAGGING_LINE;

    }
}

