/*
 * Decompiled with CFR 0.152.
 */
package jRenderer3D;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import jRenderer3D.Lut;
import jRenderer3D.Misc;
import jRenderer3D.Transform;

class Volume {
    ImagePlus imp;
    ImageProcessor ip;
    private int widthX;
    private int heightY;
    private int depthZ;
    private int widthXm1;
    private int heightYm1;
    private int depthZm1;
    int[][] volumeLimits = new int[8][3];
    int[][] cornerT = new int[8][3];
    double a = 0.0;
    double b = 1.0;
    private double min;
    private double max;
    double oldMin;
    double oldMax;
    boolean firstTime = true;
    private double zAspect = 1.0;
    private byte[][][] data3D;
    private int cutDist = -1000;
    private Lut lut;
    private int[] bufferPixels;
    private double[] zbufferPixels;
    private int bufferWidth;
    private int bufferHeight;
    private Transform tr;
    private int drawMode;
    private int threshold;
    private int dotsDeltaX = 1;
    private int dotsDeltaY = 1;
    private int dotsDeltaZ = 1;
    private int renderDepth = 6;

    protected Volume(ImagePlus imp) {
        this.imp = imp;
        this.ip = imp.getProcessor();
        this.widthX = imp.getWidth();
        this.heightY = imp.getHeight();
        this.depthZ = imp.getStackSize();
        this.volumeLimits[0][0] = 0;
        this.volumeLimits[0][1] = 0;
        this.volumeLimits[0][2] = 0;
        this.volumeLimits[1][0] = 0;
        this.volumeLimits[1][1] = this.heightY;
        this.volumeLimits[1][2] = this.depthZ;
        this.volumeLimits[2][0] = this.widthX;
        this.volumeLimits[2][1] = 0;
        this.volumeLimits[2][2] = this.depthZ;
        this.volumeLimits[3][0] = this.widthX;
        this.volumeLimits[3][1] = this.heightY;
        this.volumeLimits[3][2] = 0;
        this.volumeLimits[4][0] = 0;
        this.volumeLimits[4][1] = 0;
        this.volumeLimits[4][2] = this.depthZ;
        this.volumeLimits[5][0] = 0;
        this.volumeLimits[5][1] = this.heightY;
        this.volumeLimits[5][2] = 0;
        this.volumeLimits[6][0] = this.widthX;
        this.volumeLimits[6][1] = 0;
        this.volumeLimits[6][2] = 0;
        this.volumeLimits[7][0] = this.widthX;
        this.volumeLimits[7][1] = this.heightY;
        this.volumeLimits[7][2] = this.depthZ;
        this.widthXm1 = this.widthX - 1;
        this.heightYm1 = this.heightY - 1;
        this.depthZm1 = this.depthZ - 1;
        this.data3D = new byte[this.depthZ][this.heightY][this.widthX];
        this.getMinMax();
        this.init();
    }

    protected void setBuffers(int[] bufferPixels, double[] zbufferPixels, int bufferWidth, int bufferHeight) {
        this.bufferPixels = bufferPixels;
        this.zbufferPixels = zbufferPixels;
        this.bufferWidth = bufferWidth;
        this.bufferHeight = bufferHeight;
    }

    protected void setTransform(Transform transform) {
        this.tr = transform;
    }

    private boolean getMinMax() {
        this.min = this.ip.getMin();
        this.max = this.ip.getMax();
        Calibration cal = this.imp.getCalibration();
        if (cal != null && cal.calibrated()) {
            this.min = cal.getCValue((int)this.min);
            this.max = cal.getCValue((int)this.max);
            double[] coef = cal.getCoefficients();
            if (coef != null) {
                this.a = coef[0];
                this.b = coef[1];
            }
        }
        if (this.firstTime) {
            if (this.zAspect == 1.0) {
                this.zAspect = (float)(cal.pixelDepth / cal.pixelWidth);
            }
            if (this.zAspect == 0.0) {
                this.zAspect = 1.0;
            }
            this.lut = new Lut();
            this.lut.readLut(this.imp);
            this.oldMin = this.min;
            this.oldMax = this.max;
            this.firstTime = false;
        }
        boolean changed = this.oldMin != this.min || this.oldMax != this.max;
        this.oldMin = this.min;
        this.oldMax = this.max;
        return changed;
    }

    private void init() {
        int val;
        int x;
        int y;
        int pos;
        Object[] pixels;
        int z;
        float scale;
        ImageStack stack = this.imp.getStack();
        int bitDepth = this.imp.getBitDepth();
        if (bitDepth == 8) {
            scale = (float)(255.0 / (this.max - this.min));
            for (z = 0; z < this.depthZ; ++z) {
                IJ.showStatus((String)("Reading stack, slice: " + z + "/" + this.depthZ));
                IJ.showProgress((double)(3.0 * (double)z / (double)(4 * this.depthZ)));
                pixels = (byte[])stack.getPixels(z + 1);
                pos = 0;
                for (y = 0; y < this.heightY; ++y) {
                    for (x = 0; x < this.widthX; ++x) {
                        val = 0xFF & pixels[pos++];
                        if ((float)(val = (int)(((double)val - this.min) * (double)scale)) < 0.0f) {
                            val = 0;
                        }
                        if (val > 255) {
                            val = 255;
                        }
                        this.data3D[z][y][x] = (byte)(0xFF & val);
                    }
                }
            }
        }
        if (bitDepth == 16) {
            scale = (float)(255.0 / (this.max - this.min));
            for (z = 0; z < this.depthZ; ++z) {
                IJ.showStatus((String)("Reading stack, slice: " + z + "/" + this.depthZ));
                IJ.showProgress((double)(3.0 * (double)z / (double)(4 * this.depthZ)));
                pixels = (short[])stack.getPixels(z + 1);
                pos = 0;
                for (y = 0; y < this.heightY; ++y) {
                    for (x = 0; x < this.widthX; ++x) {
                        int n = pos++;
                        val = (int)((double)(0xFFFF & pixels[n]) * this.b + this.a - this.min);
                        if ((float)val < 0.0f) {
                            val = 0;
                        }
                        if ((val = (int)((float)val * scale)) > 255) {
                            val = 255;
                        }
                        this.data3D[z][y][x] = (byte)val;
                    }
                }
            }
        }
        if (bitDepth == 32) {
            scale = (float)(255.0 / (this.max - this.min));
            for (z = 0; z < this.depthZ; ++z) {
                IJ.showStatus((String)("Reading stack, slice: " + z + "/" + this.depthZ));
                IJ.showProgress((double)(3.0 * (double)z / (double)(4 * this.depthZ)));
                pixels = (float[])stack.getPixels(z + 1);
                pos = 0;
                for (y = 0; y < this.heightY; ++y) {
                    for (x = 0; x < this.widthX; ++x) {
                        int ivalue;
                        int n = pos++;
                        float value = (float)((double)pixels[n] - this.min);
                        if (value < 0.0f) {
                            value = 0.0f;
                        }
                        if ((ivalue = (int)(value * scale)) > 255) {
                            ivalue = 255;
                        }
                        this.data3D[z][y][x] = (byte)ivalue;
                    }
                }
            }
        }
        IJ.showProgress((double)1.0);
        IJ.showStatus((String)"");
    }

    private void volumeDotsOrig() {
        int[] v = new int[3];
        double step = (double)this.dotsDeltaX / ((double)this.widthX - 1.0);
        for (int z = 0; z < this.data3D.length; z += this.dotsDeltaZ) {
            v[2] = z;
            byte[][] datay = this.data3D[z];
            for (int y = 0; y < datay.length; y += this.dotsDeltaY) {
                v[1] = y;
                byte[] datax = datay[y];
                v[0] = 0;
                this.tr.xyzPos(v);
                double x1 = this.tr.X;
                double y1 = this.tr.Y;
                double z1 = this.tr.Z;
                v[0] = datax.length - 1;
                this.tr.xyzPos(v);
                double dx = (this.tr.X - x1) * step;
                double dy = (this.tr.Y - y1) * step;
                double dz = (this.tr.Z - z1) * step;
                for (int x = 0; x < this.widthX; x += this.dotsDeltaX) {
                    double z_;
                    int val = 0xFF & datax[x];
                    if (val >= this.threshold && (z_ = z1) > (double)this.cutDist) {
                        int pos;
                        int x_ = (int)x1;
                        int y_ = (int)y1;
                        if (x_ >= 0 && y_ >= 0 && x_ < this.bufferWidth && y_ < this.bufferHeight && z_ < this.zbufferPixels[pos = y_ * this.bufferWidth + x_]) {
                            this.zbufferPixels[pos] = z_;
                            this.bufferPixels[pos] = val + 1;
                        }
                    }
                    z1 += dz;
                    y1 += dy;
                    x1 += dx;
                }
            }
        }
        for (int i = this.bufferPixels.length - 1; i >= 0; --i) {
            int val = this.bufferPixels[i];
            if (val > 255) {
                val = 255;
            }
            if (val <= 0) continue;
            this.bufferPixels[i] = this.lut.colors[val];
        }
    }

    private void volumeDots() {
        int[] v = new int[3];
        for (int z = 0; z < this.data3D.length; z += this.dotsDeltaZ) {
            v[2] = z;
            byte[][] datay = this.data3D[z];
            for (int y = 0; y < datay.length; y += this.dotsDeltaY) {
                v[1] = y;
                byte[] datax = datay[y];
                for (int x = 0; x < this.widthX; x += this.dotsDeltaX) {
                    int pos;
                    v[0] = x;
                    this.tr.xyzPos(v);
                    double x1 = this.tr.X;
                    double y1 = this.tr.Y;
                    double z1 = this.tr.Z;
                    int val = 0xFF & datax[x];
                    if (val < this.threshold || !(z1 > (double)this.cutDist)) continue;
                    int x_ = (int)x1;
                    int y_ = (int)y1;
                    if (x_ < 0 || y_ < 0 || x_ >= this.bufferWidth || y_ >= this.bufferHeight || !(z1 < this.zbufferPixels[pos = y_ * this.bufferWidth + x_])) continue;
                    this.zbufferPixels[pos] = z1;
                    this.bufferPixels[pos] = this.lut.colors[val];
                }
            }
        }
    }

    private void volumeSliceNearestNeighbor() {
        int xMin = this.bufferWidth - 1;
        int xMax = 0;
        int yMin = this.bufferHeight - 1;
        int yMax = 0;
        for (int i = 0; i < 8; ++i) {
            int yi;
            this.tr.xyzPos(this.volumeLimits[i]);
            int xi = (int)this.tr.X;
            if (xi < xMin) {
                xMin = xi;
            }
            if (xi > xMax) {
                xMax = xi;
            }
            if ((yi = (int)this.tr.Y) < yMin) {
                yMin = yi;
            }
            if (yi <= yMax) continue;
            yMax = yi;
        }
        xMin = xMin < 0 ? 0 : xMin;
        xMax = xMax >= this.bufferWidth ? this.bufferWidth - 1 : xMax;
        yMin = yMin < 0 ? 0 : yMin;
        yMax = yMax >= this.bufferHeight ? this.bufferHeight - 1 : yMax;
        int[] v = new int[3];
        v[2] = this.cutDist;
        for (int y = yMin; y < yMax; ++y) {
            v[1] = y;
            int posOffset = y * this.bufferWidth;
            for (int x = xMin; x < xMax; ++x) {
                v[0] = x;
                this.tr.invxyzPosf(v);
                double x_ = this.tr.x;
                double y_ = this.tr.y;
                double z_ = this.tr.z;
                if (!(x_ >= 0.0) || !(x_ < (double)this.widthX) || !(y_ >= 0.0) || !(y_ < (double)this.heightY) || !(z_ >= 0.0) || !(z_ < (double)this.depthZ)) continue;
                int val = 0xFF & this.data3D[(int)z_][(int)y_][(int)x_];
                int pos = posOffset + x;
                int v_ = this.cutDist * 20 + 128;
                v_ = Math.min(Math.max(0, v_), 255);
                v_ = 0xFF000000 | v_ << 8;
                this.bufferPixels[pos] = this.lut.colors[val];
                this.zbufferPixels[pos] = this.cutDist;
            }
        }
    }

    private void volumeSliceTrilinear() {
        int xMin = this.bufferWidth - 1;
        int xMax = 0;
        int yMin = this.bufferHeight - 1;
        int yMax = 0;
        for (int i = 0; i < 8; ++i) {
            int yi;
            this.tr.xyzPos(this.volumeLimits[i]);
            int xi = (int)this.tr.X;
            if (xi < xMin) {
                xMin = xi;
            }
            if (xi > xMax) {
                xMax = xi;
            }
            if ((yi = (int)this.tr.Y) < yMin) {
                yMin = yi;
            }
            if (yi <= yMax) continue;
            yMax = yi;
        }
        xMin = xMin < 0 ? 0 : xMin;
        xMax = xMax >= this.bufferWidth ? this.bufferWidth - 1 : xMax;
        yMin = yMin < 0 ? 0 : yMin;
        yMax = yMax >= this.bufferHeight ? this.bufferHeight - 1 : yMax;
        int[] v = new int[3];
        v[2] = this.cutDist;
        for (int y = yMin; y <= yMax; ++y) {
            v[1] = y;
            int posOffset = y * this.bufferWidth;
            for (int x = xMin; x <= xMax; ++x) {
                v[0] = x;
                this.tr.invxyzPosf(v);
                double x_ = this.tr.x;
                double y_ = this.tr.y;
                double z_ = this.tr.z;
                if (!(x_ >= 0.0) || !(x_ < (double)this.widthX) || !(y_ >= 0.0) || !(y_ < (double)this.heightY) || !(z_ >= 0.0) || !(z_ < (double)this.depthZ)) continue;
                int pos = posOffset + x;
                int val = this.trilinear(z_, y_, x_);
                this.bufferPixels[pos] = this.lut.colors[val];
                this.zbufferPixels[pos] = this.cutDist;
            }
        }
    }

    private boolean isInside(int x, int y) {
        int[] p = new int[3];
        p[0] = x;
        p[1] = y;
        if (Misc.inside(p, this.cornerT[0], this.cornerT[1], this.cornerT[4])) {
            return true;
        }
        if (Misc.inside(p, this.cornerT[0], this.cornerT[1], this.cornerT[5])) {
            return true;
        }
        if (Misc.inside(p, this.cornerT[2], this.cornerT[3], this.cornerT[6])) {
            return true;
        }
        if (Misc.inside(p, this.cornerT[2], this.cornerT[3], this.cornerT[7])) {
            return true;
        }
        if (Misc.inside(p, this.cornerT[1], this.cornerT[3], this.cornerT[5])) {
            return true;
        }
        if (Misc.inside(p, this.cornerT[1], this.cornerT[3], this.cornerT[7])) {
            return true;
        }
        if (Misc.inside(p, this.cornerT[0], this.cornerT[2], this.cornerT[4])) {
            return true;
        }
        if (Misc.inside(p, this.cornerT[0], this.cornerT[2], this.cornerT[6])) {
            return true;
        }
        if (Misc.inside(p, this.cornerT[1], this.cornerT[2], this.cornerT[4])) {
            return true;
        }
        if (Misc.inside(p, this.cornerT[1], this.cornerT[2], this.cornerT[7])) {
            return true;
        }
        if (Misc.inside(p, this.cornerT[0], this.cornerT[3], this.cornerT[5])) {
            return true;
        }
        return Misc.inside(p, this.cornerT[0], this.cornerT[3], this.cornerT[6]);
    }

    public synchronized void volumeProjection_trilinear_front() {
        int nd;
        double width = (float)this.widthX - 0.5f;
        double height = (float)this.heightY - 0.5f;
        double depth = (float)this.depthZ - 0.5f;
        this.transformVolumeLimits();
        int xMin = this.bufferWidth - 1;
        int xMax = 0;
        int yMin = this.bufferHeight - 1;
        int yMax = 0;
        int zMin = this.cutDist;
        int zMax = this.cutDist;
        for (int i = 0; i < 8; ++i) {
            int zi;
            int yi;
            this.tr.xyzPos(this.volumeLimits[i]);
            int xi = (int)this.tr.X;
            if (xi < xMin) {
                xMin = xi;
            }
            if (xi > xMax) {
                xMax = xi;
            }
            if ((yi = (int)this.tr.Y) < yMin) {
                yMin = yi;
            }
            if (yi > yMax) {
                yMax = yi;
            }
            if ((zi = (int)this.tr.Z) < zMin) {
                zMin = zi;
            }
            if (zi <= zMax) continue;
            zMax = zi;
        }
        xMin = xMin < 0 ? 0 : xMin;
        xMax = xMax >= this.bufferWidth ? this.bufferWidth - 1 : xMax;
        yMin = yMin < 0 ? 0 : yMin;
        yMax = yMax >= this.bufferHeight ? this.bufferHeight - 1 : yMax;
        int[] v1 = new int[3];
        int[] v2 = new int[3];
        if (this.cutDist > zMin) {
            zMin = this.cutDist;
        }
        if ((nd = zMax - zMin) > 0) {
            float scaleLum = this.renderDepth > 1 ? (float)(this.renderDepth * 255) / ((float)(this.renderDepth - 1) * 255.0f) : 2.0f;
            v1[2] = zMin;
            v2[2] = zMax;
            double nd1 = 1.0 / (double)nd;
            double d_z = (double)(zMax - zMin) * nd1;
            for (int y = yMin; y <= yMax; ++y) {
                v1[1] = v2[1] = y;
                int percent = 100 * (y - yMin) / (yMax - yMin);
                IJ.showStatus((String)("Rendering : " + percent + "%"));
                for (int x = xMin; x <= xMax; ++x) {
                    int val2;
                    int val;
                    if (!this.isInside(x, y)) continue;
                    double z = zMin;
                    int pos = y * this.bufferWidth + x;
                    v1[0] = v2[0] = x;
                    int alpha = 255;
                    int V = 0;
                    int alpha2 = 255;
                    boolean V2 = false;
                    this.tr.invxyzPosf(v1);
                    double xd1 = this.tr.x;
                    double yd1 = this.tr.y;
                    double zd1 = this.tr.z;
                    this.tr.invxyzPosf(v2);
                    double xd2 = this.tr.x;
                    double yd2 = this.tr.y;
                    double zd2 = this.tr.z;
                    double dx = (xd2 - xd1) * nd1;
                    double dy = (yd2 - yd1) * nd1;
                    double dz = (zd2 - zd1) * nd1;
                    int k = 0;
                    for (int n = nd; n >= 0; --n) {
                        z += d_z;
                        if (xd1 >= 0.0 && xd1 < width && yd1 >= 0.0 && yd1 < height && zd1 >= 0.0 && zd1 < depth) {
                            int val3 = this.trilinear(zd1, yd1, xd1);
                            int f = 255 - 10 * Math.abs(val3 - this.threshold);
                            if (f < 0) {
                                f = 0;
                            }
                            if (f > 10) {
                                alpha += f;
                                V += f * 255;
                                if (++k >= this.renderDepth) break;
                            }
                        }
                        xd1 += dx;
                        yd1 += dy;
                        zd1 += dz;
                    }
                    if ((val = (int)(scaleLum * (float)V / (float)alpha)) > 255) {
                        val = 255;
                    }
                    if ((val2 = (int)(scaleLum * (float)V2 / (float)alpha2)) > 255) {
                        val2 = 255;
                    }
                    this.bufferPixels[pos] = this.lut.colors[val];
                    this.zbufferPixels[pos] = z;
                }
            }
        }
        IJ.showStatus((String)"");
    }

    private void volumeProjection_trilinear_back() {
        double width = (float)this.widthX - 0.5f;
        double height = (float)this.heightY - 0.5f;
        double depth = (float)this.depthZ - 0.5f;
        this.transformVolumeLimits();
        int xMin = this.bufferWidth - 1;
        int xMax = 0;
        int yMin = this.bufferHeight - 1;
        int yMax = 0;
        int zMin = 10000;
        int zMax = -10000;
        for (int i = 0; i < 8; ++i) {
            int zi;
            int yi;
            this.tr.xyzPos(this.volumeLimits[i]);
            int xi = (int)this.tr.X;
            if (xi < xMin) {
                xMin = xi;
            }
            if (xi > xMax) {
                xMax = xi;
            }
            if ((yi = (int)this.tr.Y) < yMin) {
                yMin = yi;
            }
            if (yi > yMax) {
                yMax = yi;
            }
            if ((zi = (int)this.tr.Z) < zMin) {
                zMin = zi;
            }
            if (zi <= zMax) continue;
            zMax = zi;
        }
        xMin = xMin < 0 ? 0 : xMin;
        xMax = xMax >= this.bufferWidth ? this.bufferWidth - 1 : xMax;
        yMin = yMin < 0 ? 0 : yMin;
        yMax = yMax >= this.bufferHeight ? this.bufferHeight - 1 : yMax;
        xMin = xMin < 0 ? 0 : xMin;
        xMax = xMax > 511 ? 511 : xMax;
        yMin = yMin < 0 ? 0 : yMin;
        yMax = yMax > 511 ? 511 : yMax;
        int[] v1 = new int[3];
        int[] v2 = new int[3];
        if (this.cutDist < zMin) {
            this.cutDist = zMin;
        }
        int nd = zMax - this.cutDist;
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        int[] vals = new int[zMax - this.cutDist];
        if (nd > 0) {
            v1[2] = this.cutDist;
            v2[2] = zMax;
            double nd1 = 1.0f / (float)nd;
            for (int y = yMin; y <= yMax; ++y) {
                v1[1] = v2[1] = y;
                int percent = 100 * (y - yMin) / (yMax - yMin);
                IJ.showStatus((String)("Rendering : " + percent + "%"));
                for (int x = xMin; x <= xMax; ++x) {
                    if (!this.isInside(x, y)) continue;
                    int pos = y * this.bufferWidth + x;
                    v1[0] = v2[0] = x;
                    int V = 0;
                    this.tr.invxyzPosf(v1);
                    double x1 = this.tr.x;
                    double y1 = this.tr.y;
                    double z1 = this.tr.z;
                    this.tr.invxyzPosf(v2);
                    dx = (this.tr.x - x1) * nd1;
                    dy = (this.tr.y - y1) * nd1;
                    dz = (this.tr.z - z1) * nd1;
                    int k = 0;
                    for (int n = nd; n >= 0; --n) {
                        int val;
                        if (x1 >= 0.0 && x1 < width && y1 >= 0.0 && y1 < height && z1 >= 0.0 && z1 < depth && (val = this.trilinear(z1, y1, x1)) >= this.threshold) {
                            vals[k++] = val;
                            if (k > this.renderDepth) break;
                        }
                        x1 += dx;
                        y1 += dy;
                        z1 += dz;
                    }
                    for (int i = k - 1; i >= 0; --i) {
                        int a = vals[i] - this.threshold + 50;
                        if (a > 255) {
                            a = 255;
                        }
                        V = (a * vals[i] + V * (255 - a)) / 255;
                    }
                    int val = V + 1;
                    if (val > 255) {
                        val = 255;
                    }
                    this.bufferPixels[pos] = this.lut.colors[val];
                    this.zbufferPixels[pos] = (int)this.tr.z;
                }
            }
        }
        IJ.showStatus((String)"");
    }

    private void transformVolumeLimits() {
        for (int i = 0; i < 8; ++i) {
            this.tr.xyzPos(this.volumeLimits[i]);
            this.cornerT[i][0] = (int)this.tr.X;
            this.cornerT[i][1] = (int)this.tr.Y;
            this.cornerT[i][2] = (int)this.tr.Z;
        }
    }

    private int trilinear(double z, double y, double x) {
        int tx = (int)x;
        double dx = x - (double)tx;
        int tx1 = tx < this.widthXm1 ? tx + 1 : tx;
        int ty = (int)y;
        double dy = y - (double)ty;
        int ty1 = ty < this.heightYm1 ? ty + 1 : ty;
        int tz = (int)z;
        double dz = z - (double)tz;
        int tz1 = tz < this.depthZm1 ? tz + 1 : tz;
        int v000 = 0xFF & this.data3D[tz][ty][tx];
        int v001 = 0xFF & this.data3D[tz1][ty][tx];
        int v010 = 0xFF & this.data3D[tz][ty1][tx];
        int v011 = 0xFF & this.data3D[tz1][ty1][tx];
        int v100 = 0xFF & this.data3D[tz][ty][tx1];
        int v101 = 0xFF & this.data3D[tz1][ty][tx1];
        int v110 = 0xFF & this.data3D[tz][ty1][tx1];
        int v111 = 0xFF & this.data3D[tz1][ty1][tx1];
        return (int)((double)(v100 - v000) * dx + (double)(v010 - v000) * dy + (double)(v001 - v000) * dz + (double)(v110 - v100 - v010 + v000) * dx * dy + (double)(v011 - v010 - v001 + v000) * dy * dz + (double)(v101 - v100 - v001 + v000) * dx * dz + (double)(v111 + v100 + v010 + v001 - v110 - v101 - v011 - v000) * dx * dy * dz + (double)v000);
    }

    protected int getWidth() {
        return this.widthX;
    }

    protected int getHeight() {
        return this.heightY;
    }

    protected double getZaspectRatio() {
        return this.zAspect;
    }

    protected void setVolumeDrawMode(int volume_drawMode) {
        this.drawMode = volume_drawMode;
    }

    protected void draw() {
        if (this.drawMode == 20) {
            this.volumeDots();
        } else if (this.drawMode == 21) {
            this.volumeSliceNearestNeighbor();
        } else if (this.drawMode == 22) {
            this.volumeSliceTrilinear();
        } else if (this.drawMode == 20) {
            this.volumeDots();
        } else if (this.drawMode == 25) {
            this.volumeProjection_trilinear_front();
        }
    }

    protected void setVolumeThreshold(int volume_threshold) {
        this.threshold = volume_threshold;
    }

    protected void setVolumeCutDist(int volume_cutDist) {
        this.cutDist = volume_cutDist;
    }

    protected void setVolumeLut(int volume_lutNr) {
        if (this.lut != null) {
            this.lut.setLut(volume_lutNr);
        }
    }

    protected void setVolumeDotsSubsampling(int volume_dotsDeltaX, int volume_dotsDeltaY, int volume_dotsDeltaZ) {
        this.dotsDeltaX = volume_dotsDeltaX;
        this.dotsDeltaY = volume_dotsDeltaY;
        this.dotsDeltaZ = volume_dotsDeltaZ;
    }
}

