/*
 * Decompiled with CFR 0.152.
 */
package bunwarpj;

import bunwarpj.MainDialog;
import bunwarpj.Mask;
import bunwarpj.PointAction;
import bunwarpj.PointToolbar;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class PointHandler
extends Roi {
    private static final long serialVersionUID = 4829296689557078996L;
    private static final int CROSS_HALFSIZE = 5;
    private final Vector<Color> listColors = new Vector();
    private final Vector<Point> listPoints = new Vector(0, 16);
    private int currentPoint = -1;
    private int numPoints = 0;
    private boolean started = false;
    private final Vector<Point> listMaskPoints = new Vector(0, 16);
    private boolean maskClosed = false;
    private ImagePlus imp = null;
    private PointAction pa = null;
    private PointToolbar tb = null;
    private Mask mask = null;
    private MainDialog dialog = null;
    private float hue = 0.0f;
    private float saturation = 0.5f;

    public PointHandler(ImagePlus imp, PointToolbar tb, Mask mask, MainDialog dialog) {
        super(0, 0, imp.getWidth(), imp.getHeight());
        this.imp = imp;
        this.tb = tb;
        this.dialog = dialog;
        this.pa = new PointAction(imp, this, tb, dialog);
        ImageWindow iw = imp.getWindow();
        if (null != iw) {
            ImageCanvas ic = iw.getCanvas();
            iw.removeKeyListener((KeyListener)IJ.getInstance());
            iw.addKeyListener((KeyListener)this.pa);
            ic.removeMouseMotionListener((MouseMotionListener)ic);
            ic.removeMouseListener((MouseListener)ic);
            ic.removeKeyListener((KeyListener)IJ.getInstance());
            ic.addKeyListener((KeyListener)this.pa);
            ic.addMouseListener((MouseListener)this.pa);
            ic.addMouseMotionListener((MouseMotionListener)this.pa);
            this.started = true;
        }
        this.mask = mask;
    }

    public PointHandler(ImagePlus imp) {
        super(0, 0, imp.getWidth(), imp.getHeight());
        this.imp = imp;
        this.tb = null;
        this.dialog = null;
        this.pa = null;
        this.started = true;
        this.mask = null;
    }

    public PointHandler(int width, int height) {
        super(0, 0, width, height);
        this.imp = null;
        this.tb = null;
        this.dialog = null;
        this.pa = null;
        this.started = true;
        this.mask = null;
    }

    public void addMaskPoint(int x, int y) {
        if (this.maskClosed) {
            return;
        }
        Point p = new Point(x, y);
        this.listMaskPoints.addElement(p);
    }

    public void addPoint(int x, int y) {
        Point p = new Point(x, y);
        this.listPoints.addElement(p);
        Color c = Color.getHSBColor(this.hue, this.saturation, 1.0f);
        this.hue += 0.38197f;
        if (this.hue > 1.0f) {
            this.hue -= 1.0f;
        }
        this.saturation += 0.38197f;
        if (this.saturation > 1.0f) {
            this.saturation -= 1.0f;
        }
        this.saturation = 0.5f * this.saturation + 0.5f;
        this.listColors.addElement(c);
        this.currentPoint = this.numPoints++;
    }

    public boolean canAddMaskPoints() {
        return !this.mask.isFromStack();
    }

    public void clearMask() {
        this.listMaskPoints.removeAllElements();
        this.maskClosed = false;
        this.mask.clearMask();
    }

    public void closeMask(int tool) {
        this.listMaskPoints.addElement(this.listMaskPoints.elementAt(0));
        this.maskClosed = true;
        this.mask.setMaskPoints(this.listMaskPoints);
        this.mask.fillMask(tool);
        this.dialog.grayImage(this);
    }

    public void draw(Graphics g) {
        int numberMaskPoints;
        if (this.started) {
            double mag = this.ic.getMagnification();
            int dx = (int)(mag / 2.0);
            int dy = (int)(mag / 2.0);
            for (int k = 0; k < this.numPoints; ++k) {
                Point p = this.listPoints.elementAt(k);
                g.setColor(this.listColors.elementAt(k));
                if (k == this.currentPoint) {
                    if (WindowManager.getCurrentImage() == this.imp) {
                        g.drawLine(this.ic.screenX(p.x - 5 - 1) + dx, this.ic.screenY(p.y - 1) + dy, this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y - 1) + dy);
                        g.drawLine(this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y - 1) + dy, this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y - 5 - 1) + dy);
                        g.drawLine(this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y - 5 - 1) + dy, this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y - 5 - 1) + dy);
                        g.drawLine(this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y - 5 - 1) + dy, this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y - 1) + dy);
                        g.drawLine(this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y - 1) + dy, this.ic.screenX(p.x + 5 + 1) + dx, this.ic.screenY(p.y - 1) + dy);
                        g.drawLine(this.ic.screenX(p.x + 5 + 1) + dx, this.ic.screenY(p.y - 1) + dy, this.ic.screenX(p.x + 5 + 1) + dx, this.ic.screenY(p.y + 1) + dy);
                        g.drawLine(this.ic.screenX(p.x + 5 + 1) + dx, this.ic.screenY(p.y + 1) + dy, this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y + 1) + dy);
                        g.drawLine(this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y + 1) + dy, this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y + 5 + 1) + dy);
                        g.drawLine(this.ic.screenX(p.x + 1) + dx, this.ic.screenY(p.y + 5 + 1) + dy, this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y + 5 + 1) + dy);
                        g.drawLine(this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y + 5 + 1) + dy, this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y + 1) + dy);
                        g.drawLine(this.ic.screenX(p.x - 1) + dx, this.ic.screenY(p.y + 1) + dy, this.ic.screenX(p.x - 5 - 1) + dx, this.ic.screenY(p.y + 1) + dy);
                        g.drawLine(this.ic.screenX(p.x - 5 - 1) + dx, this.ic.screenY(p.y + 1) + dy, this.ic.screenX(p.x - 5 - 1) + dx, this.ic.screenY(p.y - 1) + dy);
                        if (!(1.0 < this.ic.getMagnification())) continue;
                        g.drawLine(this.ic.screenX(p.x - 5) + dx, this.ic.screenY(p.y) + dy, this.ic.screenX(p.x + 5) + dx, this.ic.screenY(p.y) + dy);
                        g.drawLine(this.ic.screenX(p.x) + dx, this.ic.screenY(p.y - 5) + dy, this.ic.screenX(p.x) + dx, this.ic.screenY(p.y + 5) + dy);
                        continue;
                    }
                    g.drawLine(this.ic.screenX(p.x - 5 + 1) + dx, this.ic.screenY(p.y - 5 + 1) + dy, this.ic.screenX(p.x + 5 - 1) + dx, this.ic.screenY(p.y + 5 - 1) + dy);
                    g.drawLine(this.ic.screenX(p.x - 5 + 1) + dx, this.ic.screenY(p.y + 5 - 1) + dy, this.ic.screenX(p.x + 5 - 1) + dx, this.ic.screenY(p.y - 5 + 1) + dy);
                    continue;
                }
                g.drawLine(this.ic.screenX(p.x - 5) + dx, this.ic.screenY(p.y) + dy, this.ic.screenX(p.x + 5) + dx, this.ic.screenY(p.y) + dy);
                g.drawLine(this.ic.screenX(p.x) + dx, this.ic.screenY(p.y - 5) + dy, this.ic.screenX(p.x) + dx, this.ic.screenY(p.y + 5) + dy);
            }
            if (this.updateFullWindow) {
                this.updateFullWindow = false;
                this.imp.draw();
            }
        }
        if ((numberMaskPoints = this.listMaskPoints.size()) != 0) {
            double mag = this.ic.getMagnification();
            int dx = (int)(mag / 2.0);
            int dy = (int)(mag / 2.0);
            int CIRCLE_RADIUS = 2;
            int CIRCLE_DIAMETER = 2 * CIRCLE_RADIUS;
            for (int i = 0; i < numberMaskPoints; ++i) {
                Point p = this.listMaskPoints.elementAt(i);
                g.setColor(Color.yellow);
                g.drawOval(this.ic.screenX(p.x) - CIRCLE_RADIUS + dx, this.ic.screenY(p.y) - CIRCLE_RADIUS + dy, CIRCLE_DIAMETER, CIRCLE_DIAMETER);
                if (i == 0) continue;
                Point previous_p = this.listMaskPoints.elementAt(i - 1);
                g.drawLine(this.ic.screenX(p.x) + dx, this.ic.screenY(p.y) + dy, this.ic.screenX(previous_p.x) + dx, this.ic.screenY(previous_p.y) + dy);
            }
        }
    }

    public int findClosest(int x, int y) {
        if (this.numPoints == 0) {
            return this.currentPoint;
        }
        x = this.ic.offScreenX(x);
        y = this.ic.offScreenY(y);
        Point p = new Point(this.listPoints.elementAt(this.currentPoint));
        double distance = (double)(x - p.x) * (double)(x - p.x) + (double)(y - p.y) * (double)(y - p.y);
        for (int k = 0; k < this.numPoints; ++k) {
            p = this.listPoints.elementAt(k);
            double candidate = (double)(x - p.x) * (double)(x - p.x) + (double)(y - p.y) * (double)(y - p.y);
            if (!(candidate < distance)) continue;
            distance = candidate;
            this.currentPoint = k;
        }
        return this.currentPoint;
    }

    public Point getPoint() {
        return 0 <= this.currentPoint ? this.listPoints.elementAt(this.currentPoint) : null;
    }

    public PointAction getPointAction() {
        return this.pa;
    }

    public int getCurrentPoint() {
        return this.currentPoint;
    }

    public Vector<Point> getPoints() {
        return this.listPoints;
    }

    public void killListeners() {
        ImageWindow iw;
        if (this.imp != null && null != (iw = this.imp.getWindow())) {
            ImageCanvas ic = iw.getCanvas();
            ic.removeKeyListener((KeyListener)this.pa);
            ic.removeMouseListener((MouseListener)this.pa);
            ic.removeMouseMotionListener((MouseMotionListener)this.pa);
            ic.addMouseMotionListener((MouseMotionListener)ic);
            ic.addMouseListener((MouseListener)ic);
            ic.addKeyListener((KeyListener)IJ.getInstance());
        }
    }

    public void movePoint(int x, int y) {
        if (0 <= this.currentPoint) {
            x = this.ic.offScreenX(x);
            y = this.ic.offScreenY(y);
            x = x < 0 ? 0 : x;
            x = this.imp.getWidth() <= x ? this.imp.getWidth() - 1 : x;
            y = y < 0 ? 0 : y;
            y = this.imp.getHeight() <= y ? this.imp.getHeight() - 1 : y;
            this.listPoints.removeElementAt(this.currentPoint);
            Point p = new Point(x, y);
            this.listPoints.insertElementAt(p, this.currentPoint);
        }
    }

    public void nextPoint() {
        this.currentPoint = this.currentPoint == this.numPoints - 1 ? 0 : this.currentPoint + 1;
    }

    public void removePoint() {
        if (0 < this.numPoints) {
            this.listPoints.removeElementAt(this.currentPoint);
            this.listColors.removeElementAt(this.currentPoint);
            --this.numPoints;
        }
        this.currentPoint = this.numPoints - 1;
        if (this.currentPoint < 0) {
            this.tb.setTool(0);
        }
    }

    public void removePoint(int k) {
        if (0 < this.numPoints) {
            this.listPoints.removeElementAt(k);
            this.listColors.removeElementAt(k);
            --this.numPoints;
        }
        this.currentPoint = this.numPoints - 1;
        if (this.currentPoint < 0) {
            this.tb.setTool(0);
        }
    }

    public void removePoints() {
        this.listPoints.removeAllElements();
        this.listColors.removeAllElements();
        this.numPoints = 0;
        this.currentPoint = -1;
        this.tb.setTool(0);
        this.imp.setRoi((Roi)this);
    }

    public void setCurrentPoint(int currentPoint) {
        this.currentPoint = currentPoint;
    }

    public void setTestSourceSet(int set) {
        this.removePoints();
        switch (set) {
            case 1: {
                this.addPoint(11, 11);
                this.addPoint(200, 6);
                this.addPoint(197, 204);
                this.addPoint(121, 111);
                break;
            }
            case 2: {
                this.addPoint(6, 6);
                this.addPoint(202, 7);
                this.addPoint(196, 210);
                this.addPoint(10, 214);
                this.addPoint(120, 112);
                this.addPoint(68, 20);
                this.addPoint(63, 163);
                this.addPoint(186, 68);
            }
        }
    }

    public void setTestTargetSet(int set) {
        this.removePoints();
        switch (set) {
            case 1: {
                this.addPoint(11, 11);
                this.addPoint(185, 15);
                this.addPoint(154, 200);
                this.addPoint(123, 92);
                break;
            }
            case 2: {
                this.addPoint(6, 6);
                this.addPoint(185, 14);
                this.addPoint(154, 200);
                this.addPoint(3, 178);
                this.addPoint(121, 93);
                this.addPoint(67, 14);
                this.addPoint(52, 141);
                this.addPoint(178, 68);
            }
        }
    }

    public void setSecondaryPointHandler(ImagePlus secondaryImp, PointHandler secondaryPh) {
        this.pa.setSecondaryPointHandler(secondaryImp, secondaryPh);
    }
}

