/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.clahe;

import ij.process.ByteProcessor;
import ij.process.ShortProcessor;
import mpicbg.ij.clahe.Apply;
import mpicbg.util.Util;

final class ShortApply
extends Apply<ShortProcessor> {
    protected final short[] ipPixels;

    public ShortApply(ShortProcessor ip, ByteProcessor src, ByteProcessor dst, ByteProcessor mask, int boxXMin, int boxYMin, int boxXMax, int boxYMax) throws Exception {
        super(ip, src, dst, mask, boxXMin, boxYMin, boxXMax, boxYMax);
        this.ipPixels = (short[])ip.getPixels();
    }

    @Override
    public final void apply(int cellXMin, int cellYMin, int cellXMax, int cellYMax) {
        int xMin = Math.max(this.boxXMin, cellXMin);
        int yMin = Math.max(this.boxYMin, cellYMin);
        int xMax = Math.min(this.boxXMax, cellXMax);
        int yMax = Math.min(this.boxYMax, cellYMax);
        int min = (int)((ShortProcessor)this.ip).getMin();
        for (int y = yMin; y < yMax; ++y) {
            int i = y * this.width + xMin;
            for (int x = xMin; x < xMax; ++x) {
                float m = (float)(this.maskPixels[i] & 0xFF) / 255.0f;
                int v = this.ipPixels[i] & 0xFFFF;
                float vSrc = this.srcPixels[i] & 0xFF;
                float a = vSrc == 0.0f ? 1.0f : (float)(this.dstPixels[i] & 0xFF) / vSrc;
                float b = m * (a * (float)(v - min) + (float)min - (float)v) + (float)v;
                this.ipPixels[i] = (short)Math.max(0, Math.min(65535, Util.roundPos(b)));
                ++i;
            }
        }
    }
}

