/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import ij.ImageJ;
import ij.ImagePlus;
import ij.process.ImageProcessor;
import java.util.Arrays;
import mpicbg.ij.TransformMeshMapping;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.CoordinateTransformList;
import mpicbg.models.CoordinateTransformMesh;
import mpicbg.models.TranslationModel2D;

public class PolynomialTransform2D
implements CoordinateTransform {
    private static final long serialVersionUID = 1101543117241957329L;
    protected int order = 0;
    protected double[] a = new double[2];
    protected double[] polTerms = new double[0];

    public static final int orderOf(int numPolTerms) {
        return (int)Math.nextUp(Math.sqrt((double)(2 * numPolTerms) + 0.25) - 1.5);
    }

    public static final int numPolTerms(int order) {
        return (int)Math.round((double)((order + 2) * (order + 1)) * 0.5);
    }

    public void set(double ... a) {
        this.order = PolynomialTransform2D.orderOf(a.length / 2);
        int numPolTerms = PolynomialTransform2D.numPolTerms(this.order);
        this.a = a;
        this.polTerms = new double[numPolTerms - 1];
    }

    protected void populateTerms(double x, double y) {
        if (this.order == 0) {
            return;
        }
        this.polTerms[0] = x;
        this.polTerms[1] = y;
        int o = 2;
        int i = 2;
        while (o <= this.order) {
            for (int p = 0; p < o; ++p) {
                this.polTerms[i + p] = this.polTerms[i + p - o] * x;
            }
            this.polTerms[i + o] = this.polTerms[i - 1] * y;
            i += ++o;
        }
    }

    protected void printTerms() {
        Object[] polTermString = new String[this.polTerms.length];
        if (this.order == 0) {
            System.out.println("No polynomial terms.");
        }
        polTermString[0] = "x";
        polTermString[1] = "y";
        int o = 2;
        int i = 2;
        while (o <= this.order) {
            for (int p = 0; p < o; ++p) {
                polTermString[i + p] = (String)polTermString[i + p - o] + "x";
            }
            polTermString[i + o] = (String)polTermString[i - 1] + "y";
            i += ++o;
        }
        System.out.println(Arrays.toString(polTermString));
    }

    @Override
    public double[] apply(double[] location) {
        double[] copy = (double[])location.clone();
        this.applyInPlace(copy);
        return copy;
    }

    @Override
    public void applyInPlace(double[] location) {
        this.populateTerms(location[0], location[1]);
        location[0] = this.a[0];
        int i = 0;
        while (i < this.polTerms.length) {
            location[0] = location[0] + this.polTerms[i] * this.a[++i];
        }
        int numPolTerms = this.polTerms.length + 1;
        location[1] = this.a[numPolTerms];
        int i2 = 0;
        while (i2 < this.polTerms.length) {
            location[1] = location[1] + this.polTerms[i2] * this.a[++i2 + numPolTerms];
        }
    }

    public static final void main(String ... args) {
        new ImageJ();
        for (int numPolTerms = 0; numPolTerms < 100; ++numPolTerms) {
            System.out.println(numPolTerms + " " + PolynomialTransform2D.orderOf(numPolTerms) + " " + PolynomialTransform2D.numPolTerms(PolynomialTransform2D.orderOf(numPolTerms)));
        }
        ImagePlus imp = new ImagePlus("/tier2/flyTEM/khairy/FOR_STEPHAN/second_order_polynomial_transformation/original_image.tif");
        imp.show();
        PolynomialTransform2D t = new PolynomialTransform2D();
        t.set(67572.7357, 0.97263708, -0.0266434795, -3.08962708E-6, 3.52672467E-6, 1.36924462E-7, 5446.8534, 0.022404762, 0.96120261, -3.3675352E-7, -8.9721973E-7, -5.4985399E-6);
        CoordinateTransformMesh boundsMesh = new CoordinateTransformMesh(t, 64, (double)imp.getWidth(), (double)imp.getHeight());
        double[] min = new double[2];
        double[] max = new double[2];
        boundsMesh.bounds(min, max);
        System.out.println(Arrays.toString(min));
        TranslationModel2D shift = new TranslationModel2D();
        shift.set(-min[0], -min[1]);
        CoordinateTransformList<CoordinateTransform> ctl = new CoordinateTransformList<CoordinateTransform>();
        ctl.add(t);
        ctl.add(shift);
        CoordinateTransformMesh mesh = new CoordinateTransformMesh(ctl, 64, (double)imp.getWidth(), (double)imp.getHeight());
        TransformMeshMapping<CoordinateTransformMesh> mapping = new TransformMeshMapping<CoordinateTransformMesh>(mesh);
        ImageProcessor target = imp.getProcessor().createProcessor(imp.getWidth(), imp.getHeight());
        imp.getProcessor().setInterpolationMethod(1);
        mapping.mapInterpolated(imp.getProcessor(), target);
        new ImagePlus(imp.getTitle() + " warped", target).show();
        t.set(new double[132]);
        t.printTerms();
    }
}

