/*
 * Decompiled with CFR 0.152.
 */
class FFT {
    FFT() {
    }

    public static double[][] fft(double[][] x) {
        int n = x.length;
        if (n == 1) {
            return new double[][]{x[0]};
        }
        if ((n & 1) != 0) {
            throw new RuntimeException("n is not a power of 2");
        }
        double[][] even = new double[n / 2][];
        for (int k = 0; k < n / 2; ++k) {
            even[k] = x[2 * k];
        }
        double[][] q = FFT.fft(even);
        double[][] odd = even;
        for (int k = 0; k < n / 2; ++k) {
            odd[k] = x[2 * k + 1];
        }
        double[][] r = FFT.fft(odd);
        double[][] y = new double[n][2];
        for (int k = 0; k < n / 2; ++k) {
            double kth = (double)(-2 * k) * Math.PI / (double)n;
            double c = Math.cos(kth);
            double s = Math.sin(kth);
            double kr0 = c * r[k][0] - s * r[k][1];
            double kr1 = c * r[k][1] + s * r[k][0];
            y[k][0] = q[k][0] + kr0;
            y[k][1] = q[k][1] + kr1;
            y[k + n / 2][0] = q[k][0] - kr0;
            y[k + n / 2][1] = q[k][1] - kr1;
        }
        return y;
    }

    public static double[][] conjugate(double[][] x) {
        double[][] result = new double[x.length][2];
        for (int i = 0; i < x.length; ++i) {
            result[i][0] = x[i][0];
            result[i][1] = -x[i][1];
        }
        return result;
    }

    public static double[][] divide(double[][] x, double factor) {
        double[][] result = new double[x.length][2];
        for (int i = 0; i < x.length; ++i) {
            result[i][0] = x[i][0] / factor;
            result[i][1] = x[i][1] / factor;
        }
        return result;
    }

    public static double[][] ifft(double[][] x) {
        return FFT.divide(FFT.conjugate(FFT.fft(FFT.conjugate(x))), x.length);
    }

    public static void print(double[][] values) {
        for (int i = 0; i < values.length; ++i) {
            System.out.print(" " + values[i][0] + ";" + values[i][1]);
        }
        System.out.println("");
    }

    public static double[][] multiply(double[][] x, double[][] y) {
        double[][] r = new double[x.length][2];
        for (int i = 0; i < x.length; ++i) {
            r[i][0] = x[i][0] * y[i][0] - x[i][1] * y[i][1];
            r[i][1] = x[i][1] * y[i][0] + x[i][0] * y[i][1];
        }
        return r;
    }

    public static void main(String[] args) {
        double[][] values = new double[][]{{1.0, 2.0}, {3.0, 4.0}, {5.0, 6.0}, {0.0, 1.0}, {0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}};
        double[][] f = new double[][]{{0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}, {0.0, 1.0}, {5.0, 6.0}, {3.0, 4.0}, {1.0, 2.0}};
        double[][] f2 = new double[][]{{1.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}};
        double[][] inv = FFT.fft(values);
        double[][] finv = FFT.fft(f);
        double[][] invinv = FFT.ifft(inv);
        double[][] imul = FFT.multiply(inv, finv);
        double[][] mul = FFT.ifft(imul);
        FFT.print(values);
        FFT.print(inv);
        FFT.print(invinv);
        FFT.print(finv);
        FFT.print(imul);
        FFT.print(mul);
    }
}

