/*
 * Decompiled with CFR 0.152.
 */
import amira.AmiraParameters;
import amira.AmiraTable;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.text.TextPanel;
import ij.util.Tools;
import java.util.ArrayList;

public class Show_Label_Centers
implements PlugInFilter {
    private ImagePlus image;

    public int setup(String arg, ImagePlus img) {
        this.image = img;
        return 3;
    }

    public void run(ImageProcessor ip) {
        GenericDialog gd = new GenericDialog("Show Label Centers");
        AmiraParameters.addAmiraTableList((GenericDialog)gd, (String)"Statistics file");
        gd.addNumericField("Radius", 10.0, 2);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String title = gd.getNextChoice();
        AmiraTable table = (AmiraTable)WindowManager.getFrame((String)title);
        double radius = gd.getNextNumber();
        Show_Label_Centers.calculateCenters(this.image, table, radius).show();
    }

    public static ImagePlus calculateCenters(ImagePlus image, AmiraTable table, double r) {
        double r_sq = r * r;
        Point3D[] centers = Show_Label_Centers.getList(table);
        ImageStack stack = image.getStack();
        Calibration cal = image.getCalibration();
        double pw = cal.pixelWidth;
        double ph = cal.pixelHeight;
        double pd = cal.pixelDepth;
        int w = image.getWidth();
        int h = image.getHeight();
        int d = image.getStackSize();
        ImageStack newStack = new ImageStack(w, h);
        for (int z = 0; z < d; ++z) {
            byte[] b = new byte[w * h];
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int idx = y * w + x;
                    for (int i = 0; i < centers.length; ++i) {
                        if (!Show_Label_Centers.check(centers[i], new Point3D((double)x * pw, (double)y * ph, (double)z * pd), r_sq)) continue;
                        b[idx] = -1;
                    }
                }
            }
            newStack.addSlice("", (ImageProcessor)new ByteProcessor(w, h, b, null));
        }
        ImagePlus ret = new ImagePlus("Centers", newStack);
        ret.setCalibration(cal);
        return ret;
    }

    private static boolean check(Point3D fst, Point3D snd, double r_sq) {
        return (snd.x - fst.x) * (snd.x - fst.x) + (snd.y - fst.y) * (snd.y - fst.y) + (snd.z - fst.z) * (snd.z - fst.z) < r_sq;
    }

    public static Point3D[] getList(AmiraTable table) {
        TextPanel panel = table.getTextPanel();
        int count = panel.getLineCount();
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        for (int i = 1; i < count; ++i) {
            String[] line = Tools.split((String)panel.getLine(i), (String)"\t");
            int voxelCount = Integer.parseInt(line[2]);
            if (voxelCount == 0) continue;
            points.add(new Point3D(Double.parseDouble(line[4]), Double.parseDouble(line[5]), Double.parseDouble(line[6])));
        }
        return points.toArray(new Point3D[0]);
    }

    private static class Point3D {
        private double x;
        private double y;
        private double z;

        public Point3D(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

