/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import landmarks.RigidFromLandmarks;
import util.Overlay_Registered;

public class Rigid_From_Landmarks
extends RigidFromLandmarks
implements PlugIn {
    public void run(String arg) {
        String none;
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.error((String)"Rigid_From_Landmarks: No images are open.");
            return;
        }
        String[] titles = new String[wList.length + 1];
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage((int)wList[i]);
            titles[i] = imp != null ? imp.getTitle() : "";
        }
        titles[wList.length] = none = "*None*";
        GenericDialog gd = new GenericDialog("Rigid Registration from Landmarks");
        gd.addChoice("Template stack:", titles, titles[0]);
        gd.addChoice("Stack to transform:", titles, titles[1]);
        gd.addCheckbox("Allow scaling", true);
        gd.addCheckbox("Overlay result", true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int[] index = new int[]{gd.getNextChoiceIndex(), gd.getNextChoiceIndex()};
        this.setImages(WindowManager.getImage((int)wList[index[0]]), WindowManager.getImage((int)wList[index[1]]));
        this.allowScaling = gd.getNextBoolean();
        boolean overlayResult = gd.getNextBoolean();
        ImagePlus transformed = this.register();
        if (overlayResult) {
            ImagePlus merged = Overlay_Registered.overlayToImagePlus((ImagePlus)this.sourceImages[0], (ImagePlus)transformed);
            merged.setTitle("Registered and Overlayed");
            merged.show();
        } else {
            transformed.show();
        }
    }
}

