/*
 * Decompiled with CFR 0.152.
 */
package leica;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.IOException;
import leica.LeicaSPReader;

public class Leica_SP_Reader
extends LeicaSPReader
implements PlugIn {
    public void run(String arg) {
        if (IJ.versionLessThan((String)"1.18h")) {
            return;
        }
        boolean showIt = (arg == null || arg.trim().equals("")) && !Interpreter.isBatchMode();
        String dir = "";
        String file = "";
        if (arg == null || arg.equals("")) {
            OpenDialog od = new OpenDialog("Leica Tiff", null);
            dir = od.getDirectory();
            file = od.getFileName();
        } else {
            File f = new File(arg.trim());
            dir = f.getParent() + File.separator;
            file = f.getName();
        }
        if (arg == null) {
            return;
        }
        try {
            FileInfo[] fi = this.getFileInfo(dir, file);
            this.nr_channels = fi.length / this.nr_frames;
            this.images = new ImagePlus[this.nr_channels];
            for (int channel = 0; channel < this.nr_channels; ++channel) {
                ImageStack stack = this.openStack(fi, channel);
                if (stack == null) continue;
                int l = channel + 1;
                fi[0].fileName = arg;
                fi[0].directory = dir;
                Calibration cal = new Calibration();
                cal.pixelWidth = fi[0].pixelWidth;
                cal.pixelHeight = fi[0].pixelHeight;
                cal.pixelDepth = fi[0].pixelDepth;
                if (channel == 0) {
                    this.setStack(file + "(channel1)", stack);
                    this.setCalibration(cal);
                    this.setFileInfo(fi[0]);
                }
                this.images[channel] = new ImagePlus(file + " (channel" + l + ")", stack);
                this.images[channel].setCalibration(cal);
                this.images[channel].setFileInfo(fi[0]);
                this.images[channel].setProperty("Info", (Object)this.imageInfo);
                if (!showIt) continue;
                this.images[channel].show();
            }
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.showMessage((String)"Leica SP Reader", (String)msg);
        }
    }
}

