/*
 * Decompiled with CFR 0.152.
 */
package oldsegmenters;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import oldsegmenters.SegmentatorModel;

public class LabelThresholder_
implements PlugInFilter {
    static Mem mem;
    public static int min;
    public static int max;

    public int setup(String arg, ImagePlus imp) {
        return 1;
    }

    public void run(ImageProcessor ip) {
        SegmentatorModel model = new SegmentatorModel(IJ.getImage());
        int currentSlice = model.data.getCurrentSlice();
        ImageProcessor imageData = model.data.getStack().getProcessor(currentSlice);
        ImageProcessor labelData = model.getLabelImagePlus().getStack().getProcessor(currentSlice);
        if (model.getCurrentMaterial() == null) {
            IJ.showMessage((String)"please select a label first");
            return;
        }
        if (model.data.getRoi() == null) {
            IJ.error((String)"You need to have a region of interest selected in order to threshold an area.");
            return;
        }
        LabelThresholder_.threshold(model.data.getRoi(), min, max, imageData, labelData, model.getCurrentMaterial().id);
        model.updateSlice(currentSlice);
    }

    public static void rollback() {
        SegmentatorModel model = new SegmentatorModel(IJ.getImage());
        int currentSlice = model.data.getCurrentSlice();
        if (mem != null) {
            mem.restore();
        }
        model.updateSlice(currentSlice);
    }

    public static void commit() {
        if (mem != null) {
            mem.clear();
        }
    }

    public static void threshold(Roi roi, int min, int max, ImageProcessor imageData, ImageProcessor labelData, int label) {
        mem = new Mem(labelData);
        Rectangle bounds = roi.getBounds();
        for (int x = bounds.x; x <= bounds.x + bounds.width; ++x) {
            for (int y = bounds.y; y <= bounds.y + bounds.height; ++y) {
                if (!roi.contains(x, y) || imageData.get(x, y) < min || imageData.get(x, y) > max) continue;
                mem.rememberPixel(x, y);
                labelData.set(x, y, label);
            }
        }
    }

    static {
        min = 5;
        max = 100;
    }

    static class Mem {
        ImageProcessor data;
        HashMap<Point, Integer> memory = new HashMap();

        public Mem(ImageProcessor data) {
            this.data = data;
        }

        public void rememberPixel(int x, int y) {
            this.memory.put(new Point(x, y), this.data.get(x, y));
        }

        public void restore() {
            for (Point p : this.memory.keySet()) {
                this.data.set(p.x, p.y, this.memory.get(p).intValue());
            }
        }

        public void clear() {
            this.memory.clear();
        }
    }
}

