/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import amira.AmiraTable;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.text.TextPanel;
import ij.util.Tools;
import java.util.ArrayList;
import math3d.Point3d;
import vib.InterpolatedImage;

public class Show_centers
implements PlugInFilter {
    private ImagePlus image;

    public void run(ImageProcessor ip) {
        GenericDialog gd = new GenericDialog("Center Transformation");
        AmiraParameters.addAmiraTableList((GenericDialog)gd, (String)"Statistics");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String titleM = gd.getNextChoice();
        AmiraTable statistics = (AmiraTable)WindowManager.getFrame((String)titleM);
        ImagePlus centers = this.getCenters(statistics);
        centers.show();
        centers.updateAndDraw();
    }

    public int setup(String arg, ImagePlus img) {
        this.image = img;
        return 1;
    }

    public void setImage(ImagePlus image) {
        this.image = image;
    }

    public ImagePlus getCenters(AmiraTable statistics) {
        Point3d[] points = Show_centers.getList(statistics);
        ImagePlus ret = new InterpolatedImage(this.image).cloneDimensionsOnly().getImage();
        ret.setTitle("Centers");
        int w = ret.getWidth();
        int h = ret.getHeight();
        int d = ret.getStackSize();
        Calibration cal = ret.getCalibration();
        for (int z = 0; z < d; ++z) {
            double coordz = Math.abs((double)z * cal.pixelDepth);
            byte[] p = (byte[])ret.getStack().getProcessor(z + 1).getPixels();
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    int index = y * w + x;
                    double coordx = (double)x * cal.pixelWidth;
                    double coordy = (double)y * cal.pixelHeight;
                    Point3d p2 = new Point3d(coordx, coordy, coordz);
                    for (int i = 0; i < points.length; ++i) {
                        if (!(p2.distance2(points[i]) < 200.0)) continue;
                        p[index] = -1;
                    }
                }
            }
        }
        return ret;
    }

    public static Point3d[] getList(AmiraTable table) {
        TextPanel panel = table.getTextPanel();
        int count = panel.getLineCount();
        ArrayList<Point3d> points = new ArrayList<Point3d>();
        for (int i = 1; i < count; ++i) {
            String[] line = Tools.split((String)panel.getLine(i), (String)"\t");
            int voxelCount = Integer.parseInt(line[2]);
            if (voxelCount == 0) continue;
            points.add(new Point3d(Double.parseDouble(line[4]), Double.parseDouble(line[5]), Double.parseDouble(line[6])));
        }
        return points.toArray(new Point3d[0]);
    }
}

