/*
 * Decompiled with CFR 0.152.
 */
package vib.oldregistration;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.io.PrintWriter;
import java.io.StringWriter;
import math3d.JacobiFloat;
import vib.FastMatrix;
import vib.oldregistration.IntensityMap;
import vib.oldregistration.PrincipalComponents;
import vib.transforms.FastMatrixTransform;
import vib.transforms.OrderedTransformations;
import vib.transforms.Threshold;
import vib.transforms.Transform;

public class PCA_Registration
implements PlugIn {
    boolean keepSourceImages = true;
    ImagePlus[] sourceImages = null;

    public void run(String arg) {
        this.chooseStacks();
        this.closeSourceImages();
    }

    public void closeSourceImages() {
        if (!this.keepSourceImages) {
            for (int i = 0; i < this.sourceImages.length; ++i) {
                ImageWindow window = this.sourceImages[i].getWindow();
                if (window == null) continue;
                window.close();
            }
        }
    }

    public Threshold threshold(int[] valueHistogram, float fraction) {
        int i;
        long belowThreshold = 0L;
        boolean threshold = false;
        long totalWithoutEnds = 0L;
        long cumulative = 0L;
        long cumulativeWithoutEnds = 0L;
        for (i = 1; i < 255; ++i) {
            totalWithoutEnds += (long)valueHistogram[i];
        }
        for (i = 0; i < 256; ++i) {
            cumulative += (long)valueHistogram[i];
            if (i != 0 && i != 255) {
                cumulativeWithoutEnds += (long)valueHistogram[i];
            }
            if ((float)cumulativeWithoutEnds >= fraction * (float)totalWithoutEnds) {
                return new Threshold(i, belowThreshold);
            }
            belowThreshold = cumulative;
        }
        return null;
    }

    public Color indexToColor(int index) {
        Color foregroundColor = Toolbar.getForegroundColor();
        Color midColor = new Color(foregroundColor.getRed() / 3, foregroundColor.getGreen() / 3, foregroundColor.getBlue() / 3);
        Color lowColor = new Color(foregroundColor.getRed() / 4, foregroundColor.getGreen() / 4, foregroundColor.getBlue() / 4);
        switch (index) {
            case 0: {
                return lowColor;
            }
            case 1: {
                return midColor;
            }
            case 2: {
                return foregroundColor;
            }
        }
        return null;
    }

    public static void scaleDoubleArray(double[] a, double factor) {
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] * factor;
        }
    }

    public PrincipalComponents doPCA(ImagePlus image, Threshold threshold, boolean drawAxes) {
        try {
            int j;
            int j2;
            double y_scaled;
            double z_scaled;
            int width = image.getWidth();
            int height = image.getHeight();
            int depth = image.getStackSize();
            Calibration calibration = image.getCalibration();
            double x_spacing = 1.0;
            double y_spacing = 1.0;
            double z_spacing = 1.0;
            if (calibration.pixelWidth != 0.0 && calibration.pixelHeight != 0.0 && calibration.pixelDepth != 0.0) {
                x_spacing = 1.0;
                y_spacing = calibration.pixelHeight / calibration.pixelWidth;
                z_spacing = calibration.pixelDepth / calibration.pixelWidth;
            }
            System.out.println("Aspect ratio is: " + x_spacing + ", " + y_spacing + ", " + z_spacing);
            System.out.println("Number below threshold is: " + threshold.belowThreshold);
            int overAndAtThreshold = width * height * depth - (int)threshold.belowThreshold;
            System.out.println("Number over and at threshold is: " + overAndAtThreshold);
            int vectorLength = 3;
            double[] mean = new double[vectorLength];
            double[] sum = new double[vectorLength];
            double[] variance = new double[vectorLength];
            double[] sd = new double[vectorLength];
            int[] n = new int[vectorLength];
            ImageStack stack = image.getStack();
            int i = 0;
            byte[][] data = new byte[depth][];
            for (int z = 0; z < image.getStackSize(); ++z) {
                data[z] = (byte[])stack.getPixels(z + 1);
            }
            for (int z = 0; z < image.getStackSize(); ++z) {
                z_scaled = (double)z * z_spacing;
                for (int y = 0; y < image.getHeight(); ++y) {
                    y_scaled = (double)y * y_spacing;
                    for (int x = 0; x < image.getWidth(); ++x) {
                        double x_scaled = x;
                        byte value = data[z][y * width + x];
                        int value_int = value & 0xFF;
                        if (value_int < threshold.value) continue;
                        sum[0] = sum[0] + x_scaled;
                        sum[1] = sum[1] + y_scaled;
                        sum[2] = sum[2] + z_scaled;
                        ++i;
                    }
                }
            }
            System.out.println("Considered " + i + " points...");
            for (j2 = 0; j2 < vectorLength; ++j2) {
                System.out.println("The sum of dimension " + j2 + " was " + sum[j2]);
            }
            for (j2 = 0; j2 < vectorLength; ++j2) {
                mean[j2] = sum[j2] / (double)overAndAtThreshold;
                System.out.println("The mean of dimension " + j2 + " was " + mean[j2]);
            }
            float[][] covariance = new float[vectorLength][vectorLength];
            for (int z = 0; z < image.getStackSize(); ++z) {
                z_scaled = (double)z * z_spacing;
                for (int y = 0; y < image.getHeight(); ++y) {
                    y_scaled = (double)y * y_spacing;
                    for (int x = 0; x < image.getWidth(); ++x) {
                        double x_scaled = x;
                        byte value = data[z][y * width + x];
                        int value_int = value & 0xFF;
                        if (value_int < threshold.value) continue;
                        double diff0 = x_scaled - mean[0];
                        double diff1 = y_scaled - mean[1];
                        double diff2 = z_scaled - mean[2];
                        variance[0] = variance[0] + diff0 * diff0;
                        variance[1] = variance[1] + diff1 * diff1;
                        variance[2] = variance[2] + diff2 * diff2;
                        float[] fArray = covariance[0];
                        fArray[0] = (float)((double)fArray[0] + diff0 * diff0);
                        float[] fArray2 = covariance[0];
                        fArray2[1] = (float)((double)fArray2[1] + diff0 * diff1);
                        float[] fArray3 = covariance[0];
                        fArray3[2] = (float)((double)fArray3[2] + diff0 * diff2);
                        float[] fArray4 = covariance[1];
                        fArray4[0] = (float)((double)fArray4[0] + diff1 * diff0);
                        float[] fArray5 = covariance[1];
                        fArray5[1] = (float)((double)fArray5[1] + diff1 * diff1);
                        float[] fArray6 = covariance[1];
                        fArray6[2] = (float)((double)fArray6[2] + diff1 * diff2);
                        float[] fArray7 = covariance[2];
                        fArray7[0] = (float)((double)fArray7[0] + diff2 * diff0);
                        float[] fArray8 = covariance[2];
                        fArray8[1] = (float)((double)fArray8[1] + diff2 * diff1);
                        float[] fArray9 = covariance[2];
                        fArray9[2] = (float)((double)fArray9[2] + diff2 * diff2);
                        ++i;
                    }
                }
            }
            for (j = 0; j < vectorLength; ++j) {
                int n2 = j;
                variance[n2] = variance[n2] / (double)(overAndAtThreshold - 1);
                i = 0;
                while (i < vectorLength) {
                    float[] fArray = covariance[j];
                    int n3 = i++;
                    fArray[n3] = fArray[n3] / (float)(overAndAtThreshold - 1);
                }
                sd[j] = Math.sqrt(variance[j]);
                System.out.println("The standard deviation of dimension " + j + " was " + sd[j]);
            }
            System.out.println("Covariance:");
            for (j = 0; j < vectorLength; ++j) {
                System.out.print("  [");
                for (i = 0; i < vectorLength; ++i) {
                    System.out.print(" " + covariance[j][i] + " ");
                }
                System.out.println("]");
            }
            JacobiFloat jc = new JacobiFloat(covariance, 200);
            float[] eigenValuesFloat = jc.getEigenValues();
            float[][] eigenVectorMatrixFloat = jc.getEigenVectors();
            double[][] vectorsPacked = new double[3][3];
            vectorsPacked[0][0] = eigenVectorMatrixFloat[0][0];
            vectorsPacked[0][1] = eigenVectorMatrixFloat[1][0];
            vectorsPacked[0][2] = eigenVectorMatrixFloat[2][0];
            vectorsPacked[1][0] = eigenVectorMatrixFloat[0][1];
            vectorsPacked[1][1] = eigenVectorMatrixFloat[1][1];
            vectorsPacked[1][2] = eigenVectorMatrixFloat[2][1];
            vectorsPacked[2][0] = eigenVectorMatrixFloat[0][2];
            vectorsPacked[2][1] = eigenVectorMatrixFloat[1][2];
            vectorsPacked[2][2] = eigenVectorMatrixFloat[2][2];
            double[] eigenValues = new double[]{eigenValuesFloat[0], eigenValuesFloat[1], eigenValuesFloat[2]};
            PrincipalComponents pcaResults = new PrincipalComponents(eigenValues, vectorsPacked, mean, x_spacing, y_spacing, z_spacing);
            System.out.println(pcaResults);
            double[] big0 = (double[])pcaResults.vectors[0].clone();
            double[] big1 = (double[])pcaResults.vectors[1].clone();
            double[] big2 = (double[])pcaResults.vectors[2].clone();
            PCA_Registration.scaleDoubleArray(big0, 256.0);
            PCA_Registration.scaleDoubleArray(big1, 256.0);
            PCA_Registration.scaleDoubleArray(big2, 256.0);
            for (i = 0; i < depth; ++i) {
                ImageProcessor imp = stack.getProcessor(i + 1);
                imp.setColor(this.indexToColor(0));
                imp.moveTo((int)mean[0], (int)(mean[1] / y_spacing));
                imp.lineTo((int)(mean[0] + big0[0]), (int)(mean[1] / y_spacing + big0[1]));
                imp.setColor(this.indexToColor(1));
                imp.moveTo((int)mean[0], (int)(mean[1] / y_spacing));
                imp.lineTo((int)(mean[0] + big1[0]), (int)(mean[1] / y_spacing + big1[1]));
                imp.setColor(this.indexToColor(2));
                imp.moveTo((int)mean[0], (int)(mean[1] / y_spacing));
                imp.lineTo((int)(mean[0] + big2[0]), (int)(mean[1] / y_spacing + big2[1]));
            }
            image.updateAndDraw();
            return pcaResults;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String stacktrace = sw.toString();
            if (IJ.getApplet() == null) {
                IJ.log((String)("Error during PCA: " + e + "\n" + stacktrace));
            }
            return null;
        }
    }

    public void getSampleDistribution(ImagePlus image, double[] com, int[] valueHistogram) {
        for (int i = 0; i < 256; ++i) {
            valueHistogram[i] = 0;
        }
        com[0] = 0.0;
        com[1] = 0.0;
        com[2] = 0.0;
        double totalmass = 0.0;
        double x_acc = 0.0;
        double y_acc = 0.0;
        double z_acc = 0.0;
        ImageStack stack = image.getStack();
        int width = stack.getWidth();
        for (int z = 0; z < image.getStackSize(); ++z) {
            byte[] pixels = (byte[])stack.getPixels(z + 1);
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    int value_int;
                    byte value = pixels[y * width + x];
                    int n = value_int = value & 0xFF;
                    valueHistogram[n] = valueHistogram[n] + 1;
                    totalmass += (double)value_int;
                    x_acc += (double)(x * value_int);
                    y_acc += (double)(y * value_int);
                    z_acc += (double)(z * value_int);
                }
            }
        }
        com[0] = x_acc / totalmass;
        com[1] = y_acc / totalmass;
        com[2] = z_acc / totalmass;
        System.out.println("x centre of mass is " + com[0]);
        System.out.println("y centre of mass is " + com[1]);
        System.out.println("z centre of mass is " + com[2]);
    }

    public int aboveThresholdLengthAlong(PrincipalComponents pcaResults, int eigenvectorNumber, ImagePlus image, Threshold threshold) {
        if (eigenvectorNumber < 0 || eigenvectorNumber >= 3) {
            throw new IllegalArgumentException("Eigenvector number must be 0, 1 or 2 (not " + eigenvectorNumber + ")");
        }
        FastMatrixTransform backFromCorrectAspect = pcaResults.correctAspect.inverse();
        backFromCorrectAspect.apply(pcaResults.vectors[eigenvectorNumber]);
        double[] v = new double[]{backFromCorrectAspect.x, backFromCorrectAspect.y, backFromCorrectAspect.z};
        backFromCorrectAspect.apply(pcaResults.meanXYZ);
        double[] start_at = new double[]{backFromCorrectAspect.x, backFromCorrectAspect.y, backFromCorrectAspect.z};
        ImageStack stack = image.getStack();
        double[] v_unit = FastMatrixTransform.normalize((double[])v);
        int w = image.getWidth();
        int h = image.getHeight();
        int d = image.getStackSize();
        int[] lastAlong = new int[2];
        lastAlong[1] = 0;
        lastAlong[0] = 0;
        block0: for (int j = 0; j < 2; ++j) {
            int sign = j * 2 - 1;
            int i = 0;
            while (true) {
                int x = (int)(start_at[0] + v_unit[0] * (double)i * (double)sign);
                int y = (int)(start_at[1] + v_unit[1] * (double)i * (double)sign);
                int z = (int)(start_at[2] + v_unit[2] * (double)i * (double)sign);
                if (x < 0 || x >= w || y < 0 || y >= h || z < 0 || z >= d) continue block0;
                byte value = ((byte[])stack.getPixels(z + 1))[x + y * w];
                int valueInteger = value & 0xFF;
                if (valueInteger >= threshold.value) {
                    lastAlong[j] = i;
                }
                ++i;
            }
        }
        return lastAlong[0] + lastAlong[1];
    }

    public void chooseStacks() {
        String none;
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.error((String)"PCA_Registration.chooseStacks(): No images are open.");
            return;
        }
        String[] titles = new String[wList.length + 1];
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage((int)wList[i]);
            titles[i] = imp != null ? imp.getTitle() : "";
        }
        titles[wList.length] = none = "*None*";
        GenericDialog gd = new GenericDialog("RGB Merge");
        gd.addChoice("Template stack:", titles, titles[0]);
        gd.addChoice("Stack to transform:", titles, titles[1]);
        gd.addCheckbox("Keep source images", true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int[] index = new int[]{gd.getNextChoiceIndex(), gd.getNextChoiceIndex()};
        this.keepSourceImages = gd.getNextBoolean();
        this.sourceImages = new ImagePlus[2];
        boolean stackSize = false;
        boolean width = false;
        boolean height = false;
        this.sourceImages[0] = WindowManager.getImage((int)wList[index[0]]);
        this.sourceImages[1] = WindowManager.getImage((int)wList[index[1]]);
        double[] com0 = new double[3];
        double[] com1 = new double[3];
        int[] valueHistogram0 = new int[256];
        int[] valueHistogram1 = new int[256];
        this.getSampleDistribution(this.sourceImages[0], com0, valueHistogram0);
        this.getSampleDistribution(this.sourceImages[1], com1, valueHistogram1);
        Threshold threshold0 = this.threshold(valueHistogram0, 0.15f);
        System.out.println("Threshold for image 0 is at: " + threshold0.value + " (number below: " + threshold0.belowThreshold + ")");
        Threshold threshold1 = this.threshold(valueHistogram1, 0.15f);
        System.out.println("Threshold for image 1 is at: " + threshold1.value + " (number below: " + threshold1.belowThreshold + ")");
        PrincipalComponents templatePCs = this.doPCA(this.sourceImages[0], threshold0, false);
        PrincipalComponents domainPCs = this.doPCA(this.sourceImages[1], threshold1, false);
        IntensityMap intensityMap = IntensityMap.fromHistograms(valueHistogram0, valueHistogram1, threshold0, threshold1);
        intensityMap.setup("", this.sourceImages[1]);
        intensityMap.run(this.sourceImages[1].getProcessor());
        double[][] tmpTranslateDomain = new double[][]{{0.0, 0.0, 0.0, -domainPCs.meanXYZ[0]}, {0.0, 0.0, 0.0, -domainPCs.meanXYZ[1]}, {0.0, 0.0, 0.0, -domainPCs.meanXYZ[2]}};
        FastMatrixTransform translateDomainToMean = new FastMatrixTransform((double[][])tmpTranslateDomain).plus(new FastMatrixTransform(1.0));
        FastMatrixTransform translateDomainBackFromMean = new FastMatrixTransform((double[][])tmpTranslateDomain).scale(-1.0, -1.0, -1.0).plus(new FastMatrixTransform(1.0));
        double[][] tmpTranslateTemplate = new double[][]{{0.0, 0.0, 0.0, -templatePCs.meanXYZ[0]}, {0.0, 0.0, 0.0, -templatePCs.meanXYZ[1]}, {0.0, 0.0, 0.0, -templatePCs.meanXYZ[2]}};
        FastMatrixTransform translateTemplateToMean = new FastMatrixTransform((double[][])tmpTranslateTemplate).plus(new FastMatrixTransform(1.0));
        FastMatrixTransform translateTemplateBackFromMean = new FastMatrixTransform((double[][])tmpTranslateTemplate).scale(-1.0, -1.0, -1.0).plus(new FastMatrixTransform(1.0));
        FastMatrixTransform finalTranslationsMatrix = FastMatrixTransform.translate((double)(templatePCs.meanXYZ[0] - domainPCs.meanXYZ[0]), (double)(templatePCs.meanXYZ[1] - domainPCs.meanXYZ[1]), (double)(templatePCs.meanXYZ[2] - domainPCs.meanXYZ[2]));
        System.out.println("finalTranslationsMatrix is:\n" + finalTranslationsMatrix.toStringIndented("  "));
        double[] v2_domain = (double[])domainPCs.vectors[2].clone();
        double[] v1_domain = (double[])domainPCs.vectors[1].clone();
        double[] v2_template = (double[])templatePCs.vectors[2].clone();
        double[] v1_template = (double[])templatePCs.vectors[1].clone();
        FastMatrixTransform[] rotations = new FastMatrixTransform[4];
        rotations[0] = new FastMatrixTransform(FastMatrix.rotateToAlignVectors((double[])v2_template, (double[])v1_template, (double[])v2_domain, (double[])v1_domain));
        PCA_Registration.scaleDoubleArray(v1_domain, -1.0);
        rotations[1] = new FastMatrixTransform(FastMatrix.rotateToAlignVectors((double[])v2_template, (double[])v1_template, (double[])v2_domain, (double[])v1_domain));
        PCA_Registration.scaleDoubleArray(v2_domain, -1.0);
        PCA_Registration.scaleDoubleArray(v1_domain, -1.0);
        rotations[2] = new FastMatrixTransform(FastMatrix.rotateToAlignVectors((double[])v2_template, (double[])v1_template, (double[])v2_domain, (double[])v1_domain));
        PCA_Registration.scaleDoubleArray(v1_domain, -1.0);
        rotations[3] = new FastMatrixTransform(FastMatrix.rotateToAlignVectors((double[])v2_template, (double[])v1_template, (double[])v2_domain, (double[])v1_domain));
        int lengthIn0 = this.aboveThresholdLengthAlong(templatePCs, 2, this.sourceImages[0], threshold0);
        int lengthIn1 = this.aboveThresholdLengthAlong(domainPCs, 2, this.sourceImages[1], threshold1);
        System.out.println("Length in image 0: " + lengthIn0);
        System.out.println("Length in image 1: " + lengthIn1);
        double scaleFactor = (double)lengthIn0 / (double)lengthIn1;
        FastMatrixTransform scaling = lengthIn0 == 0 || lengthIn1 == 0 ? new FastMatrixTransform(1.0) : new FastMatrixTransform(scaleFactor);
        System.out.println("... so scaling factor is: " + scaleFactor);
        OrderedTransformations[] transformations = new OrderedTransformations[4];
        double[] scores = new double[4];
        for (int i = 0; i < 4; ++i) {
            transformations[i] = new OrderedTransformations();
            transformations[i].addLast((Transform)domainPCs.correctAspect);
            transformations[i].addLast((Transform)translateDomainToMean);
            transformations[i].addLast((Transform)rotations[i]);
            transformations[i].addLast((Transform)scaling);
            transformations[i].addLast((Transform)translateDomainBackFromMean);
            transformations[i].addLast((Transform)finalTranslationsMatrix);
            transformations[i].addLast((Transform)templatePCs.correctAspect.inverse());
            System.out.println("... before reduction, transform has " + transformations[i].number() + " elements:\n" + transformations[i]);
            transformations[i].reduce();
            System.out.println("... after reduction, transform has " + transformations[i].number() + " elements:\n" + transformations[i]);
            scores[i] = transformations[i].scoreTransformationThresholded(this.sourceImages[0], this.sourceImages[1], threshold0, threshold1, 7);
            System.out.println("Score of transformation " + i + " was " + scores[i]);
            System.gc();
        }
        int bestIndex = 0;
        double bestScore = scores[0];
        for (int i = 1; i < 4; ++i) {
            if (!(scores[i] < bestScore)) continue;
            bestIndex = i;
            bestScore = scores[i];
        }
        System.out.println("Picked transformation with index: " + bestIndex + " and score: " + bestScore);
        transformations[bestIndex].createNewImage(this.sourceImages[0], this.sourceImages[1], true);
    }
}

