/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.features.edges.EdgeTargetAnalyzer;
import fiji.plugin.trackmate.features.track.TrackIndexAnalyzer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jgrapht.graph.DefaultWeightedEdge;

public class FeatureModel {
    private final Collection<String> trackFeatures = new LinkedHashSet<String>();
    private final Map<String, String> trackFeatureNames = new HashMap<String, String>();
    private final Map<String, String> trackFeatureShortNames = new HashMap<String, String>();
    private final Map<String, Dimension> trackFeatureDimensions = new HashMap<String, Dimension>();
    private final Map<String, Boolean> trackFeatureIsInt = new HashMap<String, Boolean>();
    Map<Integer, Map<String, Double>> trackFeatureValues = new ConcurrentHashMap<Integer, Map<String, Double>>();
    private final ConcurrentHashMap<DefaultWeightedEdge, ConcurrentHashMap<String, Double>> edgeFeatureValues = new ConcurrentHashMap();
    private final Collection<String> edgeFeatures = new LinkedHashSet<String>();
    private final Map<String, String> edgeFeatureNames = new HashMap<String, String>();
    private final Map<String, String> edgeFeatureShortNames = new HashMap<String, String>();
    private final Map<String, Dimension> edgeFeatureDimensions = new HashMap<String, Dimension>();
    private final Map<String, Boolean> edgeFeatureIsInt = new HashMap<String, Boolean>();
    private final Collection<String> spotFeatures = new LinkedHashSet<String>();
    private final Map<String, String> spotFeatureNames = new HashMap<String, String>();
    private final Map<String, String> spotFeatureShortNames = new HashMap<String, String>();
    private final Map<String, Dimension> spotFeatureDimensions = new HashMap<String, Dimension>();
    private final Map<String, Boolean> spotFeatureIsInt = new HashMap<String, Boolean>();
    private final Model model;

    protected FeatureModel(Model model) {
        this.model = model;
        this.declareSpotFeatures(Spot.FEATURES, Spot.FEATURE_NAMES, Spot.FEATURE_SHORT_NAMES, Spot.FEATURE_DIMENSIONS, Spot.IS_INT);
        this.declareEdgeFeatures(EdgeTargetAnalyzer.FEATURES, EdgeTargetAnalyzer.FEATURE_NAMES, EdgeTargetAnalyzer.FEATURE_SHORT_NAMES, EdgeTargetAnalyzer.FEATURE_DIMENSIONS, EdgeTargetAnalyzer.IS_INT);
        this.declareTrackFeatures(TrackIndexAnalyzer.FEATURES, TrackIndexAnalyzer.FEATURE_NAMES, TrackIndexAnalyzer.FEATURE_SHORT_NAMES, TrackIndexAnalyzer.FEATURE_DIMENSIONS, TrackIndexAnalyzer.IS_INT);
    }

    public synchronized void putEdgeFeature(DefaultWeightedEdge edge, String feature, Double value) {
        ConcurrentHashMap<String, Double> map = this.edgeFeatureValues.get(edge);
        if (null == map) {
            map = new ConcurrentHashMap();
            this.edgeFeatureValues.put(edge, map);
        }
        map.put(feature, value);
    }

    public Double getEdgeFeature(DefaultWeightedEdge edge, String featureName) {
        ConcurrentHashMap<String, Double> map = this.edgeFeatureValues.get(edge);
        if (null == map) {
            return null;
        }
        return map.get(featureName);
    }

    public void removeEdgeFeature(DefaultWeightedEdge edge, String feature) {
        ConcurrentHashMap<String, Double> map = this.edgeFeatureValues.get(edge);
        if (null == map) {
            return;
        }
        map.remove(feature);
    }

    public Collection<String> getEdgeFeatures() {
        return this.edgeFeatures;
    }

    public void declareEdgeFeatures(Collection<String> features, Map<String, String> featureNames, Map<String, String> featureShortNames, Map<String, Dimension> featureDimensions, Map<String, Boolean> isIntFeature) {
        this.edgeFeatures.addAll(features);
        for (String feature : features) {
            String name = featureNames.get(feature);
            if (null == name) {
                throw new IllegalArgumentException("Feature " + feature + " misses a name.");
            }
            this.edgeFeatureNames.put(feature, name);
            String shortName = featureShortNames.get(feature);
            if (null == shortName) {
                throw new IllegalArgumentException("Feature " + feature + " misses a short name.");
            }
            this.edgeFeatureShortNames.put(feature, shortName);
            Dimension dimension = featureDimensions.get(feature);
            if (null == dimension) {
                throw new IllegalArgumentException("Feature " + feature + " misses a dimension.");
            }
            this.edgeFeatureDimensions.put(feature, dimension);
            Boolean isInt = isIntFeature.get(feature);
            if (null == isInt) {
                throw new IllegalArgumentException("Feature " + feature + " misses the isInt flag.");
            }
            this.edgeFeatureIsInt.put(feature, isInt);
        }
    }

    public Map<String, String> getEdgeFeatureNames() {
        return this.edgeFeatureNames;
    }

    public Map<String, String> getEdgeFeatureShortNames() {
        return this.edgeFeatureShortNames;
    }

    public Map<String, Dimension> getEdgeFeatureDimensions() {
        return this.edgeFeatureDimensions;
    }

    public Map<String, Boolean> getEdgeFeatureIsInt() {
        return this.edgeFeatureIsInt;
    }

    public Collection<String> getTrackFeatures() {
        return this.trackFeatures;
    }

    public void declareTrackFeatures(Collection<String> features, Map<String, String> featureNames, Map<String, String> featureShortNames, Map<String, Dimension> featureDimensions, Map<String, Boolean> isIntFeature) {
        this.trackFeatures.addAll(features);
        for (String feature : features) {
            String name = featureNames.get(feature);
            if (null == name) {
                throw new IllegalArgumentException("Feature " + feature + " misses a name.");
            }
            this.trackFeatureNames.put(feature, name);
            String shortName = featureShortNames.get(feature);
            if (null == shortName) {
                throw new IllegalArgumentException("Feature " + feature + " misses a short name.");
            }
            this.trackFeatureShortNames.put(feature, shortName);
            Dimension dimension = featureDimensions.get(feature);
            if (null == dimension) {
                throw new IllegalArgumentException("Feature " + feature + " misses a dimension.");
            }
            this.trackFeatureDimensions.put(feature, dimension);
            Boolean isInt = isIntFeature.get(feature);
            if (null == isInt) {
                throw new IllegalArgumentException("Feature " + feature + " misses the isInt flag.");
            }
            this.trackFeatureIsInt.put(feature, isInt);
        }
    }

    public Map<String, String> getTrackFeatureNames() {
        return this.trackFeatureNames;
    }

    public Map<String, String> getTrackFeatureShortNames() {
        return this.trackFeatureShortNames;
    }

    public Map<String, Dimension> getTrackFeatureDimensions() {
        return this.trackFeatureDimensions;
    }

    public Map<String, Boolean> getTrackFeatureIsInt() {
        return this.trackFeatureIsInt;
    }

    public synchronized void putTrackFeature(Integer trackID, String feature, Double value) {
        Map<String, Double> trackFeatureMap = this.trackFeatureValues.get(trackID);
        if (null == trackFeatureMap) {
            trackFeatureMap = new HashMap<String, Double>(this.trackFeatures.size());
            this.trackFeatureValues.put(trackID, trackFeatureMap);
        }
        trackFeatureMap.put(feature, value);
    }

    public void removeTrackFeature(Integer trackID, String feature) {
        Map<String, Double> map = this.trackFeatureValues.get(trackID);
        if (null == map) {
            return;
        }
        map.remove(feature);
    }

    public Double getTrackFeature(Integer trackID, String feature) {
        Map<String, Double> valueMap = this.trackFeatureValues.get(trackID);
        return valueMap == null ? null : valueMap.get(feature);
    }

    public Map<String, double[]> getTrackFeatureValues() {
        HashMap<String, double[]> featureValues = new HashMap<String, double[]>();
        int nTracks = this.model.getTrackModel().nTracks(false);
        for (String feature : this.trackFeatures) {
            boolean noDataFlag = true;
            double[] values = new double[nTracks];
            int index = 0;
            for (Integer trackID : this.model.getTrackModel().trackIDs(false)) {
                Double val = this.getTrackFeature(trackID, feature);
                if (null == val) continue;
                values[index++] = val;
                noDataFlag = false;
            }
            if (!noDataFlag) continue;
            featureValues.put(feature, noDataFlag ? new double[]{} : values);
        }
        return featureValues;
    }

    public void declareSpotFeatures(Collection<String> features, Map<String, String> featureNames, Map<String, String> featureShortNames, Map<String, Dimension> featureDimensions, Map<String, Boolean> isIntFeature) {
        this.spotFeatures.addAll(features);
        for (String feature : features) {
            String name = featureNames.get(feature);
            if (null == name) {
                throw new IllegalArgumentException("Feature " + feature + " misses a name.");
            }
            this.spotFeatureNames.put(feature, name);
            String shortName = featureShortNames.get(feature);
            if (null == shortName) {
                throw new IllegalArgumentException("Feature " + feature + " misses a short name.");
            }
            this.spotFeatureShortNames.put(feature, shortName);
            Dimension dimension = featureDimensions.get(feature);
            if (null == dimension) {
                throw new IllegalArgumentException("Feature " + feature + " misses a dimension.");
            }
            this.spotFeatureDimensions.put(feature, dimension);
            Boolean isInt = isIntFeature.get(feature);
            if (null == isInt) {
                throw new IllegalArgumentException("Feature " + feature + " misses the isInt flag.");
            }
            this.spotFeatureIsInt.put(feature, isInt);
        }
    }

    public Collection<String> getSpotFeatures() {
        return this.spotFeatures;
    }

    public Map<String, String> getSpotFeatureNames() {
        return this.spotFeatureNames;
    }

    public Map<String, String> getSpotFeatureShortNames() {
        return this.spotFeatureShortNames;
    }

    public Map<String, Dimension> getSpotFeatureDimensions() {
        return this.spotFeatureDimensions;
    }

    public Map<String, Boolean> getSpotFeatureIsInt() {
        return this.spotFeatureIsInt;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Spot features declared:\n");
        FeatureModel.appendFeatureDeclarations(str, this.spotFeatures, this.spotFeatureNames, this.spotFeatureShortNames, this.spotFeatureDimensions, this.spotFeatureIsInt);
        str.append('\n');
        str.append("Edge features declared:\n");
        FeatureModel.appendFeatureDeclarations(str, this.edgeFeatures, this.edgeFeatureNames, this.edgeFeatureShortNames, this.edgeFeatureDimensions, this.edgeFeatureIsInt);
        str.append('\n');
        str.append("Track features declared:\n");
        FeatureModel.appendFeatureDeclarations(str, this.trackFeatures, this.trackFeatureNames, this.trackFeatureShortNames, this.trackFeatureDimensions, this.trackFeatureIsInt);
        str.append('\n');
        return str.toString();
    }

    public String echo() {
        StringBuilder str = new StringBuilder();
        str.append("Spot features:\n");
        str.append(" - Declared:\n");
        FeatureModel.appendFeatureDeclarations(str, this.spotFeatures, this.spotFeatureNames, this.spotFeatureShortNames, this.spotFeatureDimensions, this.spotFeatureIsInt);
        str.append('\n');
        str.append("Edge features:\n");
        str.append(" - Declared:\n");
        FeatureModel.appendFeatureDeclarations(str, this.edgeFeatures, this.edgeFeatureNames, this.edgeFeatureShortNames, this.edgeFeatureDimensions, this.edgeFeatureIsInt);
        str.append('\n');
        str.append(" - Values:\n");
        FeatureModel.appendFeatureValues(str, this.edgeFeatureValues);
        str.append("Track features:\n");
        str.append(" - Declared:\n");
        FeatureModel.appendFeatureDeclarations(str, this.trackFeatures, this.trackFeatureNames, this.trackFeatureShortNames, this.trackFeatureDimensions, this.trackFeatureIsInt);
        str.append('\n');
        str.append(" - Values:\n");
        FeatureModel.appendFeatureValues(str, this.trackFeatureValues);
        return str.toString();
    }

    private static final <K> void appendFeatureValues(StringBuilder str, Map<K, ? extends Map<String, Double>> values) {
        for (K key : values.keySet()) {
            String header = "   - " + key.toString() + ":\n";
            str.append(header);
            Map<String, Double> map = values.get(key);
            for (String feature : map.keySet()) {
                str.append("     - " + feature + " = " + String.valueOf(map.get(feature)) + "\n");
            }
        }
    }

    private static final void appendFeatureDeclarations(StringBuilder str, Collection<String> features, Map<String, String> featureNames, Map<String, String> featureShortNames, Map<String, Dimension> featureDimensions, Map<String, Boolean> isIntFeature) {
        for (String feature : features) {
            str.append("   - " + feature + ": " + featureNames.get(feature) + ", '" + featureShortNames.get(feature) + "' (" + String.valueOf((Object)featureDimensions.get(feature)) + ")");
            if (isIntFeature.get(feature).booleanValue()) {
                str.append(" - integer valued.\n");
                continue;
            }
            str.append(" - double valued.\n");
        }
    }
}

