/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.TrackMatePlugIn;
import fiji.plugin.trackmate.detection.ManualDetectorFactory;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.wizard.WizardSequence;
import fiji.plugin.trackmate.tracking.manual.ManualTrackerFactory;
import ij.ImageJ;
import ij.ImagePlus;

public class ManualTrackingPlugIn
extends TrackMatePlugIn {
    @Override
    protected WizardSequence createSequence(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings) {
        WizardSequence sequence = super.createSequence(trackmate, selectionModel, displaySettings);
        sequence.setCurrent("ConfigureViews");
        return sequence;
    }

    @Override
    protected Settings createSettings(ImagePlus imp) {
        Settings lSettings = super.createSettings(imp);
        lSettings.detectorFactory = new ManualDetectorFactory();
        lSettings.detectorSettings = lSettings.detectorFactory.getDefaultSettings();
        lSettings.trackerFactory = new ManualTrackerFactory();
        lSettings.trackerSettings = lSettings.trackerFactory.getDefaultSettings();
        return lSettings;
    }

    @Override
    protected TrackMate createTrackMate(Model model, Settings settings) {
        TrackMate trackmate = super.createTrackMate(model, settings);
        trackmate.computeSpotFeatures(false);
        trackmate.computeEdgeFeatures(false);
        trackmate.computeTrackFeatures(false);
        return trackmate;
    }

    public static void main(String[] args) {
        ImageJ.main((String[])args);
        new ManualTrackingPlugIn().run("samples/Merged.tif");
    }
}

