/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action.fit;

import fiji.plugin.trackmate.gui.Fonts;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;

public class SpotFitterPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JComboBox<String> cmbboxModel;
    final JButton btnUndo;
    final JButton btnFit;
    final JRadioButton rdbtnAll;
    final JRadioButton rdbtnSelection;
    final JRadioButton rdbtnTracks;
    private final JSlider sliderChannel;

    public SpotFitterPanel(List<String> fits, List<String> docs, int nChannels) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblTitle = new JLabel("Refine spot position by fitting");
        lblTitle.setFont(Fonts.BIG_FONT);
        lblTitle.setHorizontalAlignment(0);
        GridBagConstraints gbcLblTitle = new GridBagConstraints();
        gbcLblTitle.gridwidth = 2;
        gbcLblTitle.fill = 1;
        gbcLblTitle.insets = new Insets(5, 5, 5, 5);
        gbcLblTitle.gridx = 0;
        gbcLblTitle.gridy = 0;
        this.add((Component)lblTitle, gbcLblTitle);
        JLabel lblChannel = new JLabel("Channel:");
        this.sliderChannel = new JSlider(1, nChannels, 1);
        if (nChannels > 1) {
            GridBagConstraints gbcLblChannel = new GridBagConstraints();
            gbcLblChannel.anchor = 13;
            gbcLblChannel.insets = new Insets(5, 5, 5, 5);
            gbcLblChannel.gridx = 0;
            gbcLblChannel.gridy = 1;
            this.add((Component)lblChannel, gbcLblChannel);
            JPanel panelSlider = new JPanel();
            GridBagConstraints gbc_panelSlider = new GridBagConstraints();
            gbc_panelSlider.fill = 1;
            gbc_panelSlider.insets = new Insets(5, 5, 5, 5);
            gbc_panelSlider.gridx = 1;
            gbc_panelSlider.gridy = 1;
            this.add((Component)panelSlider, gbc_panelSlider);
            panelSlider.setLayout(new BoxLayout(panelSlider, 0));
            panelSlider.add(this.sliderChannel);
            this.sliderChannel.setPaintLabels(true);
            this.sliderChannel.setSnapToTicks(true);
            this.sliderChannel.setPaintTicks(true);
            this.sliderChannel.setFont(Fonts.SMALL_FONT);
            JLabel lblChannelIndex = new JLabel("1");
            lblChannelIndex.setFont(Fonts.FONT.deriveFont(1));
            lblChannelIndex.setHorizontalAlignment(0);
            panelSlider.add(lblChannelIndex);
            this.sliderChannel.addChangeListener(e -> lblChannelIndex.setText("" + this.sliderChannel.getValue()));
        }
        JLabel lblFitType = new JLabel("Fit type:");
        lblFitType.setFont(Fonts.FONT);
        GridBagConstraints gbcLblFitType = new GridBagConstraints();
        gbcLblFitType.anchor = 13;
        gbcLblFitType.insets = new Insets(5, 5, 5, 5);
        gbcLblFitType.gridx = 0;
        gbcLblFitType.gridy = 2;
        this.add((Component)lblFitType, gbcLblFitType);
        String[] arr = fits.toArray(new String[0]);
        this.cmbboxModel = new JComboBox<String>(arr);
        this.cmbboxModel.setFont(Fonts.FONT);
        GridBagConstraints gbcComboBox = new GridBagConstraints();
        gbcComboBox.insets = new Insets(5, 5, 5, 5);
        gbcComboBox.fill = 2;
        gbcComboBox.gridx = 1;
        gbcComboBox.gridy = 2;
        this.add(this.cmbboxModel, gbcComboBox);
        JLabel lblDoc = new JLabel(" ");
        lblDoc.setFont(Fonts.SMALL_FONT);
        GridBagConstraints gbcLblDoc = new GridBagConstraints();
        gbcLblDoc.fill = 2;
        gbcLblDoc.gridwidth = 2;
        gbcLblDoc.insets = new Insets(5, 5, 5, 5);
        gbcLblDoc.gridx = 0;
        gbcLblDoc.gridy = 3;
        this.add((Component)lblDoc, gbcLblDoc);
        JPanel panelSelection = new JPanel();
        GridBagConstraints gbcPanelSelection = new GridBagConstraints();
        gbcPanelSelection.gridwidth = 2;
        gbcPanelSelection.insets = new Insets(5, 5, 5, 5);
        gbcPanelSelection.fill = 2;
        gbcPanelSelection.gridx = 0;
        gbcPanelSelection.gridy = 4;
        this.add((Component)panelSelection, gbcPanelSelection);
        panelSelection.setLayout(new BoxLayout(panelSelection, 0));
        JLabel lblPerformOn = new JLabel("Fit:");
        lblPerformOn.setFont(Fonts.FONT);
        panelSelection.add(lblPerformOn);
        this.rdbtnAll = new JRadioButton("All spots");
        this.rdbtnSelection = new JRadioButton("Selection");
        this.rdbtnTracks = new JRadioButton("Tracks of selection");
        this.rdbtnAll.setFont(Fonts.FONT);
        this.rdbtnSelection.setFont(Fonts.FONT);
        this.rdbtnTracks.setFont(Fonts.FONT);
        panelSelection.add(Box.createHorizontalGlue());
        panelSelection.add(this.rdbtnAll);
        panelSelection.add(this.rdbtnSelection);
        panelSelection.add(this.rdbtnTracks);
        JPanel panelButtons = new JPanel();
        GridBagConstraints gbcPanelButtons = new GridBagConstraints();
        gbcPanelButtons.gridwidth = 2;
        gbcPanelButtons.fill = 1;
        gbcPanelButtons.gridx = 0;
        gbcPanelButtons.gridy = 5;
        this.add((Component)panelButtons, gbcPanelButtons);
        panelButtons.setLayout(new BoxLayout(panelButtons, 0));
        this.btnUndo = new JButton("Undo last fit");
        this.btnUndo.setFont(Fonts.FONT);
        panelButtons.add(this.btnUndo);
        Component horizontalGlue = Box.createHorizontalGlue();
        panelButtons.add(horizontalGlue);
        this.btnFit = new JButton("Fit");
        this.btnFit.setFont(Fonts.FONT);
        panelButtons.add(this.btnFit);
        ButtonGroup btngroup = new ButtonGroup();
        btngroup.add(this.rdbtnAll);
        btngroup.add(this.rdbtnSelection);
        btngroup.add(this.rdbtnTracks);
        this.rdbtnSelection.setSelected(true);
        this.cmbboxModel.addActionListener(e -> lblDoc.setText((String)docs.get(this.cmbboxModel.getSelectedIndex())));
        this.cmbboxModel.setSelectedIndex(0);
    }

    public int getSelectedChannel() {
        return this.sliderChannel.getValue();
    }

    public int getSelectedFitIndex() {
        return this.cmbboxModel.getSelectedIndex();
    }
}

