/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.detection.DogDetector;
import fiji.plugin.trackmate.detection.LogDetectorFactory;
import fiji.plugin.trackmate.detection.SpotDetector;
import fiji.plugin.trackmate.detection.SpotDetectorFactory;
import fiji.plugin.trackmate.util.TMUtils;
import java.util.Map;
import net.imagej.ImgPlus;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotDetectorFactory.class)
public class DogDetectorFactory<T extends RealType<T> & NativeType<T>>
extends LogDetectorFactory<T> {
    public static final String THIS_DETECTOR_KEY = "DOG_DETECTOR";
    public static final String THIS_NAME = "DoG detector";
    public static final String THIS_INFO_TEXT = "<html>This detector is based on an approximation of the LoG operator <br> by differences of Gaussian (DoG). Computations are made in direct space. <br>It is the quickest for small spot sizes (< ~5 pixels). <p> Spots found too close are suppressed. This detector can do sub-pixel <br>localization of spots using a quadratic fitting scheme. It is based on <br>the scale-space framework made by Stephan Preibisch for ImgLib. </html>";
    public static final String URL_DOC = "https://imagej.net/plugins/trackmate/detectors/difference-of-gaussian";

    @Override
    public SpotDetector<T> getDetector(ImgPlus<T> img, Map<String, Object> settings, Interval interval, int frame) {
        double radius = (Double)settings.get("RADIUS");
        double threshold = (Double)settings.get("THRESHOLD");
        boolean doMedian = (Boolean)settings.get("DO_MEDIAN_FILTERING");
        boolean doSubpixel = (Boolean)settings.get("DO_SUBPIXEL_LOCALIZATION");
        double[] calibration = TMUtils.getSpatialCalibration(img);
        int channel = (Integer)settings.get("TARGET_CHANNEL") - 1;
        RandomAccessibleInterval<T> imFrame = DetectionUtils.prepareFrameImg(img, channel, frame);
        DogDetector<T> detector = new DogDetector<T>(imFrame, interval, calibration, radius, threshold, doSubpixel, doMedian);
        detector.setNumThreads(1);
        return detector;
    }

    @Override
    public String getKey() {
        return THIS_DETECTOR_KEY;
    }

    @Override
    public String getName() {
        return THIS_NAME;
    }

    @Override
    public String getInfoText() {
        return THIS_INFO_TEXT;
    }

    @Override
    public String getUrl() {
        return URL_DOC;
    }
}

