/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.graph;

import fiji.plugin.trackmate.Spot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.util.NeighborCache;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.util.ModifiableInteger;

public class TimeDirectedNeighborIndex
extends NeighborCache<Spot, DefaultWeightedEdge> {
    Map<Spot, Neighbors<Spot, DefaultWeightedEdge>> predecessorMap = new HashMap<Spot, Neighbors<Spot, DefaultWeightedEdge>>();
    Map<Spot, Neighbors<Spot, DefaultWeightedEdge>> successorMap = new HashMap<Spot, Neighbors<Spot, DefaultWeightedEdge>>();
    private final Graph<Spot, DefaultWeightedEdge> graph;

    public TimeDirectedNeighborIndex(Graph<Spot, DefaultWeightedEdge> g) {
        super(g);
        this.graph = g;
    }

    public Set<Spot> predecessorsOf(Spot v) {
        return this.getPredecessors(v).getNeighbors();
    }

    public List<Spot> predecessorListOf(Spot v) {
        return this.getPredecessors(v).getNeighborList();
    }

    public Set<Spot> successorsOf(Spot v) {
        return this.getSuccessors(v).getNeighbors();
    }

    public List<Spot> successorListOf(Spot v) {
        return this.getSuccessors(v).getNeighborList();
    }

    public void edgeAdded(GraphEdgeChangeEvent<Spot, DefaultWeightedEdge> e) {
        DefaultWeightedEdge edge = (DefaultWeightedEdge)e.getEdge();
        Spot source = (Spot)this.graph.getEdgeSource((Object)edge);
        Spot target = (Spot)this.graph.getEdgeTarget((Object)edge);
        if (this.successorMap.containsKey(source)) {
            this.getSuccessors(source).addNeighbor(target);
        } else {
            this.getSuccessors(source);
        }
        if (this.predecessorMap.containsKey(target)) {
            this.getPredecessors(target).addNeighbor(source);
        } else {
            this.getPredecessors(target);
        }
    }

    public void edgeRemoved(GraphEdgeChangeEvent<Spot, DefaultWeightedEdge> e) {
        DefaultWeightedEdge edge = (DefaultWeightedEdge)e.getEdge();
        Spot source = (Spot)this.graph.getEdgeSource((Object)edge);
        Spot target = (Spot)this.graph.getEdgeTarget((Object)edge);
        if (this.successorMap.containsKey(source)) {
            this.successorMap.get(source).removeNeighbor(target);
        }
        if (this.predecessorMap.containsKey(target)) {
            this.predecessorMap.get(target).removeNeighbor(source);
        }
    }

    public void vertexAdded(GraphVertexChangeEvent<Spot> e) {
    }

    public void vertexRemoved(GraphVertexChangeEvent<Spot> e) {
        this.predecessorMap.remove(e.getVertex());
        this.successorMap.remove(e.getVertex());
    }

    private Neighbors<Spot, DefaultWeightedEdge> getPredecessors(Spot v) {
        Neighbors<Spot, Object> neighbors = this.predecessorMap.get(v);
        if (neighbors == null) {
            List nl = Graphs.neighborListOf(this.graph, (Object)v);
            ArrayList<Spot> bnl = new ArrayList<Spot>();
            int ts = v.getFeature("FRAME").intValue();
            for (Spot spot : nl) {
                int tt = spot.getFeature("FRAME").intValue();
                if (tt >= ts) continue;
                bnl.add(spot);
            }
            neighbors = new Neighbors(v, bnl);
            this.predecessorMap.put(v, neighbors);
        }
        return neighbors;
    }

    private Neighbors<Spot, DefaultWeightedEdge> getSuccessors(Spot v) {
        Neighbors<Spot, Object> neighbors = this.successorMap.get(v);
        if (neighbors == null) {
            List nl = Graphs.neighborListOf(this.graph, (Object)v);
            ArrayList<Spot> bnl = new ArrayList<Spot>();
            int ts = v.getFeature("FRAME").intValue();
            for (Spot spot : nl) {
                int tt = spot.getFeature("FRAME").intValue();
                if (tt <= ts) continue;
                bnl.add(spot);
            }
            neighbors = new Neighbors(v, bnl);
            this.successorMap.put(v, neighbors);
        }
        return neighbors;
    }

    static class Neighbors<V, E> {
        private final Map<V, ModifiableInteger> neighborCounts = new LinkedHashMap<V, ModifiableInteger>();
        private final Set<V> neighborSet = Collections.unmodifiableSet(this.neighborCounts.keySet());

        public Neighbors(V v, Collection<V> neighbors) {
            for (V neighbor : neighbors) {
                this.addNeighbor(neighbor);
            }
        }

        public void addNeighbor(V v) {
            ModifiableInteger count = this.neighborCounts.get(v);
            if (count == null) {
                count = new ModifiableInteger(1);
                this.neighborCounts.put((ModifiableInteger)v, count);
            } else {
                count.increment();
            }
        }

        public void removeNeighbor(V v) {
            ModifiableInteger count = this.neighborCounts.get(v);
            if (count == null) {
                throw new IllegalArgumentException("Attempting to remove a neighbor that wasn't present");
            }
            count.decrement();
            if (count.getValue() == 0) {
                this.neighborCounts.remove(v);
            }
        }

        public Set<V> getNeighbors() {
            return this.neighborSet;
        }

        public List<V> getNeighborList() {
            ArrayList<V> neighbors = new ArrayList<V>();
            for (Map.Entry<V, ModifiableInteger> entry : this.neighborCounts.entrySet()) {
                V v = entry.getKey();
                int count = entry.getValue().intValue();
                for (int i = 0; i < count; ++i) {
                    neighbors.add(v);
                }
            }
            return neighbors;
        }
    }
}

