/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.features.FeatureFilter;
import fiji.plugin.trackmate.features.FeatureUtils;
import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.components.FeatureDisplaySelector;
import fiji.plugin.trackmate.gui.components.FilterPanel;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.util.OnRequestUpdater;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FilterGuiPanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = -1L;
    private final ChangeEvent CHANGE_EVENT = new ChangeEvent(this);
    public ActionEvent COLOR_FEATURE_CHANGED = null;
    private final OnRequestUpdater updater;
    private final Stack<FilterPanel> filterPanels = new Stack();
    private final Stack<Component> struts = new Stack();
    private final List<FeatureFilter> featureFilters = new ArrayList<FeatureFilter>();
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private final Model model;
    private final JPanel allThresholdsPanel;
    private final JLabel lblInfo;
    private final DisplaySettings.TrackMateObject target;
    private final Settings settings;
    private final String defaultFeature;
    private final ProgressBarLogger logger;
    private final JLabel lblTop;
    private final JProgressBar progressBar;

    public FilterGuiPanel(Model model, Settings settings, DisplaySettings.TrackMateObject target, List<FeatureFilter> filters, String defaultFeature, FeatureDisplaySelector featureSelector) {
        this.model = model;
        this.settings = settings;
        this.target = target;
        this.defaultFeature = defaultFeature;
        this.updater = new OnRequestUpdater(() -> this.refresh());
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(270, 500));
        JPanel topPanel = new JPanel();
        this.add((Component)topPanel, "North");
        topPanel.setLayout(new BorderLayout(0, 0));
        this.lblTop = new JLabel("      Set filters on " + String.valueOf((Object)target));
        this.lblTop.setFont(Fonts.BIG_FONT);
        this.lblTop.setPreferredSize(new Dimension(300, 40));
        topPanel.add((Component)this.lblTop, "North");
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(1300, 40));
        topPanel.add(this.progressBar);
        JScrollPane scrollPaneThresholds = new JScrollPane();
        this.add((Component)scrollPaneThresholds, "Center");
        scrollPaneThresholds.setPreferredSize(new Dimension(250, 389));
        scrollPaneThresholds.setHorizontalScrollBarPolicy(31);
        scrollPaneThresholds.setVerticalScrollBarPolicy(22);
        this.allThresholdsPanel = new JPanel();
        BoxLayout jPanelAllThresholdsLayout = new BoxLayout(this.allThresholdsPanel, 1);
        this.allThresholdsPanel.setLayout(jPanelAllThresholdsLayout);
        scrollPaneThresholds.setViewportView(this.allThresholdsPanel);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        this.add((Component)bottomPanel, "South");
        JPanel buttonsPanel = new JPanel();
        bottomPanel.add((Component)buttonsPanel, "North");
        BoxLayout jPanelButtonsLayout = new BoxLayout(buttonsPanel, 0);
        buttonsPanel.setLayout(jPanelButtonsLayout);
        buttonsPanel.setPreferredSize(new Dimension(270, 22));
        buttonsPanel.setSize(270, 25);
        buttonsPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        buttonsPanel.add(Box.createHorizontalStrut(5));
        JButton btnAddThreshold = new JButton();
        buttonsPanel.add(btnAddThreshold);
        btnAddThreshold.setIcon(Icons.ADD_ICON);
        btnAddThreshold.setFont(Fonts.SMALL_FONT);
        btnAddThreshold.setPreferredSize(new Dimension(24, 24));
        btnAddThreshold.setSize(24, 24);
        btnAddThreshold.setMinimumSize(new Dimension(24, 24));
        buttonsPanel.add(Box.createHorizontalStrut(5));
        JButton btnRemoveThreshold = new JButton();
        buttonsPanel.add(btnRemoveThreshold);
        btnRemoveThreshold.setIcon(Icons.REMOVE_ICON);
        btnRemoveThreshold.setFont(Fonts.SMALL_FONT);
        btnRemoveThreshold.setPreferredSize(new Dimension(24, 24));
        btnRemoveThreshold.setSize(24, 24);
        btnRemoveThreshold.setMinimumSize(new Dimension(24, 24));
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(Box.createHorizontalStrut(5));
        this.lblInfo = new JLabel();
        this.lblInfo.setFont(Fonts.SMALL_FONT);
        buttonsPanel.add(this.lblInfo);
        JPanel coloringPanel = featureSelector.createSelectorFor(target);
        coloringPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        bottomPanel.add((Component)coloringPanel, "Center");
        btnAddThreshold.addActionListener(e -> this.addFilterPanel());
        btnRemoveThreshold.addActionListener(e -> this.removeThresholdPanel());
        for (FeatureFilter ft : filters) {
            this.addFilterPanel(ft);
        }
        this.lblTop.setVisible(false);
        this.logger = new ProgressBarLogger();
        GuiUtils.addOnClosingEvent(this, () -> this.updater.quit());
    }

    public void refreshValues() {
        for (FilterPanel filterPanel : this.filterPanels) {
            filterPanel.refresh();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updater.doUpdate();
    }

    public List<FeatureFilter> getFeatureFilters() {
        return this.featureFilters;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public boolean removeChangeListener(ChangeListener listener) {
        return this.changeListeners.remove(listener);
    }

    public Collection<ChangeListener> getChangeListeners() {
        return this.changeListeners;
    }

    public void addFilterPanel() {
        this.addFilterPanel(this.guessNextFeature());
    }

    public void addFilterPanel(String feature) {
        FeatureFilter filter = new FeatureFilter(feature, Double.NaN, true);
        this.addFilterPanel(filter);
    }

    public void addFilterPanel(FeatureFilter filter) {
        Map<String, String> featureNames = FeatureUtils.collectFeatureKeys(this.target, this.model, this.settings);
        Function<String, double[]> valueCollector = featureKey -> FeatureUtils.collectFeatureValues(featureKey, this.target, this.model, false);
        FilterPanel tp = new FilterPanel(featureNames, valueCollector, filter);
        tp.addChangeListener(this);
        Component strut = Box.createVerticalStrut(5);
        this.struts.push(strut);
        this.filterPanels.push(tp);
        this.allThresholdsPanel.add(tp);
        this.allThresholdsPanel.add(strut);
        this.allThresholdsPanel.revalidate();
        this.stateChanged(this.CHANGE_EVENT);
    }

    public void showProgressBar(boolean show) {
        this.progressBar.setVisible(show);
        this.lblTop.setVisible(!show);
    }

    public Logger getLogger() {
        return this.logger;
    }

    private void fireThresholdChanged(ChangeEvent e) {
        for (ChangeListener cl : this.changeListeners) {
            cl.stateChanged(e);
        }
    }

    private String guessNextFeature() {
        Map<String, String> featureNames = FeatureUtils.collectFeatureKeys(this.target, this.model, this.settings);
        Iterator<String> it = featureNames.keySet().iterator();
        if (!it.hasNext()) {
            return "";
        }
        if (this.featureFilters.isEmpty()) {
            return this.defaultFeature == null || !featureNames.keySet().contains(this.defaultFeature) ? it.next() : this.defaultFeature;
        }
        FeatureFilter lastFilter = this.featureFilters.get(this.featureFilters.size() - 1);
        String lastFeature = lastFilter.feature;
        while (it.hasNext()) {
            if (!it.next().equals(lastFeature) || !it.hasNext()) continue;
            return it.next();
        }
        return featureNames.keySet().iterator().next();
    }

    private void removeThresholdPanel() {
        try {
            FilterPanel tp = this.filterPanels.pop();
            tp.removeChangeListener(this);
            Component strut = this.struts.pop();
            this.allThresholdsPanel.remove(strut);
            this.allThresholdsPanel.remove(tp);
            this.allThresholdsPanel.repaint();
            this.stateChanged(this.CHANGE_EVENT);
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    private void refresh() {
        this.featureFilters.clear();
        for (FilterPanel tp : this.filterPanels) {
            this.featureFilters.add(tp.getFilter());
        }
        this.fireThresholdChanged(null);
        this.updateInfoText();
    }

    private void updateInfoText() {
        Map<String, String> featureNames = FeatureUtils.collectFeatureKeys(this.target, this.model, this.settings);
        if (featureNames.isEmpty()) {
            this.lblInfo.setText("No features found.");
            return;
        }
        int nobjects = FeatureUtils.nObjects(this.model, this.target, false);
        if (this.featureFilters == null || this.featureFilters.isEmpty()) {
            String info = "Keep all " + nobjects + " " + String.valueOf((Object)this.target) + ".";
            this.lblInfo.setText(info);
            return;
        }
        int nselected = FeatureUtils.nObjects(this.model, this.target, true);
        String info = "Keep " + nselected + " " + String.valueOf((Object)this.target) + " out of  " + nobjects + ".";
        this.lblInfo.setText(info);
    }

    private final class ProgressBarLogger
    extends Logger {
        private ProgressBarLogger() {
        }

        @Override
        public void error(String message) {
            this.log(message, Logger.ERROR_COLOR);
        }

        @Override
        public void log(String message, Color color) {
            SwingUtilities.invokeLater(() -> FilterGuiPanel.this.progressBar.setString(message));
        }

        @Override
        public void setStatus(String status) {
            SwingUtilities.invokeLater(() -> FilterGuiPanel.this.progressBar.setString(status));
        }

        @Override
        public void setProgress(double val) {
            if (val < 0.0) {
                val = 0.0;
            }
            if (val > 1.0) {
                val = 1.0;
            }
            int intVal = (int)(val * 100.0);
            SwingUtilities.invokeLater(() -> FilterGuiPanel.this.progressBar.setValue(intVal));
        }
    }
}

